/***************************************************************************
 *                                                                         *
 *   AIN.C                                                                 *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   ANSI X3.64 keystroke sequence - to - keystroke code translator        *
 *                                                                         *
 *   With operating-system-specific functions removed (I/O, memory)        *
 *   the pure translation algorithm can be isolated.                       *
 *                                                                         *
 *                                             - R. Stein  11/ 9/91        *
 *                                             - A. James  11/11/91        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "ain.h"

#define FILREV "$Revision: 1.2 $"

struct ainscb *ainscb;

void
ainbeg(void)                 /* initialize ANSI-getchc() conversion session */
{
     ainscb->state=WT4ESC;
}

int
ainchr(         /* translate ANSI keystrokes into getchc()-style keystrokes */
char c)
{
     int rc;

     switch (ainscb->state) {
     default:
          ainscb->state=WT4ESC;
     case WT4ESC:
          if (c != ESC) {
               return(c);
          }
          ainscb->state=WT4BKT;
          return(0);
     case WT4BKT:
          switch (c) {
          case '[':
               ainscb->state=WT4ALP;
               return(0);
          case 'O':
               ainscb->state=WT4LTO;
               rc=0;
               break;
          default:
               ainscb->state=WT4ESC;
               rc=c;
          }
          break;
     case WT4ALP:
          switch (c) {
          case 'A':
               ainscb->state=WT4ESC;
               return(CRSRUP);
          case 'B':
               ainscb->state=WT4ESC;
               return(CRSRDN);
          case 'C':
               ainscb->state=WT4ESC;
               return(CRSRRT);
          case 'D':
               ainscb->state=WT4ESC;
               return(CRSRLF);
          case 'H':
          case 'f':
               rc=HOME;
               break;
          case 'K':
               rc=END;
               break;
          default:
               if (isdigit(c) || c == ';') {
                    return(0);
               }
               rc=0;
          }
          ainscb->state=WT4ESC;
          break;
     case WT4LTO:
          switch (c) {
          case 'P':
               rc=F1;
               break;
          case 'Q':
               rc=F2;
               break;
          case 'W':
               rc=F3;
               break;
          case 'x':
               rc=F4;
               break;
          case 't':
               rc=F5;
               break;
          case 'u':
               rc=F6;
               break;
          case 'q':
               rc=F7;
               break;
          case 'r':
               rc=F8;
               break;
          default:
               rc=0;
          }
          ainscb->state=WT4ESC;
     }
     return(rc);
}

