/***************************************************************************
 *                                                                         *
 *   ABOUT.C                                                               *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.       All Rights Reserved.  *
 *                                                                         *
 *   About screen code                                                     *
 *                                                                         *
 *                                            - Robert A. Rose 02/12/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"
#include "bios.h"

#define FILREV "$Revision: 1.3 $"

unsigned abokey(unsigned scncod);
void aborep(void);
char *osversn(void);

extern int usshdl;                 /* handle for the users screen          */
int ahdl=0;                        /* handle for the about screen          */
extern int acchdl;                 /* handle for the account screen        */

extern int curdlls;                /* count of DLLs loaded                 */
extern int maxdlls;                /* maximum # of DLLs to be loaded       */

struct scrnid abouscn={
     "bbsabt.bin",                 /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_B,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     aborep,                       /* screen repaint routine               */
     abokey,                       /* key handler routine                  */
     aborep,                       /* occasional update routine            */
     180,                          /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     1,1,70,17,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

unsigned
abokey(                       /* Monitor screen keystroke handler routine  */
unsigned scncod)                        /* keystoke hit                    */
{
     switch (scncod) {
     case TAB:
          scn2mai(acchdl);
          break;
     case BAKTAB:
          scn2mai(usshdl);
          break;
     default:
          return(scncod);
     }
     return(0);
}

char *osversn(void)           /* return operating system version info      */
{
     char tmpstr[15];

     *vdatmp='\0';
     stlcpy(vdatmp,itoa(_osmajor,tmpstr,10),15);
     strcat(vdatmp,".");
     stlcat(vdatmp,itoa(_osminor,tmpstr,10),15);
     return(vdatmp);
}

void
aborep(void)                  /* About screen repaint routine              */
{
     extern unsigned maxspd,maxpol;
     unsigned long ravl=0L,eavl=0L;

     actvscn(ahdl);
     setatr(0x1E);
     printfat(15,5,"%d",nterms);
     printfat(15,4,"%s%s",version,subvers);
     printfat(48,9,"%-8.8s",dbytes(getdfre(0)));
     printfat(41,8,"%d.%d",_osmajor,_osminor);
     if (maxspd == maxpol) {
          printfat(54,3,"%.8s",l2as(maxspd));
     }
     else {
          printfat(54,3,"%s/%s",l2as(maxspd),l2as(maxpol));
     }
     printfat(15,3,"%.9s",bturno);
     printfat(54,4,"%s %s",multsk ? "Yes -" : "No",
                          !multsk ? ""
                                  : mulmth == COMIRP ? "Interrupt" : "Timer");
#ifdef PHARLAP
     DosRealAvail(&ravl);
     DosMemAvail(&eavl);
     printfat(22,8,"N/A");
     printfat(22,9,"%-8.8s",dbytes(eavl));
     printfat(22,10,"%-8.8s",dbytes(ravl));
     printfat(54,5,"%d",curdlls);
#else
     ravl=ravl;
     eavl=eavl;
     printfat(22,8,"%-8.8s",dbytes((long)1024L*biosmemory()));
     printfat(22,9,"%-8.8s",dbytes(sizmem()));
     #ifdef ECLIPSE
          printfat(22,10,"N/A");
     #else
          printfat(22,10,"%-8.8s",dbytes(sizmem()));
     #endif
#endif
     if (btrset[0] != '\0') {
          printfat(15,6,"%-30s",btrset);
     }
     else {
          printfat(15,6,"defaults");
     }
}

