/***************************************************************************
 *                                                                         *
 *   USERS.C                                                               *
 *                                                                         *
 *   Copyright (c) 1992-1995 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Users screen code                                                     *
 *                                                                         *
 *                                            - Robert A. Rose 02/13/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

unsigned usskey(unsigned scncod);
void ussrep(void);
void updbank(int bnk);
void usrchl(void);
void usrchan(int chan);

#define LILYELBOX '\376'           /* little yellow box character          */

extern int ehdl;                   /* handle for remote emulation screen   */
extern int shdl;                   /* handle for summary screen            */
int usshdl;                        /* handle for users screen              */
extern int ahdl;                   /* handle for about screen              */
extern int lsehdl;                 /* handle for emulation screen          */

int banksel=0;                     /* which bank (00,10...F0) is selected  */
int zoomlin=0;                     /* which channel (0-F) in bank is sel'd */

struct scrnid ussscn={
     "bbsusr.bin",                 /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_U,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     ussrep,                       /* screen repaint routine               */
     usskey,                       /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     10,                           /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     0,                            /* should screen scroll?                */
     1,1,79,20,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

unsigned
usskey(                       /* Users screen keystroke handler routine    */
unsigned scncod)                        /* keystroke hit                   */
{
     int usr2emu,usr2acc;
     extern int acchdl;
     void dspact(char *userid);

     switch (scncod) {
     case TAB:
          scn2mai(ahdl);
          break;
     case BAKTAB:
          scn2mai(shdl);
          break;
     case ALT_A:
          if ((usr2acc=usridx(zoomlin+(banksel<<4))) != -1) {
               usaptr=uacoff(usr2acc);
               dspact(usaptr->userid);
          }
          scn2mai(acchdl);
          break;
     case CRSRLF:
          if (banksel > 0) {
               banksel--;
               updbank(banksel);
               updbank(banksel+1);
          }
          break;
     case CRSRRT:
          if (banksel < 0x0F) {
               banksel++;
               updbank(banksel);
               updbank(banksel-1);
          }
          break;
     case CRSRUP:
          if (zoomlin > 0) {
               zoomlin--;
               updbank(banksel);
          }
          break;
     case CRSRDN:
          if (zoomlin < 0x0F) {
               zoomlin++;
               updbank(banksel);
          }
          break;
     case 0x0d:
          usr2emu=usridx(zoomlin+(banksel<<4));
          if ((usr2emu != -1) && (usr2emu != nterms-1)) {
               emuchn(usr2emu);
               scn2mai(ehdl);
          }
          if (usr2emu == nterms-1) {
               scn2mai(lsehdl);
               if (user[usr2emu].class == VACANT) {
                    entlse(usr2emu);
               }
          }
          break;
     default:
          return(scncod);
     }
     return(0);
}

void
ussrep(void)                  /* repaint the users screen                  */
{
     updbank(banksel);
}

void
updbank(                      /* update the entire right bank of legends   */
int bnk)                           /* bank to update                       */
{
     int i,cnum;

     for (i=0 ; i < 0x10 ; i++) {
          cnum=i+(bnk<<4);
          usrchan(cnum);
     }
}

void
usrchl(void)                  /* Update a user screen legend               */
{
     int chan;

     chan=channel[usrnum];
     usrchan(chan);
}

void
usrchan(                      /* Update a user channel legend              */
int chan)
{
     int chncol,chnrow;
     char *vptr;
     char catr;

     vptr=actvscn(usshdl);
     chnrow=chan&0x0F;
     chncol=(chan&0xF0)>>4;
     if (chncol == banksel) {
          catr=0x70;
     }
     else {
          if (chan < hichp1 && usridx(chan) != -1) {
               catr=uidarr[chan].attrib|0x08;
          }
          else {
               catr=0x13;
          }
     }
     *(vptr+((chnrow+2)*160)+(2*(chncol+3))+1)=scncolor(catr);
     *(vptr+((chnrow+2)*160)+(2*(chncol+3)))=chan < hichp1 ? uidarr[chan].sing : LILYELBOX;
     if (chncol == banksel) {
          setatr(0x1e);
          printfat(21,chnrow+2,"%1.1x",chncol);
     }
     if (chan < hichp1) {
          setatr(uidarr[chan].attrib&0x7f);
     }
     else {
          setatr(0x1e);
     }
     if (chnrow == zoomlin) {
          sstatr(color ? 0x50 : 0x70);
     }
     if (chncol == banksel) {
          printfat(24,chnrow+2,"%s",spr("%-*.*s",LGNSIZ-1,LGNSIZ-1,
                                chan < hichp1 ? uidarr[chan].labl : ""));
     }
}
