/***************************************************************************
 *                                                                         *
 *   UINFED.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Worldgroup user-info editor.                              *
 *                                                                         *
 *                                            - T. Stryker 7/13/86         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbssup.h"
#include "fsdbbs.h"

void EXPORT init__uinfed(void);
int uinlon(void);
int uinfed(void);
void uinsts(void);

int uinstt;                /* User account display/edit module state number */

struct module user_info={     /* module interface block               */
     "",                      /*    name used to refer to this module */
     uinlon,                  /*    user logon supplemental routine   */
     uinfed,                  /*    input routine if selected         */
     uinsts,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};

#define MAXTKC 100000000L     /* maximum char count of tick xfer request   */

char f2sys[]={0,1,2,3,0};     /* convert field+1 to systyp                 */

static
char *anschc[]= {             /* strings corresponding to ANSI settings    */
     "AUTO","AUTO","OFF","ON"
};

struct usracc *accptr;        /* user account temporary holding area & ptr */

extern
FILE *supmb;                  /* uses the signup module's message file     */
extern
int shwcrd;                   /* show user how many credits they have?     */

/*--- OPTIONS FROM BBSSUP.MSG ---*/
long mincxf;                  /* minimum number of credits per xfer oper   */
int chgbdy;                   /* allow users to change their date of birth?*/
extern
int safpsw;                   /* can a User-Id or "password" be a password */
extern
int sndrst;                   /* snd RIP_RESET_WINDOWS after sw to non-RIP?*/
extern
char *langchg;                /* key required to change language pref      */

static char uinfsp[]="\
USERID(MIN=3) \
NAME(MIN=5) \
COMPANY \
ADDRESS2(MIN=5) \
ADDRESS3(MIN=5) \
ADDRESS4 \
PHONE(MIN=7) \
COMPUTER(ALT=IBM-PC ALT=Macintosh ALT=Apple/non-Mac ALT=OTHER MULTICHOICE) \
ANSIMODE(ALT=AUTO ALT=ON ALT=OFF MULTICHOICE) \
SCREENWIDTH(MIN=40 MAX=136) \
SCREENLENGTH(MIN=3 MAX=254) \
EDITORPREF(ALT=FSE ALT=LINE MULTICHOICE) \
PAUSEOUT(ALT=PAUSE ALT=CONTINUOUS MULTICHOICE) \
BIRTHDAY(MIN=6) \
SEX(ALT=MALE ALT=FEMALE MULTICHOICE) \
PASSWORD(SECRET MIN=1) \
DONE(ALT=SAVE ALT=EDIT ALT=QUIT MULTICHOICE)";        /* Field Specs String */

static char uinfmt[]="\
USERID=%s%c\
NAME=%s%c\
COMPANY=%s%c\
ADDRESS2=%s%c\
ADDRESS3=%s%c\
ADDRESS4=%s%c\
PHONE=%s%c\
COMPUTER=%s%c\
ANSIMODE=%s%c\
SCREENWIDTH=%d%c\
SCREENLENGTH=%d%c\
EDITORPREF=%s%c\
PAUSEOUT=%s%c\
BIRTHDAY=%s%c\
SEX=%s%c\
PASSWORD=%s%c";               /* format string for creating initial answers */

#define UIDFLD 0                                           /* field indexes */
#define NAMFLD 1
#define AD1FLD 2
#define AD2FLD 3
#define AD3FLD 4
#define AD4FLD 5
#define PHOFLD 6
#define SYSFLD 7
#define ANSFLD 8
#define SCWFLD 9
#define SCLFLD 10
#define EDTFLD 11
#define PAUFLD 12
#define BDYFLD 13
#define SEXFLD 14
#define PSWFLD 15
#define XITFLD 16

static char *templt;                  /* for use by uinrft() & subordinates */

struct xfinfo {               /* credit-transfer info    */
     char tranfid[UIDSIZ];    /*   transferee's User-ID  */
     long tikreq;             /*   amount of the xfer    */
} *xfidat;

STATIC int uinvfy(int fldno,char *answer);
STATIC void uindun(int save);
STATIC void uiwipe(int askno,int fldno,int pre,int post);
STATIC char *uinrft(void);
STATIC void uinptc(void);
STATIC int checkx(void);
STATIC void go2mai(void);
STATIC void scredtr(void);
STATIC void suiden(void);
STATIC void squeryn(void);
STATIC void uinmnu(void);
STATIC void uaiprp(int msgno,int ascn);
STATIC void shwinf(struct usracc *usaptr);
STATIC long numeok(void);

void EXPORT
init__uinfed(void)                 /* initialize user info editor module   */
{
     void inicsuin(void);

     stzcpy(user_info.descrp,gmdnam("GALUIE.MDF"),MNMSIZ);
     uinstt=register_module(&user_info);
     xfidat=(struct xfinfo *)alczer(nterms*sizeof(struct xfinfo));
     setmbk(supmb);
     mincxf=lngopt(MINCXF,0L,1000000000L);
     chgbdy=ynopt(CHGBDY);
     dclvda(fsdroom(UEDANSI3,uinfsp,0));
     dclvda(fsdroom(UEDNANS2,uinfsp,0));
     dclvda(fsdroom(USHINFO2,uinfsp,-1));
     inicsuin();
}

int
uinlon(void)                       /* supplement log on; shows credits     */
{
     int m,d,y;
     char newage;

     setmbk(supmb);
     if (usrptr->substt != ULBDAY) {
          if (!(usrptr->flags&WSGCSU) || extptr->entstt != uinstt) {
               if (shwcrd && usaptr->creds != 0L) {
                    prfmsg(UCREDS,
                              spr(usaptr->creds > 0L ? "%ld"
                                                     : "%ld",usaptr->creds));
                    outprf(usrnum);
               }
          }
          if (usaptr->birthd[0] == '\0' && asktbl[TBLBDY][0]) {
               prfmsg(usrptr->substt=ULBDAY);
               outprf(usrnum);
               return(1);
          }
     }
     else {
          if (margc == 1 && okbday(margv[0])) {
               strcpy(usaptr->birthd,margv[0]);
          }
          else {
               prfmsg(usrptr->substt);
               outprf(usrnum);
               return(1);
          }
     }
     if (asktbl[TBLBDY][0]) {
          sscanf(usaptr->birthd,"%d/%d/%d",&m,&d,&y);
          newage=((ddyear(today())-1900)-y)-
                 ((ddmon(today()) < m || (ddmon(today()) == m &&
                   ddday(today()) < d)) ? 1 : 0);
          if (newage != usaptr->age) {
               accacct(usaptr,-1);
               usaptr->age=newage;
               accacct(usaptr,1);
          }
     }
     return(0);
}

STATIC int
uinvfy(fldno,answer)                         /* UINFED field verify routine */
int fldno;                                         /* field number 0 to N-1 */
char *answer;                                            /* proposed answer */
{
     if (fldno == PSWFLD && !safpsw && !valpsw(answer)) {
          strcpy(fsdemg,"Enter something other than \"PASSWORD\" or your User-ID");
          return(VFYREJ);
     }
     return(vfyadn(fldno,answer));
}

STATIC void
uindun(                  /* UINFED when-done routine (restores state, etc.) */
int save)                                                  /* 1=save 0=quit */
{
     char birthd[DATSIZ];

     setmbk(supmb);
     usrptr->state=uinstt;
     if (fsdscb->chgcnt == 0) {
          prfmsg(UINNOCH);
     }
     else if (!save) {
          prfmsg(UINQIT);
     }
     else {
          prfmsg(UINSAV);
          fsdfxt(NAMFLD,usaptr->usrnam,NADSIZ);
          fsdfxt(AD1FLD,usaptr->usrad1,NADSIZ);
          fsdfxt(AD2FLD,usaptr->usrad2,NADSIZ);
          fsdfxt(AD3FLD,usaptr->usrad3,NADSIZ);
          fsdfxt(AD4FLD,usaptr->usrad4,NADSIZ);
          fsdfxt(PHOFLD,usaptr->usrpho,PHOSIZ);
          usaptr->systyp=f2sys[fsdord(SYSFLD)+1];
          switch (fsdord(ANSFLD)) {
          case 2:
               usaptr->ansifl=ANSMAN;
               break;
          case 1:
               usaptr->ansifl=ANSMAN+ANSON;
               break;
          default:
               usaptr->ansifl&=~ANSMAN;
               break;
          }
          stansi();
          usaptr->scnwid=atoi(fsdnan(SCWFLD));
          btutsw(usrnum,usaptr->scnwid);
          usaptr->scnfse=atoi(fsdnan(SCLFLD));
          if (fsdord(EDTFLD)) {
               usaptr->usrprf|=PRFLIN;
          }
          else {
               usaptr->usrprf&=~PRFLIN;
          }
          usaptr->scnbrk=fsdord(PAUFLD) ? CTNUOS : usaptr->scnfse;
          rstrxf();
          if (chgbdy && okbday(fsdfxt(BDYFLD,birthd,DATSIZ))) {
               strcpy(usaptr->birthd,birthd);
          }
          usaptr->sex=*fsdnan(SEXFLD);
          fsdfxt(PSWFLD,usaptr->psword,PSWSIZ);
          if (fsdscb->flddat[PSWFLD].flags&FFFCHG) {
               prfmsg(PSWWRN);
          }
     }
     usrptr->substt=UINQIT;
     btuinj(usrnum,CRSTG);
}

STATIC void
uiwipe(askno,fldno,pre,post)                 /* conditionally elides fields */
int askno,fldno,pre,post;
{
     if (!asktbl[askno][0]) {
          if (templt != NULL) {
               tpwipe(templt,fldno,pre,post);
          }
          fsdscb->flddat[fldno].flags|=FFFAVD;
     }
}

STATIC char *
uinrft(void)              /* conditionally wipe some fields completely away */
{
     int n;

     switch(fsdusr->amode) {
     case 1:
          templt=getasc(fsdusr->tmpmsg);
          n=3;
          break;
     case 0:
          templt=NULL;
          n=0;
          break;
     case -1:
          templt=rawmsg(fsdusr->tmpmsg);
          n=2;
          break;
     }
     uiwipe(TBLNAM,NAMFLD,2,0);
     uiwipe(TBLAD1,AD1FLD,2,n);
     uiwipe(TBLAD2,AD2FLD,2,n);
     uiwipe(TBLAD3,AD3FLD,2,n);
     uiwipe(TBLAD4,AD4FLD,2,n);
     uiwipe(TBLPHO,PHOFLD,2,0);
     uiwipe(TBLSYS,SYSFLD,2,0);
     uiwipe(TBLSYS,ANSFLD,2,n);
     uiwipe(TBLBDY,BDYFLD,2,0);
     uiwipe(TBLSEX,SEXFLD,2,0);
     return(templt);
}

STATIC void
uinptc(void)/* "protect" some fields so they are visible but not changeable */
{
     fsdscb->flddat[UIDFLD].flags|=FFFAVD;
     if (!chgbdy) {
          fsdscb->flddat[BDYFLD].flags|=FFFAVD;
     }
}

int
uinfed(void)                       /* user info editor main module         */
{
     int rc=1;
     int i;

     setmbk(supmb);
     do {
          bgncnc();
          switch(usrptr->substt) {
          case 0:
               cncchr();
               usrptr->flags&=~X2MAIN;
               uinmnu();
               break;
          case UINMNU1:
               switch (cncchr()) {
               case 'S':
                    cncall();
                    shwinf(usaptr);
                    outprf(usrnum);
                    clrprf();
                    go2mai();
                    break;
               case 'A':
                    cncall();
                    if (usaptr->ansifl&ANSON
                     && usaptr->scnfse >= 23
                     && usaptr->scnwid >= 80) {
                         uaiprp(UEDANSI3,1);
                         fsdrhd("Account Display/Edit");
                         fsdbkg(uinrft());
                         uinptc();
                         fsdego(uinvfy,uindun);
                    }
                    else {
                         uaiprp(USHINFO2,-1);
                         fsddsp(uinrft());
                         prfmsg(usrptr->substt=UINEASK);
                    }
                    break;
               case 'T':
                    if (shwcrd) {
                         if (usaptr->creds <= mincxf) {
                              prfmsg(NOCRDX2,l2as(mincxf));
                              howbuy();
                              cncall();
                              go2mai();
                         }
                         else {
                              prfmsg(usrptr->substt=CREDTR);
                         }
                         break;
                    }
                    cncall();
                    uinmnu();
                    break;
               case 'L':
                    if (nlingo > 1 && haskey(langchg)) {
                         prfmsg(LAHEAD);
                         lnglist(2);
                         lngfoot(2);
                         usrptr->substt=LAFOOT;
                         break;
                    }
               default:
                    cncall();
                    uinmnu();
                    break;
               case 'X':
                    rc=0;
                    break;
               }
               break;
          case LAFOOT:
               switch(morcnc()) {
               case '\0':
                    if (usrptr->flags&INJOIP) {
                         lngfoot(2);
                    }
               case '?':
                    prfmsg(LAHEAD);
                    lnglist(2);
                    lngfoot(2);
                    break;
               default:
                    if (sameas(nxtcmd,"X")) {
                         cncall();
                         go2mai();
                    }
                    else if (sameas(nxtcmd,"A") || sameas(nxtcmd,"AUTO")) {
                         getgen(&genbuf,usaptr->userid);
                         if (genbuf.lngnam[0] != '\0') {
                              genbuf.lngnam[0]='\0';
                              setgen(&genbuf);
                         }
                         prfmsg(AUTOEXP,languages[clingo]->name);
                         cncall();
                         go2mai();
                    }
                    else if ((i=cnclng()) != -1) {
                         if (isripu() && !samend(languages[i]->name,RIPSFX)
                             && sndrst) {
                              prf("\r!%s%s\r",RIP_RESET_WINDOWS,RNMOR3);
                         }
                         clingo=extptr->lingo=i;
                         rstrxf();
                         prfmsg(usrptr->substt=LAPERM,languages[clingo]->name);
                    }
                    else {
                         lngfoot(2);
                    }
               }
               break;
          case LAPERM:
               switch(cncyesno()) {
               case 'N':
               case 'X':
                    go2mai();
                    break;
               case 'Y':
                    getgen(&genbuf,usaptr->userid);
                    if (!sameas(genbuf.lngnam,languages[clingo]->name)) {
                         strcpy(genbuf.lngnam,languages[clingo]->name);
                         setgen(&genbuf);
                    }
                    go2mai();
                    break;
               default:
                    prfmsg(LAPERM,languages[clingo]->name);
                    break;
               }
               break;
          case UINEASK:
               switch(cncyesno()) {
               case 'Y':
                    btuoes(usrnum,1);
                    prfmsg(usrptr->substt=UEDNHLP2);
                    break;
               case 'N':
               case 'X':
               case '\0':
                    if (!(usrptr->flags&ABOIP)) {
                         go2mai();
                         break;
                    }
               default:
                    prfmsg(UINEASK);
                    break;
               }
               break;
          case CREDTR:
               scredtr();
               break;
          case UIDEN:
               suiden();
               break;
          case QUERYN:
               squeryn();
               break;
          case UEDNHLP2:
               cncall();
               break;
          default:
               cncall();
               prf("");
               go2mai();
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(rc);
}

STATIC int
checkx(void)         /* checks for "X"<CR> or plain <CR>, returns 1=handled */
{
     if (margc == 0) {
          prfmsg(usrptr->substt);
     }
     else if (sameas(margv[0],"X")) {
          go2mai();
          cncall();
     }
     else {
          return(0);
     }
     return(1);
}

STATIC void
go2mai(void)                       /* go back to main unifed menu, or exit */
{
     condex();
     uinmnu();
}

STATIC void
scredtr(void)                      /* get number of credits to transfer    */
{
     long num;

     if (checkx()) {
          return;
     }
     if (usaptr->creds <= mincxf) {
          prfmsg(RANOUT);
          howbuy();
          cncall();
          go2mai();
          return;
     }
     if ((num=numeok()) == -1) {
          prfmsg(NUMBAD,l2as(mincxf),l2as(min(usaptr->creds-1,MAXTKC)));
          prfmsg(NUMBADX);
          prfmsg(CREDTR);
          cncall();
          return;
     }
     if ((xfidat[usrnum].tikreq=num) >= usaptr->creds) {
          prfmsg(NOTENO,l2as(usaptr->creds-1));
          howbuy();
          prfmsg(CREDTR);
          cncall();
          return;
     }
     prfmsg(usrptr->substt=UIDEN);
}

STATIC void
suiden(void)                       /* get userid to transfer credits to    */
{
     if (checkx()) {
          clrxrf();
          return;
     }
     if (usaptr->creds <= mincxf) {
          prfmsg(RANOUT);
          clrxrf();
          howbuy();
          cncall();
          go2mai();
          return;
     }
     switch (hdluid(cncall())) {
     case UIDPMT:
          prfmsg(UIDEN);
     case UIDCAL:
          return;
     }
     stzcpy(xfidat[usrnum].tranfid,uidxrf.userid,UIDSIZ);
     if (sameas(usaptr->userid,uidxrf.userid)) {
          prfmsg(NOTSELF);
          prfmsg(UIDEN);
     }
     else {
          prfmsg(QYNPRE,l2as(xfidat[usrnum].tikreq),usaptr->userid,
                 uidxrf.userid);
          prfmsg(usrptr->substt=QUERYN);
     }
}

STATIC void
squeryn(void)                      /* verify transfer of credits           */
{
     int ison;
     long treq;
     char *tfid;

     if (checkx()) {
          return;
     }
     if (usaptr->creds <= mincxf) {
          prfmsg(RANOUT);
          howbuy();
          cncall();
          go2mai();
          return;
     }
     if (cncyesno() == 'Y') {
          treq=xfidat[usrnum].tikreq;
          if (usaptr->creds <= treq) {
               treq=usaptr->creds-1;
               prfmsg(NOENOT,l2as(treq));
          }
          tfid=xfidat[usrnum].tranfid;
          if ((ison=crdusr(tfid,l2as(treq),0,0)) < 0) {
               prfmsg(ACCDEL,tfid);
               cncall();
               go2mai();
               return;
          }
          prfmsg(DATATR,l2as(treq),usaptr->userid,tfid);
          outprf(usrnum);
          if (ison && !(usrptr->flags&INVISB)) {
               prfmlt(SENDUS,usaptr->userid,l2as(treq));
               if (injoth()) {
                    prfmsg(NOTICE,tfid);
                    outprf(usrnum);
                    clrprf();
               }
          }
          rdedcrd(treq,1);
          if (!haskey(syskey) && grpnum[usrnum] != 0) {     /* zap stats   */
               mdstats[usrptr->state].creds-=treq;     /* that were added  */
               sv3.crdghr[grpnum[usrnum]-1][dthour(now())]-=treq;
          }
          shocst("USER CREDIT TRANSFER","%s->%s (%s credits)",
                 usaptr->userid,tfid,l2as(treq));
     }
     else {
          prfmsg(CDXABO);
     }
     cncall();
     go2mai();
}

void
uinsts(void)                     /* Account display/edit status entry point */
{
     if (status == OUTMT && usrptr->substt == UEDNHLP2) {
          setmbk(supmb);
          uaiprp(UEDNANS2,0);
          uinrft();
          uinptc();
          fsdego(uinvfy,uindun);
          btuoes(usrnum,0);
          outprf(usrnum);
     }
     else {
          dfsthn();
     }
}

STATIC void
uinmnu(void)                                         /* User info edit menu */
{
     struct clstab *tabptr;
     int islng;

     prfmsg(usrptr->substt=UINMNU1,usaptr->userid);
     if (shwcrd) {
          tabptr=fndcls(usaptr->curcls);
          prfmsg(UINMNU2,spr("%ld",usaptr->creds),
                 tabptr->dbtlmt == -1L ? " (No bottom limit)"
                 : (tabptr->dbtlmt > 0L ? spr(" (Bottom limit: -%ld)",
                    tabptr->dbtlmt) : ""),
                 (tabptr->flags&CRDXMT) ? " (Exempt from charges)" : "");
     }
     islng=haskey(langchg);
     if (nlingo > 1 && islng) {
          prfmsg(UINMNU3,languages[clingo]->name);
     }
     if (shwcrd && (nlingo > 1 && islng)) {
          prfmsg(UINMSATL);
     }
     else if (shwcrd) {
          prfmsg(UINMNSAT);
     }
     else if (nlingo > 1 && islng) {
          prfmsg(UINMNSAL);
     }
     else {
          prfmsg(UINMNUSA);
     }
     prfmsg(UINMNU9);
}

STATIC void
uaiprp(msgno,amode)                 /* prepare for user information editing */
int msgno;
int amode;                /* 1=full-screen entry, 0=linear entry -1=display */
{
     fsdroom(msgno,uinfsp,amode);
     sprintf(vdatmp,uinfmt,
             usaptr->userid,'\0',
             usaptr->usrnam,'\0',
             usaptr->usrad1,'\0',
             usaptr->usrad2,'\0',
             usaptr->usrad3,'\0',
             usaptr->usrad4,'\0',
             usaptr->usrpho,'\0',
             sysstg[usaptr->systyp],'\0',
             anschc[usaptr->ansifl],'\0',
             usaptr->scnwid,'\0',
             usaptr->scnfse,'\0',
            (usaptr->usrprf&PRFLIN) ? "LINE" : "FSE",'\0',
             usaptr->scnbrk == CTNUOS ? "CONTINUOUS" : "PAUSE",'\0',
             usaptr->birthd,'\0',
             usaptr->sex == 'M' ? "MALE" : "FEMALE",'\0',
             usaptr->psword,'\0');
     fsdapr(vdaptr,vdasiz,vdatmp);
}

STATIC void
shwinf(usaptr)                     /* display's a user's acc inf for edit  */
struct usracc *usaptr;
{
     char buf[9];
     struct clstab *tabptr;

     setmbk(supmb);
     strcpy(buf,ncdate(usaptr->usedat));
     tabptr=fndcls(usaptr->curcls);
     prfmsg(UINFENI,usaptr->userid,ncdate(usaptr->credat),buf,
            usaptr->curcls,
            tabptr->limcal != -1 ? spr("%d minutes",tabptr->limcal)
              : "UNLIMITED",
            tabptr->limday != -1 ? spr("%d minutes",tabptr->limday)
              : "UNLIMITED");
     if (tabptr->flags&DAYEXP) {
          prfmsg(UINFEDD,spr("%d",usaptr->daystt));
     }
     else {
          prf("\r%s",isripu() ? "" : "");
     }
     rstmbk();
}

STATIC long
numeok(void)                       /* is number ok? (for credits to xfer)  */
{
     long retval;

     if ((retval=cnclon()) < mincxf) {
          return(-1);
     }
     if (retval > MAXTKC) {
          return(-1);
     }
     return(retval);
}
