/***************************************************************************
 *                                                                         *
 *   THREADU.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is a suite of utility routines for dealing with Forum message    *
 *   threads.                                                              *
 *                                                                         *
 *                                               - C. Robert  10/25/94     *
 *                                                                         *
 ***************************************************************************/

void
inithu(                            /* initialize thread utilities          */
unsigned maxinm);                  /*   max # of threads in in-memory cache*/

unsigned
ninthr(                            /* get number of messages in a thread   */
unsigned forum,                    /*   forum number thread resides in     */
long thrid);                       /*   unique thread ID within Forum      */

BOOL                               /*   did this just create a new thread? */
incthr(                            /* increment # of messages in a thread  */
unsigned forum,                    /*   forum number thread resides in     */
long thrid);                       /*   unique thread ID within Forum      */

BOOL                               /*   did this just destroy a thread?    */
decthr(                            /* decrement # of messages in a thread  */
unsigned forum,                    /*   forum number thread resides in     */
long thrid);                       /*   unique thread ID within Forum      */

void
setthrc(                           /* set number of messages in thread     */
unsigned forum,                    /*   forum ID thread is in              */
long thrid,                        /*   thread ID of thread                */
unsigned msgcnt);                  /*   number of messages in thread       */

void
cathrs(void);                      /* clear all thread counters (mcu only) */

void
cfthrs(                            /* clr Forum thread counters (mcu only) */
unsigned forum);                   /*   Forum to clear all threads for     */

void
clsthu(void);                      /* close down thread utilities          */
