/*        Header file for use with Remote Sysop stuff                      */
/*   Copyright (c) 1991-1995 GALACTICOMM, Inc.    All Rights Reserved.     */

#define FNDSIZE      64            /* file name size for dos activity      */

extern
int rmsyst;                        /* remote sysop state number            */

extern
int kilipg,                   /* kill-system command in progress           */
    errcod,                   /* MS-DOS exit codes (for batch files)       */
    kilsrc,                   /* kill-command source (-1=console, -2=MCU,  */
                              /* -3=timed event, >=0=chan #)               */
    kilctr,                   /* kill-system in this many minutes          */
    rsetop,                   /* reset option: busy=B; no-answer=N         */
    chnemd,                   /* channel currently being emulated          */
    rmtsys;                   /* remote sysop emulation channel (-1 if no) */

struct rsysop {                    /* "remote Sysop" data structure        */
     FILE *sfp;                    /*   DOS functions source file pointer  */
     FILE *dfp;                    /*   DOS functions dest. file pointer   */
     long fpos;                    /*   DOS functions file position        */
     int chan;                     /*   scratch channel number             */
     int rkilctr;                  /*   kilctr for this remote sysop       */
     int flags;                    /*   bit flags for remote sysop         */
     int genctr;                   /*   general purpose counter            */
     char dftinp;                  /*   default character handler input    */
     struct usracc acc;            /*   scratch userid buffer              */
     struct fndblk dirblk;         /*   structure used for directory lists */
     char sfname[FNDSIZE];         /*   file name 1 for general use        */
     char dfname[FNDSIZE];         /*   file name 2 for general use        */
     struct clstab *cltptr;        /*   pointer to class table element     */
     char text[MTXSIZ];            /*   general purpose text area          */
};

#define CRTCLS      1              /*   remote sysop is creating a class   */
#define EDTCLS      2              /*   remote sysop is editing a class    */
#define EDTKYR      4              /*   remote sysop is editing a keyring  */

#define rsyptr ((struct rsysop *)vdaptr)
#define remoff(u) ((struct rsysop *)vdaoff(u))

/* REMSYS.C 23/05/92 14.20.58 */
void EXPORT init__remsys(void);
int account(void);
void rcpydat(void);
void dspsts(void);
void dspmdu(void);
void dspsaa(void);
void dspcus(void);
void acsthn(void);
void emuinp(int hangup);
void clremu(int unum);
void updaxs(void);
void bgnmon(int msg,unsigned long wch);
void rblwof(int msg);
void sisokq(void);
void dsponl(void);
void chkdat(int date);
void chkcrd(long credits);
void xltescp(void);
void prfaxs(struct usracc *uacptr);
void clsfils(void);
int fnamchk(char *touse);
void shwdft(void);
void dspcll(void);

/* REMSYS2.C 23/05/92 13.56.52 */
void rsop62(void);
void rsop62a(void);
void rsop71(void);
void acczero(void);
int acconex(void);
void clsrsy(void);
int rsyevt(void);
int emuinu(void);
int wrdlen(char *str);
int anyaxs(struct usracc *uacptr);
void zaprsy(void);
int ckfnams(char *touse,char *test);
int dwedt11(int flags);
int dwedt12(int flags);
int dwedt13(int flags);
int dwedtj5(int flags);
int dwedtjj(int flags);
void ntfysop(char *audrec);
void rsprom(int msg);
