/***************************************************************************/
/*                                                                         */
/*   REGISTRY.H                                                            */
/*                                                                         */
/*   Copyright (c) 1994-1995 Galacticomm, Inc.    All rights reserved.     */
/*                                                                         */
/*   These are common declarations for REGISTRY.C and CSREGIS.C.           */
/*                                                                         */
/*                                                - Bill Hyatt 9/4/94      */
/*                                                                         */
/***************************************************************************/

#define   PROSIZ 900               /* profile size (gen purp. text block)  */
#define   SUMSIZ 40                /* number of bytes allowed for summary  */
#define   MAXFLD 30                /* maximum number of fields in profile  */

/* used for obtaining registry field info from CNF blocks */
#define   fldmsg(n) (FLDPMT1+4*(n))/* beg. msg# for a field's blocks       */
#define   PMTOFF 0                 /* offset for A/A prompt                */
#define   SIZOFF 1                 /* offset for answer size               */
#define   LBLOFF 2                 /* offset for C/S label                 */
#define   CSQOFF 3                 /* offset for C/S version of question   */

extern
FILE *regmb;                       /* registry message file block pointer  */

extern
BTVFILE *regbb;                    /* registry btrieve file pointer        */

struct regrec {                    /* user registry structure              */
     char userid[UIDSIZ];          /* user-id of registry record           */
     char sumlin[SUMSIZ];          /* one-line summary for directory       */
     char profil[PROSIZ];          /* user's "profile"                     */
     char spare[1002-970];         /* spare space, decrease when adding    */
};

struct reginf {                    /* registry field info                  */
     int ansidx;                   /*   index to beg of ans in profile     */
     int anssiz;                   /*   size of answer in profile          */
};

extern
struct reginf reginf[MAXFLD];      /* array of registry field info         */

extern
int numfds;                        /* number of configured fields          */

extern
char *regakey,                     /* key req'd to access registry agent   */
     *regkey,                      /* key req'd to create registry entries */
     *viewkey;                     /* key req'd to view other entries      */

void inicsregis(void);             /* initialize the registry agent        */

