/***************************************************************************
 *                                                                         *
 *   REGISTRY.C                                                            *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Worldgroup user "registry" module.                        *
 *                                                                         *
 *                                  - T. Stryker & S. Brinker 1/24/88      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "registry.h"
#include "galregis.h"

#define FILREV "$Revision:   1.0.1.0.1.1  $"

void EXPORT init__registry(void);
STATIC void makrar(void);
int regnot(void);
int gloreg(void);
int regrou(void);
STATIC void regrou1(void);
STATIC void regrou2(void);
STATIC void regrou3(void);
STATIC void regrou4(void);
STATIC void regrou5(void);
STATIC void regrou6(void);
STATIC void regrou7(void);
STATIC void regrou8(void);
STATIC void regrou9(void);
STATIC void regrou10(void);
STATIC void regmnu(void);
STATIC void shwpro(int msg,int msg2);
void shwprop(int msg,int msg2,struct regrec *rblkpt);
STATIC int pcts(char *buf);
void reglst(void);
STATIC void getdir(void);
STATIC void go2mai(void);
void delreg(char *uid);
void clsreg(void);
BTVFILE **getregbb(void);

struct module registry={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     regnot,                  /*    user logon supplemental routine   */
     regrou,                  /*    input routine if selected         */
     reglst,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     delreg,                  /*    delete-account routine            */
     clsreg                   /*    finish-up (sys shutdown) routine  */
};

FILE *regmb;                  /* registry named-message file block pointer */

BTVFILE *regbb;               /* registry btrieve message file block ptr.  */

struct regusr {
     int fldidx;              /* current field index for creation, editing */
     int flags;               /* registry user's bit-definable flags       */
     long fpos;               /* file position for directory output        */
     struct regrec regblk;    /* user's current registry record in mem.    */
};                            /* dynamically allocated regusr array        */

                              /* definition of registry bit "flags"        */
#define CRTMNU 1              /* show create menu                          */
#define UPDYOU 2              /* need to update "your" user file           */
#define GOTONE 4              /* gotten a user-id lookup once already      */

struct reginf reginf[MAXFLD]; /* array of registry field info              */

static
int regstt;                   /* User Registry state                       */

int numfds;                   /* number of configured fields               */

char *regkey,                 /* key req'd to create registry entries      */
     *viewkey;                /* key req'd to view other's entries         */

#define regptr ((struct regusr *)vdaptr)

void EXPORT
init__registry(void)               /* initialize registry module           */
{
     stzcpy(registry.descrp,gmdnam("GALREG.MDF"),MNMSIZ);
     regstt=register_module(&registry);
     regmb=opnmsg("GALREGIS.MCV");
     regkey=stgopt(REGKEY);
     viewkey=stgopt(VIEWKEY);
     dclvda(sizeof(struct regusr));
     makrar();
     regbb=opnbtv("GALREGIS.DAT",sizeof(struct regrec));
     globalcmd(gloreg);
     inicsregis();
}

STATIC void
makrar(void)                       /* make registry array from .MSG file   */
{
     int curidx;
     char *tmprmsg;

     curidx=0;
     for (numfds=0 ; numfds < MAXFLD ; numfds++) {
          tmprmsg=rawmsg(fldmsg(numfds)+PMTOFF);
          if (tmprmsg[0] != '\0') {
               if (strlen(tmprmsg) > outbsz) {
                    catastro("REGISTRY: QUESTION #%d IS TOO BIG!\n"
                             "The size of a registry question cannot be larger"
                             "than your output buffer size.",numfds+1);
               }
               stpans(tmprmsg=rawmsg(fldmsg(numfds)+SIZOFF));
               if ((reginf[numfds].anssiz=atoi(tmprmsg)) != 0) {
                    reginf[numfds].ansidx=curidx;
                    curidx+=reginf[numfds].anssiz+1;
               }
               else {
                    catastro("REGISTRY: INVALID ANSWER SIZE SPECIFIED FOR"
                             " QUESTION #%d!",numfds+1);
               }
          }
          else if (curidx > PROSIZ) {
               catastro("REGISTRY: TOTAL SIZE OF REGISTRY ANSWERS TOO LARGE!\n"
                        "The total of all the answers' lengths must not be\n"
                        "more than %d.",PROSIZ-MAXFLD);
          }
          else {
               break;
          }
     }
}

int
regnot(void)                       /* notify user to fill out registry     */
{
     if (!(usrptr->flags&WSGCSU) && haskey(regkey)) {
          setbtv(regbb);
          setmbk(regmb);
          if (*(ncdate(usaptr->usedat)) != '\0' && !qeqbtv(usaptr->userid,0)
               && haskey(regkey)) {
               prfmsg(REGPLS);
               outprf(usrnum);
          }
     }
     return(0);
}

int
gloreg(void)                       /* global registry-lookup command       */
{
     if (margc > 1 && sameas(margv[0],"/r")) {
          setmbk(regmb);
          if (haskey(viewkey)) {
               setbtv(regbb);
               rstrin();
               nxtcmd=margv[1];
               if (acqbtv(vdatmp,cncuid(),0)) {
                    prfmsg(ENTFOR,((struct regrec *)vdatmp)->userid);
                    shwprop(RENTRY,SUMDSP,(struct regrec *)vdatmp);
               }
               else {
                    prfmsg(NOSUID);
               }
          }
          else {
               prfmsg(NOVAXS);
          }
          outprf(usrnum);
          return(1);
     }
     return(0);
}

int
regrou(void)                       /* main registry input handler          */
{
     setmbk(regmb);
     setbtv(regbb);
     if (margc > 0 && (sameas(margv[0],"x") || sameas(margv[0],"exit"))) {
          clrxrf();
          if (regptr->flags&UPDYOU) {
               regptr->flags&=~UPDYOU;
               geqbtv(NULL,usaptr->userid,0);
               updbtv(&regptr->regblk);
          }
          switch (usrptr->substt) {
          case 1:
               return(0);
          case 4:
          case 5:
               prfmsg(NOTDUN);
          case 9:
          case 10:
               regptr->flags&=~GOTONE;
          case 2:
          case 3:
          case 6:
               btumil(usrnum,DFTIMX);
               go2mai();
               break;
          case 7:
          case 8:
               btumil(usrnum,DFTIMX);
               if (isripu()) {
                    prfmsg(YOUARE);
                    shwpro(EDTENT,SUMEDT);
               }
               prfmsg(EDTWHT);
               usrptr->substt=6;
               break;
          }
     }
     else {
          do {
               bgncnc();
               switch (usrptr->substt) {
               case 0:
                    setmem(regptr,vdasiz,0);
                    cncchr();
                    usrptr->flags&=~X2MAIN;
                    if (!acqbtv(&(regptr->regblk),usaptr->userid,0)) {
                         regptr->flags|=CRTMNU;
                         prfmsg(GENINF);
                    }
                    regmnu();
                    usrptr->substt=1;
                    break;
               case 1:
                    regrou1();
                    break;
               case 2:
                    regrou2();
                    break;
               case 3:
                    regrou3();
                    break;
               case 4:
                    regrou4();
                    break;
               case 5:
                    regrou5();
                    break;
               case 6:
                    regrou6();
                    break;
               case 7:
                    regrou7();
                    break;
               case 8:
                    regrou8();
                    break;
               case 9:
                    regrou9();
                    break;
               case 10:
                    regrou10();
                    break;
               }
          } while (!endcnc());
     }
     outprf(usrnum);
     return(1);
}

STATIC void
regrou1(void)                      /* registry menu sub-state handler      */
{
     if (margc == 0) {
          regmnu();
     }
     else {
          switch (cncchr()) {
          case 'G':
               prfmsg(GENINF);
          case '?':
               regmnu();
               break;
          case 'D':
               prfmsg(DIRPMT);
               btumil(usrnum,4);
               usrptr->substt=2;
               break;
          case 'Y':
               if (!haskey(regkey)) {
                    prfmsg(NOYSIR);
                    howbuy();
                    regmnu();
               }
               else {
                    if (numfds > 0) {
                         if (regptr->flags&CRTMNU) {
                              btumil(usrnum,reginf[0].anssiz);
                              regptr->fldidx=0;
                              prfmsg(BGNCRT);
                              prfmsg(fldmsg(0)+PMTOFF);
                              usrptr->substt=4;
                         }
                         else {
                              geqbtv(&regptr->regblk,usaptr->userid,0);
                              prfmsg(YOUARE);
                              shwpro(EDTENT,SUMEDT);
                              prfmsg(EDTWHT);
                              usrptr->substt=6;
                         }
                    }
                    else {
                         prfmsg(ENTSUM);
                         btumil(usrnum,SUMSIZ-1);
                         usrptr->substt=5;
                    }
               }
               break;
          case 'L':
               if (haskey(viewkey)) {
                    prfmsg(UIDTOL);
                    usrptr->substt=9;
               }
               else {
                    prfmsg(NOVAXS);
                    howbuy();
                    regmnu();
               }
               break;
          default:
               prfmsg(NOSUCH);
               cncall();
               go2mai();
          }
     }
}

STATIC void
regrou2(void)                      /* begin directory sub-state handler    */
{
     if (margc == 0) {
          prfmsg(DIRPMT);
     }
     else if (sameas(nxtcmd,"?")) {
          prfmsg(DINTRO);
     }
     else {
          if (qgebtv(cncuid(),0)) {
               btumil(usrnum,DFTIMX);
               gcrbtv(&regptr->regblk,0);
               prfmsg(TITLIN2);
               prfmsg(DIRLIN,regptr->regblk.userid,regptr->regblk.sumlin);
               usrptr->substt=3;
               btuinj(usrnum,CYCLE);
               regptr->fpos=absbtv();
          }
          else {
               prfmsg(NEXIST);
               prfmsg(DIRPMT);
          }
     }
     cncall();
}

STATIC void
regrou3(void)                      /* listing directory sub-state handler  */
{
     btuclo(usrnum);
     prfmsg(ABORTD);
     go2mai();
     cncall();
}

STATIC void
regrou4(void)                      /* fill out registry sub-state handler  */
{
     if (margc == 0 || sameas(nxtcmd,"?")) {
          prfmsg(fldmsg(regptr->fldidx)+PMTOFF);
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(fldmsg(regptr->fldidx)+PMTOFF);
     }
     else {
          movmem(cncall(),
               regptr->regblk.profil+reginf[regptr->fldidx].ansidx,
               reginf[regptr->fldidx].anssiz);
          regptr->fldidx++;
          if (regptr->fldidx < numfds) {
               btumil(usrnum,reginf[regptr->fldidx].anssiz);
               prfmsg(fldmsg(regptr->fldidx)+PMTOFF);
          }
          else {
               prfmsg(ENTSUM);
               btumil(usrnum,SUMSIZ-1);
               usrptr->substt=5;
          }
     }
     cncall();
}

STATIC void
regrou5(void)                      /* fill out summary sub-state handler   */
{
     if (margc == 0 || sameas(nxtcmd,"?")) {
          prfmsg(ENTSUM);
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(ENTSUM);
     }
     else {
          movmem(cncall(),regptr->regblk.sumlin,SUMSIZ-1);
          movmem(usaptr->userid,regptr->regblk.userid,UIDSIZ);
          insbtv(&regptr->regblk);
          btumil(usrnum,DFTIMX);
          regptr->flags&=~CRTMNU;
          prfmsg(THANKS);
          go2mai();
     }
     cncall();
}

STATIC void
regrou6(void)                      /* edit registry sub-state handler      */
{
     int temp;

     if (margc == 0) {
          if (isripu()) {
               prfmsg(YOUARE);
               shwpro(EDTENT,SUMEDT);
          }
          prfmsg(EDTWHT);
     }
     else if (sameas(nxtcmd,"?")) {
          prfmsg(YOUARE);
          shwpro(EDTENT,SUMEDT);
          prfmsg(EDTWHT);
          cncall();
     }
     else {
          if ((temp=cncint()) == 99) {
               prfmsg(ENTNSM);
               btumil(usrnum,SUMSIZ-1);
               usrptr->substt=8;
          }
          else if (temp < 1 || temp > numfds) {
               prfmsg(NOSUCH);
               if (isripu()) {
                    prfmsg(YOUARE);
                    shwpro(EDTENT,SUMEDT);
               }
               prfmsg(EDTWHT);
               cncall();
          }
          else {
               regptr->fldidx=temp-1;
               btumil(usrnum,reginf[regptr->fldidx].anssiz);
               prfmsg(ENTNEW,temp);
               usrptr->substt=7;
          }
     }
}

STATIC void
regrou7(void)                      /* enter new info sub-state handler     */
{
     if (margc == 0 || sameas(nxtcmd,"?")) {
          prfmsg(NEWINF);
          cncall();
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(NEWINF);
          cncall();
     }
     else {
          movmem(cncall(),
               regptr->regblk.profil+reginf[regptr->fldidx].ansidx,
               reginf[regptr->fldidx].anssiz);
          regptr->flags|=UPDYOU;
          btumil(usrnum,DFTIMX);
          prfmsg(UPDATD);
          if (isripu()) {
               prfmsg(YOUARE);
               shwpro(EDTENT,SUMEDT);
          }
          prfmsg(EDTWHT);
          usrptr->substt=6;
     }
}

STATIC void
regrou8(void)                      /* enter new summary sub-state handler  */
{
     if (margc == 0 || sameas(nxtcmd,"?")) {
          prfmsg(ENTNSM);
          cncall();
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(ENTNSM);
          cncall();
     }
     else {
          movmem(cncall(),regptr->regblk.sumlin,SUMSIZ-1);
          btumil(usrnum,DFTIMX);
          regptr->flags|=UPDYOU;
          prfmsg(UPDATD);
          if (isripu()) {
               prfmsg(YOUARE);
               shwpro(EDTENT,SUMEDT);
          }
          prfmsg(EDTWHT);
          usrptr->substt=6;
     }
}

STATIC void
regrou9(void)                      /* look-up a user sub-state handler     */
{

     if (margc == 0 || sameas(nxtcmd,"?")) {
          prfmsg((regptr->flags&GOTONE) ? UIDTLN : UIDTOL);
     }
     else if (strlen(nxtcmd) < 3 && morcnc() == 'N') {
          cncchr();
          if (agtbtv(&regptr->regblk,regptr->regblk.userid,0)) {
               prfmsg(ENTFOR,regptr->regblk.userid);
               shwpro(RENTRY,SUMDSP);
               regptr->flags|=GOTONE;
               prfmsg(UIDTLN);
          }
          else {
               regptr->flags&=~GOTONE;
               btumil(usrnum,DFTIMX);
               prfmsg(ALDONE);
               go2mai();
          }
     }
     else {
          regrou10();
     }
     cncall();
}

STATIC void
regrou10(void)                     /* handle user-id input with hdluid()   */
{
     switch (hdluid(margc == 0 ? languages[clingo]->yes : cncall())) {
     case UIDPMT:
          prfmsg((regptr->flags&GOTONE) ? UIDTLN : UIDTOL);
          break;
     case UIDFND:
          if (acqbtv(&regptr->regblk,uidxrf.userid,0)) {
               prfmsg(ENTFOR,regptr->regblk.userid);
               shwpro(RENTRY,SUMDSP);
               regptr->flags|=GOTONE;
               prfmsg(UIDTLN);
          }
          else {
               clrxrf();
               prfmsg(NOSUID);
               prfmsg((regptr->flags&GOTONE) ? UIDTLN : UIDTOL);
          }
          break;
     case UIDCAL:
          usrptr->substt=10;
          return;
     }
     usrptr->substt=9;
}

STATIC void
regmnu(void)                       /* display main registry menu           */
{
     prfmsg((regptr->flags&CRTMNU) ? CREMNU : EDTMNU);
}

STATIC void
shwpro(msg,msg2)                   /* display a user's profile             */
int msg,msg2;
{
     shwprop(msg,msg2,&regptr->regblk);
}

void
shwprop(msg,msg2,rblkpt)           /* display a profile pointed to by rblkpt */
int msg,msg2;
struct regrec *rblkpt;
{
     char *datptr,*orgbuf,*buf;
     int i,hold,skount;

     datptr=rblkpt->profil;
     buf=rawmsg(msg);
     orgbuf=buf;
     i=0;
     while (*buf != '\0') {
          if ((skount=pcts(buf)) > 0) {
               buf+=skount;
               hold=*buf;
               *buf='\0';
               prf(orgbuf,datptr+reginf[i++].ansidx);
               *buf=hold;
               orgbuf=buf;
          }
          else {
               if (*buf == '\n') {
                    *buf='\r';
               }
               buf++;
          }
     }
     prf(orgbuf);
     prfmsg(msg2,rblkpt->sumlin);
}

STATIC int
pcts(buf)                          /* prf() utility for shwpro()           */
char *buf;
{
     int i;
     char *bp;

     bp=buf;
     if (*bp == '%') {
          i=2;
          while (*++bp == '-' || isdigit(*bp) || *bp == '.') {
               i++;
          }
          if (*bp == 's') {
               return(i);
          }
          if (*bp == ESC) {
               catastro("ANSI codes inside one of the %%-symbols in a user\n"
                        "registry template.  (Try editing that text block and\n"
                        "removing all ANSI coding using <Alt-E>.)");
          }
          catastro("Bad symbol in user registry template: \"%s\"",
                   spr("%-0.*s",(int)(bp-buf+1),buf));
     }
     return(0);
}

void
reglst(void)                       /* status handler: registry listing     */
{
     setmbk(regmb);
     if (usrptr->substt == 3 && status == CYCLE) {
          setbtv(regbb);
          getdir();
     }
     else {
          dfsthn();
     }
}

STATIC void
getdir(void)                       /* get records in registry directory    */
{
     if ((btuoba(usrnum)) >= 500) {
          gabbtv(NULL,regptr->fpos,0);
          if (qnxbtv()) {
               movmem(regbb->data,&regptr->regblk,sizeof(struct regrec));
               prfmsg(DIRLIN,regptr->regblk.userid,regptr->regblk.sumlin);
               outprf(usrnum);
               regptr->fpos=absbtv();
          }
          else {
               prfmsg(DIREND);
               go2mai();
               outprf(usrnum);
               return;
          }
     }
     btuinj(usrnum,CYCLE);
}

STATIC void
go2mai(void)                       /* go back to main registry menu, or exit */
{
     condex();
     isripu() ? regmnu() : prfmsg(SHRMNU);
     usrptr->substt=1;
}

void
delreg(uid)                        /* delete utility: delete registry entry*/
char *uid;
{
     setbtv(regbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
}

void
clsreg(void)                       /* close registry files for shutdown    */
{
     clsmsg(regmb);
     clsbtv(regbb);
}

BTVFILE ** EXPORT
getregbb(void)                     /* return the address of regbb          */
{
     return(&regbb);
}
