/***************************************************************************
 *                                                                         *
 *   LOCAL.C                                                               *
 *                                                                         *
 *   Copyright (c) 1992-1995 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Local session screen support module.                                  *
 *                                                                         *
 *                                            - Robert A. Rose 02/14/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"
#include "oprlow.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

void lsesupd(void);
unsigned lseskey(unsigned scncod);
void oprmk2(int chr);
void entlse(int chn2em);

int lsehdl;                   /* handle for the emulation screen           */
int lsechn=-1;                /* channel to use for local session login    */

struct curatr oldansb;        /* interrupted ansi save block               */
struct curatr lseansb;        /* ansi state save block                     */

static
FILE *llogfp;                 /* file handle for local session             */

int atoggl=ANSON,             /* ANSI-display toggle (defaults to ON)      */
    lltoggl;                  /* log-emu-session-to-disk toggle            */

extern
int emshue,                   /* emulation status display attribute code   */
    emthue,                   /* emulation text display attribute code     */
    emhhue;                   /* emulation help-title display attr code    */

struct scrnid lsesscn={
     "bbslcl.bin",                 /* screen filename                      */
     4000,
     0,                            /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     lseskey,                      /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     0,0,                          /* current cursor position on screen    */
     1,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     0,1,79,24,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

void
entlse(chn2em)                     /* enter current channel emulation      */
int chn2em;
{
     lsechn=chn2em;
     btumon2(lsechn);
     actvscn(lsehdl);
     ansion(atoggl);
     sstatr(emthue);
     locate(0,1);
     printf("\33[1;24r\14");
     saveworld(&lseansb);
     ansion(0);
     btuinj(lsechn,RING);
}

void
lsesupd(void)                      /* local session update routine         */
{
     int c,i;
     char *ptr;
     static char dsbuf[40];

     if ((c=btumds2()) != 0) {
          if (lsehdl != mainhdl) {
               saveworld(&oldansb);
          }
          restworld(&lseansb);
          setwin(scnids[lsehdl].location,0,1,79,24,1);
          cursact(lsehdl == mainhdl);
          dftbel(1);
          do {
               dsbuf[0]=c;
               for (i=1,ptr=dsbuf+1 ; i < sizeof(dsbuf)-1 ; i++) {
                    if ((*ptr++=btumds2()) == 0) {
                         break;
                    }
               }
               printf("%s",dsbuf);
               if (lltoggl) {
                    fprintf(llogfp,"%s",dsbuf);
               }
          } while ((c=btumds2()) != 0);
          cursact(0);
          scnids[lsehdl].cx=curcurx();
          scnids[lsehdl].cy=curcury();
          saveworld(&lseansb);
          if (lsehdl != mainhdl) {
               restworld(&oldansb);
          }
          ansion(0);
     }
}

unsigned
lseskey(
unsigned scncod)                        /* local session keystroke hit     */
{
     actvscn(lsehdl);
     switch (scncod) {
     case ALT_A:              /* Toggle ANSI emulation                     */
          atoggl^=ANSON;
          saveworld(&oldansb);
          restworld(&lseansb);
          ansion(atoggl);
          saveworld(&lseansb);
          locate(24,0);
          sstatr(0x70);
          if (atoggl) {
               printf("(ANSI)");
               sstatr(0x0d);
               printf("");
          }
          else {
               printf("(non-ANSI)");
          }
          rstloc();
          restworld(&oldansb);
          break;
     case ALT_L:              /* Toggle Log file open/close                */
          setwin(scnids[lsehdl].location,0,1,79,24,1);
          locate(41,0);
          sstatr(emhhue);
          if (lltoggl^=1) {
               if ((llogfp=fopen("LOCALBBS.LOG",FOPAB)) == NULL) {
                    printf("\7");
               }
               else {
                    printf("  Logging session to: LOCALBBS.LOG   ");
                    fprintf(llogfp,"Log activated at %s %s\r\n\r\n",
                         nctime(now()),ncedat(today()));
               }
          }
          else {
               fprintf(llogfp,"\r\n\r\nLog terminated at %s %s\r\n",
                    nctime(now()),ncedat(today()));
               fclose(llogfp);
               printf("(press ESC to return to main display)");
          }
          rstloc();
          rstwin();
          break;
     case ESC:
          dftbel(1);
          scngoaway(lsehdl);
          break;
     case SHIFT+F10:
          btuinj(lsechn,RING);
          break;
     default:
          if (scncod&eurmsk) {
               btumks2(scncod);
          }
          else {
               switch (scncod) {
               case CRSRUP:
                    oprmk2('A');
                    break;
               case CRSRDN:
                    oprmk2('B');
                    break;
               case CRSRRT:
                    oprmk2('C');
                    break;
               case CRSRLF:
                    oprmk2('D');
                    break;
               case HOME:
                    oprmk2('H');
                    break;
               case END:
                    oprmk2('K');
                    break;
               case DEL:
                    btumks2(0x7f);
                    break;
               }
          }
          break;
     }
     return(0);
}

void
oprmk2(chr)                        /* emit an ANSI cursor-movement string  */
int chr;
{
     btumks2('\33');
     btumks2('[');
     btumks2(chr);
}

