/***************************************************************************
 *                                                                         *
 *   GME.H                                                                 *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Galacticomm Messaging Engine's public variables,          *
 *   functions, etc.                                                       *
 *                                                                         *
 *                                            - J. Alvrus   6/5/94         *
 *                                                                         *
 ***************************************************************************/

#define GMEWRKSZ 512               /* memory required for GME work area    */
#define FORNSZ   16                /* forum name size                      */
#define MAXADR   256               /* message address size                 */
#define TPCSIZ   51                /* message (and forum) topic size       */
#define HSTSIZ   57                /* message history size                 */
#define MAXSKWD  80                /* size of scan keyword string          */
#define MAXQSR   16384             /* max size of a user's quickscan record*/
#define MAXNQSF  2400              /* max # forums in a user's quickscan   */
#define DLNMSZ   10                /* sysop dist list name size            */
#define MINLCH   0                 /* minimum sysop dist list surcharge    */
#define MAXLCH   32000             /* maximum sysop dist list surcharge    */
#define MAXBLK   65530U            /* largest allocable memory block       */
#define BIGBLK   256               /* # items to alloc in an array @ once  */
#define SMLBLK   16                /* # items to alloc in small array      */
#define MAXPARSZ (MAXBLK/sizeof(void *)) /* max # ptrs in a pointer array  */
#define MAXGMERQ 65535L            /* max # simultaneous GME requests      */
#define MAXBTV   5                 /* max # btrieve acquires per cycle     */
#define EMLID    0U                /* E-mail destination ID                */
#define FIRSTM   0L                /* "first message" code, for searches   */
#define LASTM    0x7FFFFFFFL       /* "last message" code, for searches    */
#define FORIDC   '/'               /* E-mail directed to a forum prefix    */
#define NOIDX    -1                /* valid index not found return value   */
#define ALLINF    "** ALL **"      /* "to all in forum" string             */
#define FLNSIZ   (MAXFILE+MAXEXT-1) /* DOS file name buffer size           */

#ifdef DEBUG
#define NVQSCSZ 404                /* size of non-variable part of qsc rec */
#endif
struct qscfg {                     /* quickscan/config per-user data       */
     char userid[UIDSIZ];          /*   master key for lookups             */
     char fwdee[MAXADR];           /*   auto-forwardee for E-mail (if any) */
     unsigned fwdate;              /*   date that forwardee was chosen     */
     char kwds[MAXSKWD];           /*   quickscan keywords                 */
     unsigned curfor;              /*   current forum ID                   */
     int nforums;                  /*   number of forums in quickscan      */
     int flags;                    /*   preference and quickscan flags     */
     long stmsg;                   /*   quickscan starting message ID      */
     char spare[26];               /*   spare space                        */
     char accmsg[1];               /*   start of variable-len accmsg stuff */
};                                 /*   2 arrays: forumID+msgID, acclvl    */
                                   /*   msgID > 0 == "real" quickscan forum*/

                                   /* preference-related flag definitions  */
#define CLARPL  0x0001             /*   clear messages after replied to?   */
#define P4NEWM  0x0002             /*   pause at logon for new mail?       */
#define GORTIN  0x0004             /*   if pause, go right into E-mail?    */
#define FORUM2  0x0008             /*   consider forum mail E-mail "to"?   */
#define MSGQUO  0x0010             /*   use message quoting at all?        */
#define ALWQUO  0x0020             /*   always use message message quoting?*/
#define USRSET  0x0040             /*   user has set preferences           */
#define QWKATT  0x0080             /*   include attachments in QWK-Mail?   */
#define CMBHDR  0x0100             /*   combine header and body of messages*/
#define NEWMSG  0x0200             /*   new messages only in quickscan?    */
#define WATONL  0x0400             /*   msgs w/atts only in quickscan?     */
#define TOMEONL 0x0800             /*   msgs to me only in quickscan?      */
#define FRMEONL 0x1000             /*   msgs from me only in quickscan?    */
#define CFWCMT  0x2000             /*   comment when copy/fwding at all?   */
#define ALWCMT  0x4000             /*   always comment when copy/fwding    */

extern
int qssiz,                         /* size of in-memory quickscan          */
    _maxqsf;                       /* use MAXQSF, not this                 */
#define MAXQSF _maxqsf             /* max forums in a user's quickscan     */

                                   /* message reading sequence codes       */
#define ESQTOU 1                   /*   E-mail to user sequence            */
#define ESQFRU 2                   /*   E-mail from user sequence          */
#define ESQTHR 3                   /*   E-mail thread sequence             */
#define FSQFOR 4                   /*   Forum normal sequence              */
#define FSQTHR 5                   /*   Forum thread sequence              */
#define FSQSCN 6                   /*   Forum one-time scan sequence       */

                                   /* read nearest message "style" codes   */
#define LEGT 0                     /*   try less/equal then greater        */
#define LTGE 1                     /*   try less then greater/equal        */
#define GELT 2                     /*   try greater/equal then less        */
#define GTLE 3                     /*   try greater then less/equal        */

struct otscan {                    /* one-time scan setup structure        */
     char keywds[MAXSKWD];         /*   keywords                           */
     long stmsgid;                 /*   starting message ID (0 for none)   */
     char flags;                   /*   search flags                       */
     int nforums;                  /*   number of forums in list           */
     unsigned forlst[1];           /*   list of forums to scan             */
};

                                   /* one-time scan flags                  */
#define SCNEW  0x01                /*   include "new" messages only        */
#define SCATT  0x02                /*   include msgs w/attachments only    */
#define SCTOU  0x04                /*   include msgs to user only          */
#define SCFRU  0x08                /*   include msgs from user only        */
#define SCALL  0x10                /*   include all Forums !in Forum list  */

struct globid {                    /* global message identifier            */
     long sysid;                   /*   system ID of originating system    */
     long msgid;                   /*   message ID on originating system   */
};

struct message {                   /* in-memory message structure          */
     unsigned forum;               /*   ID of forum message belongs to     */
     long msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     long thrid;                   /*   ID of thread message is part of    */
     char from[MAXADR];            /*   originator                         */
     char to[MAXADR];              /*   recipient                          */
     char topic[TPCSIZ];           /*   main topic, editable, carried over */
     char history[HSTSIZ];         /*   history/routing (reply to #88888,  */
                                   /*     fw by Aaaaaaaaa, cc: of #99999)  */
     char attname[FLNSIZ];         /*   attached file name                 */
     unsigned crdate;              /*   message creation date              */
     unsigned crtime;              /*   message creation time of day       */
     struct globid rplto;          /*   message that this is a reply to    */
     int nrpl;                     /*   number of times replied to         */
     long flags;                   /*   message/attachment flag bits       */
};

                                   /* message flag bits                    */
#define NONSYSF 0x0000FFFFL        /*   non-system flag bits               */
#define SYSFLGS 0xFFFF0000L        /*   system-only flag bits              */
#define PRIMSG  0x00000001L        /*   message is "priority"              */
#define EXEMPT  0x00000002L        /*   message is exempt from auto-delete */
#define RECREQ  0x00000010L        /*   return-receipt requested when read */
#define FILIND  0x00000020L        /*   "indirect" att, direct has filespec*/
#define FILATT  0x00000040L        /*   file is attached to this message   */
#define FILAPV  0x00000080L        /*   file attached is ok to download    */
#define NODEL   0x00000100L        /*   sender can't delete                */
#define NOMOD   0x00000200L        /*   sender can't modify                */
#define ISMPTR  0x00010000L        /*   message header points to other msg */
#define ISTCPY  0x00020000L        /*   message is complete alias of other */
#define FRCLR   0x00040000L        /*   from field of message "cleared"    */
#define TOCLR   0x00080000L        /*   to field of message "cleared"      */

extern
unsigned _txtlen;                  /* use TXTLEN, not this                 */
#define TXTLEN _txtlen             /* message text buffer size             */

struct fordef {                    /* in-memory forum definition struct    */
     unsigned forum;               /*   unique forum identifier            */
     char name[FORNSZ];            /*   forum name                         */
     char topic[TPCSIZ];           /*   short description/topic            */
     char forop[UIDSIZ];           /*   User-ID of Forum-Op                */
     int dfnum;                    /*   index of forum's data file in array*/
     char *attpath;                /*   path where attachments are stored  */
     unsigned nthrs;               /*   number of threads in forum         */
     unsigned nmsgs;               /*   number of messages in forum        */
     unsigned nfiles;              /*   number of files in forum           */
     unsigned nw4app;              /*   number of files waiting for apprvl */
     char forlok[KEYSIZ];          /*   key required for privileged access */
     unsigned char dfnpv;          /*   default non-priv access setting    */
     unsigned char dfprv;          /*   default priviledged access setting */
     unsigned char mxnpv;          /*   maximum non-priv access setting    */
     int msglif;                   /*   message lifetime (days)            */
     int chgmsg;                   /*   charge per message posted          */
     int chgrdm;                   /*   charge per message read            */
     int chgatt;                   /*   charge per file attachment uploaded*/
     int chgadl;                   /*   charge per file attachment download*/
     int chgupk;                   /*   charge per-kbyte for upload        */
     int chgdpk;                   /*   charge per-kbyte for download      */
     int ccr;                      /*   credit consumption rate            */
     unsigned char pfnlvl;         /*   profanity suppression level        */
     unsigned crdate;              /*   forum creation date                */
     unsigned crtime;              /*   forum creation time of day         */
     unsigned seqid;               /*   number of forum in list of forums  */
     int necho;                    /*   number of echo addresses           */
     char *echoes;                 /*   pointer to echo address array      */
};

#ifdef DEBUG
#define NVFORSZ 309                /* size of non-variable part of def rec */
#endif
struct fordsk {                    /* on-disk forum definition structure   */
     unsigned forum;               /*   unique forum identifier            */
     char name[FORNSZ];            /*   forum name                         */
     char topic[TPCSIZ];           /*   short description/topic            */
     char forop[UIDSIZ];           /*   forum-op                           */
     char datfil[MAXPATH];         /*   path+file name of forum data file  */
     char attpath[MAXDIR];         /*   path where attachments are stored  */
     unsigned nthrs;               /*   number of threads in forum         */
     unsigned nmsgs;               /*   number of messages in forum        */
     unsigned nfiles;              /*   number of files in forum           */
     unsigned nw4app;              /*   number of files waiting for apprvl */
     char forlok[KEYSIZ];          /*   key required for privileged access */
     int dfnpv;                    /*   default non-privileged access      */
     int dfprv;                    /*   default privileged access setting  */
     int mxnpv;                    /*   maximum non-privileged access      */
     int msglif;                   /*   message lifetime (days)            */
     int chgmsg;                   /*   charge per message posted          */
     int chgrdm;                   /*   charge per message read            */
     int chgatt;                   /*   charge per file attachment uploaded*/
     int chgadl;                   /*   charge per file attachment download*/
     int chgupk;                   /*   charge per-kbyte for upload        */
     int chgdpk;                   /*   charge per-kbyte for download      */
     int ccr;                      /*   credit consumption rate            */
     int pfnlvl;                   /*   profanity suppression level        */
     unsigned crdate;              /*   forum creation date                */
     unsigned crtime;              /*   forum creation time of day         */
     int necho;                    /*   number of echo addresses           */
     unsigned seqid;               /*   number of forum in list of forums  */
     char spare[8];                /*   spare space, decrease when adding  */
     char info[1];                 /*   variable-length forum info         */
                                   /*   echo addresses (if any)            */
                                   /*   description/help message           */
};

struct foracc {                    /* forum access info structure          */
     int dfnpv;                    /*   default non-privileged access      */
     int dfprv;                    /*   default privileged access setting  */
     int mxnpv;                    /*   maximum non-privileged access      */
     char forlok[KEYSIZ];          /*   key required for privileged access */
};

                                   /* forum access codes                   */
#define NOAXES 0                   /*   no access                          */
#define RDAXES 2                   /*   read access                        */
#define DLAXES 4                   /*   download access                    */
#define WRAXES 6                   /*   write access                       */
#define ULAXES 8                   /*   upload access                      */
#define COAXES 10                  /*   Co-Op access                       */
#define OPAXES 12                  /*   (ret from foracc() when Forum-Op)  */
#define SYAXES 14                  /*   (ret from foracc() when Sysop)     */
#define NOTSET 15                  /*   not set yet (use default)          */
#define DFTPFN 4                   /* use pfceil for profanity check       */
#define MAXFDV (16384-sizeof(struct fordsk)-1)
                                   /* max variable part of forum definition*/
#define MAXFDESC MAXFDV            /* max forum description length         */
#define MAXECHO (MAXFDV/MAXADR)    /* max number of echoes/forum           */

typedef char adr_t[MAXADR];        /* for accessing echo address array     */

#ifdef DEBUG
#define NVQIKSZ 110                /* size non-variable part of quick rec  */
#endif
#define MAXQIK 40                  /* max entries in a !QUICK list         */
struct qikdat {                    /* !QUICK list records structure        */
     char userid[UIDSIZ];          /*   key value for look-up              */
     int  idx[MAXQIK];             /*   array of entry indexes             */
     char list[1];                 /*   variable-length entry data         */
};
#define MAXQKR (sizeof(struct qikdat)-1+MAXQIK*MAXADR)/* max !QUICK rec len*/

#define PFXSIZ 4                   /* max exporter prefix size             */
#define EXPNSZ 16                  /* max exporter name size               */
#define EXPDSZ 51                  /* max exporter description size        */

struct exporter {                  /* message exporter control block       */
     char prefix[PFXSIZ];          /*   address prefix for this exporter   */
     char name[EXPNSZ];            /*   name of exporter (e.g., "Internet")*/
     char desc[EXPDSZ];            /*   description of exporter            */
     char exmp[MAXADR];            /*   example address to this exporter   */
     char wrtkey[KEYSIZ];          /*   key required to use this exporter  */
     int wrtchg;                   /*   per-message surcharge              */
     char attkey[KEYSIZ];          /*   key required for file attachments  */
     int attchg;                   /*   attachment surcharge               */
     int apkchg;                   /*   attachment per-kbyte surcharge     */
     char rrrkey[KEYSIZ];          /*   key required to request return recp*/
     int rrrchg;                   /*   return receipt request surcharge   */
     char prikey[KEYSIZ];          /*   key required to send priority msg  */
     int prichg;                   /*   priority surcharge                 */
     int flags;                    /*   supported features flags           */
     char *(*helpmsg)(void);       /*   get help message for this exporter */
     BOOL (*valadr)(char *);       /*   is this a valid address vector     */
     char *(*attspc)(char *,struct message *); /* path+file name for att   */
     int (*sndmsg)(char *,struct message *,char *,char *);
};                                 /*   send message vector                */

struct expinfo {                   /* info about exporter for interface    */
     char prefix[PFXSIZ];          /*   address prefix for this exporter   */
     char name[EXPNSZ];            /*   name of exporter (e.g., "Internet")*/
     char desc[EXPDSZ];            /*   description of exporter            */
     char exmp[MAXADR];            /*   example address to this exporter   */
     char wrtkey[KEYSIZ];          /*   key required to use this exporter  */
     int wrtchg;                   /*   per-message surcharge              */
     char attkey[KEYSIZ];          /*   key required for file attachments  */
     int attchg;                   /*   attachment surcharge               */
     int apkchg;                   /*   attachment per-kbyte surcharge     */
     char rrrkey[KEYSIZ];          /*   key required to request return recp*/
     int rrrchg;                   /*   return receipt request surcharge   */
     char prikey[KEYSIZ];          /*   key required to send priority msg  */
     int prichg;                   /*   priority surcharge                 */
     int flags;                    /*   supported features flags           */
};

                                   /* exporter flags                       */
#define EXPATT   0x0001            /*   support attachments?               */
#define EXPRRR   0x0002            /*   support return receipts?           */
#define EXPPRI   0x0004            /*   support priority msgs?             */

                                   /* GME request status codes             */
#define GMEAGAIN 0                 /*   GME still processing request       */
#define GMEOK    1                 /*   generic "finished OK" status       */
#define GMEAFWD  2                 /*   message was auto-forwarded         */
#define GMERRG   3                 /*   return receipt generated           */
#define GMEERR  -1                 /*   generic "error" status             */
#define GMEDUP  -2                 /*   unique name or ID exists           */
#define GME2MFR -3                 /*   too many forums error              */
#define GMENFID -4                 /*   no available forum IDs error       */
#define GMENFND -5                 /*   generic "not found" error          */
#define GMENDEL -6                 /*   generic "can't delete" error       */
#define GMENMOD -7                 /*   generic "can't modify" error       */
#define GMEFDV  -8                 /*   variable part of forum def too long*/
#define GMECRD  -9                 /*   not enough credits for operation   */
#define GMEMEM  -10                /*   not enough memory for operation    */
#define GMEIVA  -11                /*   invalid attachment to message      */
#define GMENOAT -12                /*   unable to attach file to message   */
#define GMEACC  -13                /*   user doesn't have access           */
#define GMENRGM -14                /*   couldn't re-get message            */
#define GMENCFL -15                /*   can't copy/fwd to a dist list      */
#define GMERST  -16                /*   E-mail message pointer reset       */
#define GMEUSE  -17                /*   message in use, can't modify or del*/
#define GMENAPV -18                /*   attachment not approved for dnload */
#define GME2MFL -19                /*   too many forum data files error    */
#define GMENSRC -20                /*   source not found                   */
#define GMENDST -21                /*   destination not found              */

                                   /* feature validation codes             */
#define VALYES   1                 /*   feature is available               */
#define VALNO   -1                 /*   feature is not available           */
#define VALACC  -2                 /*   user doesn't have access           */
#define VALCRD  -3                 /*   user doesn't have enough credits   */

                                   /* callback event codes                 */
#define EVTSTRT  0                 /*   starting to send a message         */
#define EVTDONE  1                 /*   done sending a message             */
#define EVTCCST  2                 /*   starting to send carbon copies     */
#define EVTDSTS  3                 /*   starting distribution              */
#define EVTDSTD  4                 /*   done with distribution             */
#define EVTCPYS  5                 /*   starting to copy a file            */
#define EVTCPYD  6                 /*   done copying a file                */
#define EVTNEWF  7                 /*   starting to scan a new forum       */
#define EVTNEWM  8                 /*   starting to scan a new message     */

struct oldmsg {                    /* 6.X message structure                */
     long msgno;                   /* message number                       */
     char userto[UIDSIZ];          /* User-ID personally to, or "** ALL **"*/
     char from[UIDSIZ];            /* message originator                   */
     char to[UIDSIZ];              /* recipient User-ID or SIG name        */
     char topic[TPCSIZ];           /* main topic, editable, carried over   */
     char auxtpc[HSTSIZ];          /* auxillary topic (reply to #88888,    */
                                   /*   fw by Aaaaaaaaa, cc: of #99999)    */
     unsigned crdate;              /* message creation date                */
     unsigned crtime;              /* message creation time of day         */
     int nreply;                   /* number of times replied to           */
     int flags;                    /* message/attachment flag bits         */
     char spare[5];                /* spare space, decrease when adding on */
     char text[1];                 /* variable-length message text         */
};

typedef BOOL (*cflfunc)(void *work,unsigned forum,long msgid);

/* forum CNF options */
extern
int forccr,                   /* default forum credit consumption rate     */
    forlif,                   /* default lifetime of a forum message (days)*/
    fmschg,                   /* default credit charge to write forum msg  */
    fmrchg,                   /* default credit charge to read forum msg   */
    fulchg,                   /* default credit charge per file upload     */
    fkuchg,                   /* default per-kbyte charge per file upload  */
    fdlchg,                   /* default credit charge per file download   */
    fkdchg;                   /* default per-kbyte charge per file download*/
extern
BOOL fopmfd,                  /* allow forum-ops to modify forum defs?     */
     fdnaud,                  /* do audit trail entry for each forum dnld? */
     fupaud;                  /* do audit trail entry for each forum upld? */
extern
char *forsys,                 /* Sysop privileged forum usage key          */
     *forprv;                 /* privileged forum usage key                */
extern
unsigned dftfor;              /* default forum ID                          */

/* E-mail CNF options */
extern
int emllif,                   /* lifetime of an E-Mail message, in days    */
    e2urrr,                   /*   ret. rec. on new-user E-Mail if enabled */
    emschg,                   /* credit charge per E-Mail msg written      */
    eatchg,                   /* additional charge for attachment          */
    epkchg,                   /* additional per-kbyte charge for attachment*/
    rrrchg,                   /* additional charge for return receipt      */
    prichg,                   /* additional charge for priority message    */
    lstchg,                   /* credit charge for using distribution list */
    emrchg,                   /* credit charge per E-Mail msg read         */
    edachg,                   /* charge for attachment download            */
    edkchg,                   /* per-kbyte charge for attachment download  */
    dfpref;                   /* default user preferences                  */
extern
BOOL
     alweat,                  /* allow E-mail file attachments?            */
     alwrrr,                  /* allow E-mail return receipts?             */
     alwpri,                  /* allow priority E-Mail messages?           */
     chgfwd,                  /* charge recipient for auto-forward charges */
     ednaud,                  /* do audit trail entry for each E-mail dnld?*/
     eupaud;                  /* do audit trail entry for each E-mail upld?*/
extern
char
     *emlkey,                 /* key required to write E-mail              */
     *eatkey,                 /* key required to upload E-Mail attachments */
     *rrrkey,                 /* key required to request return receipts   */
     *prikey,                 /* key required to send priority messages    */
     *qikkey,                 /* key required to use !QUICK list           */
     *massky,                 /* key required to use !MASS list            */
     *edstky;                 /* key required to edit sysop-defined lists  */

/* special function hooks */
extern
BOOL (*hdlimphook)(struct message *,char *,char *);
                                   /* redirect imported message hook       */
extern
void (*newmsghook)(char *,struct message *,char *);
                                   /* new message notification hook        */
                                   /* notification type strings            */
#define WRITENOT "WRITE"           /*   new message written                */
#define REPLYNOT "REPLY"           /*   reply written                      */
#define IMPRTNOT "IMPORT"          /*   message imported                   */
#define DISTRNOT "DISTRIBUTE"      /*   message written as part of dist.   */
#define CCOPYNOT "CARBON COPY"     /*   message carbon copied              */
#define MCOPYNOT "COPY"            /*   message copied                     */
#define FORWDNOT "FORWARD"         /*   message forwarded                  */
#define RTRCPNOT "RETURN RECEIPT"  /*   return receipt generated           */

/* general utility macros */

#define isforum(s) (*(s) == FORIDC)
#define isdlst(s) (*(s) == '!' || *(s) == '@')
#define inqs(qsc,fid) (qsidx((qsc),(fid)) != NOIDX)
#define qsonsys(uid) (onsqsp(uid) != NULL)
#define noatt(msg) ((msg)->flags&=~(FILATT|FILAPV|FILIND))
#define fidxst(fid) (fid != EMLID && fididx(fid) != NOIDX)
#define fnmxst(name) (fnmidx(name) != NOIDX)

/* general utility functions */

unsigned                           /*   returns max message text length    */
txtlen(void);                      /* init__ callable get-text-length      */

int                                /*   returns max # forums allowed in qs */
maxqsf(void);                      /* init__ callable get-max-qscan-forums */

int                                /*   returns GME status code            */
inigmeu(void);                     /* initialize GME/user stuff at logon   */
                                   /*   (must be called by user interface) */

void                               /* (must be called by user interface)   */
clsgmeu(void);                     /* close GME/user stuff at logoff       */

void
inigmerq(                          /* initialize GME request               */
void *workb);                      /*   work area to be used for request   */

void
clsgmerq(                          /* close a GME request                  */
void *workb);                      /*   work area being used for request   */

BOOL
gmerqopn(                          /* is this request open?                */
void *workb);                      /*   pointer to work area               */

void
setgmecb(                          /* set handler for GME status reports   */
void *workb,                       /*   work area being used for request   */
void (*callback)());               /*   pointer to callback handler        */

char *
gmexinf(void);                     /* get extended return information      */

BOOL                               /*   returns TRUE if able to add to list*/
setcfl(                            /* set cooperative conflict checker     */
cflfunc cflchk);                   /*   function to check                  */

BOOL                               /*   returns TRUE if a conflict         */
chkcfl(                            /* chk others for conflict w/my cur msg */
void *workb);                      /*   work area being used to read       */

BOOL                               /*   returns TRUE if a conflict         */
chkmycfl(                          /* check my current message for conflict*/
void *workb,                       /*   my work area being used to read    */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid);                       /*   message ID w/possible conflict     */

BOOL                               /*   returns TRUE if a conflict         */
gencfl(                            /* generic conflict checker             */
void *workb,                       /*   work area in use                   */
unsigned forum,                    /*   forum ID to check                  */
long msgid);                       /*   msg ID to check (0L for forum only)*/

void
setscan(                           /* set the scan context                 */
void *workb,                       /*   for this work space                */
struct otscan *newscn);            /*   to this scan buffer                */

struct otscan *
getscan(                           /* get the current scan context buffer  */
void *workb);                      /*   for this work space                */

void
addf2ots(                          /* add forum to scan list in seq order  */
struct otscan *ots,                /*   one-time scan structure to update  */
unsigned forum);                   /*   forum to add                       */

int                                /*   returns NOIDX if not found         */
scnfidx(                           /* get index of forum in search list    */
struct otscan *ots,                /*   in this scan                       */
unsigned forum);                   /*   forum ID to find                   */

unsigned                           /*   returns EMLID if no forums         */
fstscnf(                           /* get first forum ID                   */
char *userid,                      /*   User-ID doing scan                 */
struct otscan *ots);               /*   in this search                     */

long
fstscnm(                           /* get first message ID                 */
char *userid,                      /*   User-ID doing scan                 */
struct otscan *ots,                /*   in this scan                       */
unsigned forum);                   /*   in this forum (in scan)            */

BOOL
adrxst(                            /* does this address exist              */
char *adr);                        /*   address to check                   */

BOOL                               /*   returns TRUE if address exists     */
fixadr(                            /* fix up an address                    */
char *from,                        /*   User-ID of sender (NULL for any)   */
char *adr);                        /*   address to fix up                  */

BOOL
islocal(                           /* is this a valid local address        */
char *adr);                        /*   address to check                   */

int                                /*   (returns NOIDX if not found)       */
fnmidx(                            /* get index of named forum in def array*/
char *name);                       /*   forum name                         */

int                                /*   (returns NOIDX if not found)       */
fididx(                            /* get index of forum ID in def array   */
unsigned fid);                     /*   forum ID                           */

unsigned                           /*   returns EMLID if doesn't exist     */
getfid(                            /* get forum ID                         */
char *name);                       /*   given forum name                   */

char *                             /*   returns NULL if doesn't exist      */
getfnm(                            /* get forum name                       */
unsigned fid);                     /*   given forum ID                     */

char *                             /*   returns NULL if doesn't exist      */
getftpc(                           /* get forum topic                      */
unsigned fid);                     /*   given forum ID                     */

BOOL
valfornm(                          /* is this a valid forum name?          */
char *name);                       /*   name to check                      */

BOOL                               /*   TRUE if access > NOAXES            */
faccok(                            /* current user has access to Forum?    */
unsigned forum);                   /*   forum ID to get topic for          */

int                                /*   returns standard GME status codes  */
setaxes(                           /* set access for a user                */
unsigned fid,                      /*   forum to set access for            */
char *uid,                         /*   user to set access for             */
int acc);                          /*   access to set to                   */

int                                /*   returns standard GME status codes  */
cpyaxes(                           /* copy forum access                    */
char *dstusr,                      /*   to this User-ID                    */
char *srcusr);                     /*   from this User-ID                  */

struct qscfg *                     /*   returns NULL if not found          */
onsqsp(                            /* get online user's quickscan          */
char *uid);                        /*   given User-ID                      */

struct qscfg *
uqsptr(                            /* get online user's quickscan          */
int unum);                         /*   given user number                  */

struct qscfg *
myqsptr(void);                     /* get current user's quickscan         */

BOOL                               /*   returns FALSE if unable to add     */
sfinqs(                            /* set forum in quickscan               */
struct qscfg *qsc,                 /*   quickscan record                   */
unsigned fid,                      /*   forum to set                       */
BOOL turnon);                      /*   TRUE = make forum "in" quickscan   */

void
initqs(                            /* initialize a new user's quickscan    */
struct qscfg *qsc,                 /*   pointer to quickscan buffer        */
char *uid);                        /*   User-ID to initialize              */

struct otscan *                    /*   returns copy of pointer to dest    */
qsc2ots(                           /* copy quickscan to a one-time scan buf*/
struct qscfg *qsc,                 /*   quickscan to copy                  */
struct otscan *ots);               /*   one-time scan buffer               */

int                                /*   index of new entry (NOIDX if error)*/
absadqs(                           /* add forum to qs, del others for room */
struct qscfg *qsc,                 /*   quickscan record                   */
unsigned fid);                     /*   forum ID to add                    */

int                                /*   index in qs arrays (NOIDX if err)  */
qsidx(                             /* get index of forum in quickscan      */
struct qscfg *qsc,                 /*   quickscan record                   */
unsigned fid);                     /*   forum ID to get                    */

int                                /*   index in qs arrays (NOIDX if err)  */
add2qs(                            /* add slot for forum to quickscan      */
struct qscfg *qsc,                 /*   quickscan record                   */
unsigned fid);                     /*   forum ID to add                    */

void
delqs(                             /* delete an entry from the quickscan   */
struct qscfg *qsc,                 /*   pointer to quickscan               */
unsigned forum);                   /*   forum ID to remove from quickscan  */

BOOL                               /*   returns TRUE if able to set        */
sethi(                             /* set hi message in quickscan          */
struct qscfg *qsc,                 /*   pointer to quickscan               */
unsigned forum,                    /*   forum ID to set for                */
long msgid);                       /*   message ID to set as high message  */

BOOL                               /*   returns TRUE if able to set        */
setac(                             /* set forum acc in quickscan           */
struct qscfg *qsc,                 /*   pointer to quickscan               */
unsigned forum,                    /*   forum ID to set for                */
int acc);                          /*   access level to set                */

long
gethi(                             /* get hi message in quickscan          */
struct qscfg *qsc,                 /*   pointer to quickscan               */
unsigned forum);                   /*   forum ID to get for                */

void
idelqs(                            /* delete an entry from the quickscan   */
struct qscfg *qsc,                 /*   pointer to quickscan               */
int idx);                          /*   index of entry to delete           */

void
isethi(                            /* set hi message in quickscan (w/index)*/
struct qscfg *qsc,                 /*   pointer to quickscan               */
int idx,                           /*   index of forum to set              */
long msgid);                       /*   message ID to set as high message  */

void
isetac(                            /* set forum acc in quickscan (w/index) */
struct qscfg *qsc,                 /*   pointer to quickscan               */
int idx,                           /*   index of forum to set              */
int acc);                          /*   access level to set                */

unsigned
igetfid(                           /* get forum ID in quickscan (w/index)  */
struct qscfg *qsc,                 /*   pointer to quickscan               */
int idx);                          /*   index of forum to get              */

long
igethi(                            /* get hi message in quickscan (w/index)*/
struct qscfg *qsc,                 /*   pointer to quickscan               */
int idx);                          /*   index of forum to get              */

int
igetac(                            /* get forum acc in quickscan (w/index) */
struct qscfg *qsc,                 /*   pointer to quickscan               */
int idx);                          /*   index of forum to get              */

int                                /*   returns index or NOIDX if none     */
qsdelf(                            /* get first non-existent forum         */
struct qscfg *qsc);                /*   pointer to quickscan               */

int                                /*   returns index or NOIDX if none     */
qsoldm(                            /* get oldest "marker" entry            */
struct qscfg *qsc);                /*   pointer to quickscan               */

int                                /*   returns index or NOIDX if none     */
qsoldr(                            /* get oldest "real" entry              */
struct qscfg *qsc);                /*   pointer to quickscan               */

BOOL                               /*   was able to allocate?              */
alcarr(                            /* alloc another item in array in blocks*/
void **ppar,                       /*   pointer to pointer to array        */
int itmsiz,                        /*   size of individual array items     */
int nitems,                        /*   # items currently in array         */
int blksiz);                       /*   # items in each block              */
                                   /*   (assumes ++nitems after each call) */

#define alcpar(p,n,b) alcarr((void **)(p),sizeof(void *),(n),(b))/* ptr arr*/
#define alciar(p,n,b) alcarr((void **)(p),sizeof(int),(n),(b))/* int array */

char *                             /*   returns pointer to string          */
zpad(                              /* zero pad a string                    */
char *s,                           /*   pointer to string                  */
int len);                          /*   length of string buffer            */

char *                             /*   ptr to next entry (NULL if done)   */
parscc(                            /* parse next cc: from list             */
char *addr,                        /*   buffer to put cc: address into     */
char *list);                       /*   ';'-delimited cc: list             */

BOOL                               /*   returns TRUE if directory exists   */
fmdir(                             /* find or make directory               */
char *dirname);                    /*   directory name                     */

BOOL                               /*   returns TRUE if successful         */
makedir(                           /* make nested directories              */
char *dirname);                    /*   directory name(s)                  */

BOOL                               /*   returns TRUE if directory exists   */
dexist(                            /* check if directory exists            */
char *dirname);                    /*   name of directory (no trailing \)  */

BOOL                               /*   returns TRUE if file exists        */
fexist(                            /* check if file exists                 */
char *name);                       /*   path+file name to find             */

BOOL                               /*   returns TRUE if a valid file name  */
valfnm(                            /* check for valid file name            */
char *name);                       /*   string to check                    */

char *                             /*   returns pointer to file name       */
tmpanam(char *dest);               /* create temp attachment file name     */

BOOL
istmp(                             /* is this a temporary attachment file  */
char *fname);                      /*   path+file name to check            */

BOOL
dlstxst(                           /* does dist list exist?                */
char *name);                       /*   complete list name (incl @ or !)   */

int                                /*   returns standard GME status codes  */
nxtslst(                           /* get name of next sysop dist list     */
char *lstnam,                      /*   buffer for list name               */
char *lstkey,                      /*   buffer for list key                */
int *surchg);                      /*   buffer for list surcharge          */

int                                /*   returns standard GME status codes  */
getslst(                           /* get info on sysop dist list          */
char *lstnam,                      /*   list name                          */
char *lstkey,                      /*   buffer for list key                */
int *surchg);                      /*   buffer for list surcharge          */

int                                /*   returns standard GME status codes  */
slstfil(                           /* get info about sysop list            */
char *lstnam,                      /*   list name                          */
char *lstpath);                    /*   buffer for list path & file name   */

int                                /*   returns standard GME status codes  */
newslst(                           /* create a new sysop distribution list */
void *workb,                       /*   GME work space                     */
char *lstnam,                      /*   name for new list                  */
char *lstkey,                      /*   key required to use list           */
int surchg);                       /*   surcharge to use list              */

int                                /*   returns standard GME status codes  */
delslst(                           /* delete a sysop dist list             */
char *lstnam);                     /*   name of list                       */

int                                /*   returns standard GME status codes  */
edtslst(                           /* open a sysop dist list for editing   */
void *workb,                       /*   work area to initialize            */
char *lstnam);                     /*   name of list                       */

int                                /*   returns standard GME status codes  */
addslst(                           /* add an address to a sysop list       */
void *workb,                       /*   GME work space                     */
char *addr);                       /*   address to add to list             */

int                                /*   returns standard GME status codes  */
rstlstp(                           /* set sysop list pointer to top of list*/
void *workb);                      /*   GME work space                     */

BOOL
nxtsys(                            /* get next entry in sysop list         */
void *workb,                       /*   work area to use                   */
char *addr);                       /*   buffer for address                 */

struct qikdat *                    /*   copy of pointer to buffer          */
getqik(                            /* get a !QUICK list from disk          */
struct qikdat *qikbuf,             /*   pointer to !QUICK buffer           */
char *userid);                     /*   user ID to use                     */

void
savqik(                            /* save a !QUICK list to disk           */
struct qikdat *qikbuf);            /*   pointer to !QUICK buffer           */

struct qikdat *                    /*   copy of pointer to buffer          */
iniqik(                            /* initialize !QUICK record for cur user*/
struct qikdat *qikbuf,             /*   pointer to !QUICK buffer           */
char *userid);                     /*   user ID to use                     */

void
insqik(                            /* insert entry into !QUICK buffer      */
int pos,                           /*   position to insert at              */
char *entry,                       /*   new entry for position             */
struct qikdat *qikbuf);            /*   pointer to !QUICK buffer           */

void
delqik(                            /* delete an entry from !QUICK buffer   */
int pos,                           /*   position to delete                 */
struct qikdat *qikbuf);            /*   pointer to !QUICK buffer           */

BOOL
valslnm(                           /* is this a valid sysop dist list name?*/
char *name);                       /*   complete name (including @)        */

BOOL
dlstxst(                           /* does dist list exist?                */
char *name);                       /*   complete list name (incl @ or !)   */

/* user interface interface functions */

int                                /*   returns standard GME status codes  */
inifdef(                           /* initialize forum def w/defaults      */
void *workb,                       /*   GME work space (provided by caller)*/
struct fordsk *newdef);            /*   memory area to initialize          */

int                                /*   returns standard GME status codes  */
creatfor(                          /* create a new forum                   */
void *workb,                       /*   GME work space (provided by caller)*/
struct fordsk *newdef,             /*   new forum definition structure     */
char *desc,                        /*   descriptive text                   */
char *echoes);                     /*   pointer to array of echo addresses */
                                   /*   (may be NULL if no echoes)         */

long
himsgid(void);                     /* get current highest message ID       */

unsigned
numforums(void);                   /* get number of forums                 */

struct fordef *                    /*   pointer to temporary buffer        */
getdefp(                           /* get pointer to forum definition      */
unsigned forum);                   /*   forum ID of def to get             */

struct fordef *                    /*   pointer to destination buffer      */
getdefb(                           /* copy forum def into a work buffer    */
unsigned forum,                    /*   forum ID of def to get             */
struct fordef *workdef);           /*   pointer to work buffer             */

struct fordef *                    /*   pointer to temporary buffer        */
fiddefp(                           /* ptr to forum def in forum ID order   */
unsigned idx);                     /*   index of forum ID                  */

struct fordef *                    /*   pointer to destination buffer      */
fiddefb(                           /* get forum def in forum ID order      */
unsigned idx,                      /*   index of forum ID                  */
struct fordef *workdef);           /*   pointer to work buffer             */

struct fordef *                    /*   pointer to temporary buffer        */
seqdefp(                           /* get pointer to forum def in sequence */
unsigned seqid);                   /*   sequence ID of forum               */

struct fordef *                    /*   pointer to destination buffer      */
seqdefb(                           /* get forum def into buffer in sequence*/
unsigned seqid,                    /*   sequence ID of forum               */
struct fordef *workdef);           /*   pointer to work buffer             */

struct fordef *                    /*   pointer to temporary buffer        */
nxtdefp(                           /* get ptr to next forum definition     */
char *name);                       /*   given name to start with           */

struct fordef *                    /*   pointer to destination buffer      */
nxtdefb(                           /* copy next forum def into a work buf  */
char *name,                        /*   given name to start with           */
struct fordef *workdef);           /*   pointer to work buffer             */

struct fordef *                    /*   pointer to temporary buffer        */
prvdefp(                           /* get ptr to prev forum definition     */
char *name);                       /*   given name to start with           */

struct fordef *                    /*   pointer to destination buffer      */
prvdefb(                           /* copy prev forum def into a work buf  */
char *name,                        /*   given name to start with           */
struct fordef *workdef);           /*   pointer to work buffer             */

void
getecho(                           /* copy forum's echoes into work buffer */
unsigned forum,                    /*   forum ID to get                    */
char *echoes);                     /*   pointer to work buffer             */

void
getdesc(                           /* copy forum's desc into work buffer   */
unsigned forum,                    /*   forum ID to get                    */
char *desc);                       /*   pointer to work buffer             */

void
getallf(                           /* get all info about a forum           */
unsigned forum,                    /*   forum ID to get                    */
struct fordsk *workdef,            /*   on-disk forum definition format    */
char *desc,                        /*   buffer for description             */
char *echoes);                     /*   buffer for echoes                  */

int                                /*   returns standard GME status codes  */
cfgfacc(                           /* configure default access             */
unsigned forum,                    /*   for this forum                     */
struct foracc *acc);               /*   forum access structure             */

int                                /*   returns standard GME status codes  */
modfor(                            /* modify a forum                       */
void *workb,                       /*   GME work space (provided by caller)*/
struct fordef *newdef,             /*   modified forum description         */
char *desc,                        /*   descriptive text                   */
char *echoes);                     /*   pointer to array of echo addresses */
                                   /*(desc & echoes may be NULL if no chng)*/

int                                /*   returns standard GME status codes  */
delfor(                            /* delete a forum                       */
void *workb,                       /*   GME work space (provided by caller)*/
unsigned forum);                   /*   forum ID to delete                 */

int                                /*   returns VAL code                   */
valadr(                            /* validate address                     */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns VAL code                   */
valatt(                            /* validate file attachments            */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns VAL code                   */
valrrr(                            /* validate return receipt request      */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns VAL code                   */
valpri(                            /* validate priority messaging          */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns VAL code                   */
vfwdadr(                           /* validate address for forwarding      */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID doing the forwarding       */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns VAL code                   */
vfwdatt(                           /* validate attachment for forwarding   */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns VAL code                   */
vfwdpri(                           /* validate priority message for fwding */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum);                   /*   forum message being written in     */

int                                /*   returns standard GME status code   */
val2gme(                           /* convert a VAL code to status code    */
int valcode);                      /*   VAL code to convert                */

char *                             /*   path & file name to place file in  */
ulname(                            /* path & file name to upload att to    */
struct message *msg);              /*   header of message to attach to     */

char *                             /*   path & file name of attachment     */
dlname(                            /* path & file name to dnload att from  */
struct message *msg);              /*   header of message with attachment  */

long
sendchg(                           /* total charges to send a message      */
void *workb,                       /*   work area in use                   */
struct message *msg,               /*   new message structure              */
long attsiz);                      /*   attachment size                    */

int                                /*   returns standard GME status codes  */
simpsnd(                           /* simple send msg (non-user specific)  */
struct message *msg,               /*   message header structure           */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

int                                /*   returns standard GME status codes  */
gsndmsg(                           /* send message (non-user specific)     */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

int                                /*   returns standard GME status codes  */
sendmsg(                           /* send a new message from a user       */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt,                      /*   path+file name of att (if any)     */
char *cclist);                     /*   list of cc: addresses (if any)     */

int                                /*   returns standard GME status codes  */
reply(                             /* reply to current message in context  */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text,                        /*   new message text                   */
char *filatt,                      /*   path+file name of att (if any)     */
char *cclist);                     /*   list of cc: addresses (if any)     */

int                                /*   returns standard GME status codes  */
copymsg(                           /* send copy of current msg in context  */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text);                       /*   message text                       */

int                                /*   returns standard GME status codes  */
fwdmsg(                            /* forward current message in context   */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text);                       /*   message text                       */

int                                /*   returns standard GME result codes  */
tagatt(                            /* create tag for message attachment    */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *tag);                        /*   file tag buffer to use             */

long
msgintg(                           /* what's the message ID associated     */
char *tag);                        /*   with this tag?                     */

unsigned
forintg(                           /* what's the forum ID associated       */
char *tag);                        /*   with this tag?                     */

BOOL                               /*   ok to download?                    */
gdlatt(                            /* tagged attachment downloaded for user*/
char *userid,                      /*   User-ID attachment downloaded for  */
char *tag);                        /*   file tag structure in use          */

BOOL                               /*   ok to start download?              */
dlstart(                           /* current user starts tagged att dnload*/
char *tag);                        /*   file tag structure in use          */

void
dlabt(                             /* current user aborted att download    */
char *tag);                        /*   file tag structure in use          */

void
dldone(                            /* current user finished att download   */
char *tag);                        /*   file tag structure in use          */

struct message *                   /*   pointer to temporary msg struct    */
tagmsg(                            /* get tagged message                   */
char *tag);                        /*   file tag structure in use          */

long
firstnew(                          /* get first new message #              */
char *userid,                      /*   for this user ID                   */
unsigned forum);                   /*   in this forum                      */

void
inormrd(                           /* initialize "normal" read context     */
void *workb,                       /*   work area to initialize            */
char *userid,                      /*   user ID doing reading              */
unsigned forum,                    /*   forum to read from                 */
long msgid);                       /*   message to start at                */

void
forctx(                            /* change forum of read context         */
void *workb,                       /*   work area in use                   */
unsigned forum,                    /*   forum to change to                 */
int sequence);                     /*   new sequence to establish          */

void
seqctx(                            /* change sequence of read context      */
void *workb,                       /*   work area in use                   */
int sequence);                     /*   sequence to change to              */

void
msgctx(                            /* change cur message of read context   */
void *workb,                       /*   work area in use                   */
long msgid);                       /*   message ID to change to            */

void
thrctx(                            /* change thread of read context        */
void *workb,                       /*   work area in use                   */
long thrid);                       /*   thread ID to change to             */

void
inictx(                            /* initialize read context              */
void *workb,                       /*   work area to initialize            */
char *userid,                      /*   user ID doing reading              */
int sequence,                      /*   sequence to use                    */
unsigned forum,                    /*   forum to read from                 */
long msgid,                        /*   message to start at                */
long thrid);                       /*   thread to use (if any)             */

int                                /*   returns standard GME status codes  */
readpar(                           /* read parent of message               */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
thrinfo(                           /* read info on a thread (orig message) */
void *workb,                       /*   GME work space (provided by caller)*/
int direct,                        /*   direction (0=same, 1=next, -1=prev)*/
unsigned *nmsgs,                   /*   number of messages in thread       */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
readmsg(                           /* read current message in context      */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
nearmsg(                           /* read nearest to cur msg in context   */
void *workb,                       /*   GME work space (provided by caller)*/
int nearop,                        /*   get near "style" to use            */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
nextmsg(                           /* read next message in context         */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
prevmsg(                           /* read previous message in context     */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
nextseq(                           /* read next message a sequence         */
void *workb,                       /*   GME work space (provided by caller)*/
int sequence,                      /*   sequence to use                    */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
prevseq(                           /* read previous message in a sequence  */
void *workb,                       /*   GME work space (provided by caller)*/
int sequence,                      /*   sequence to use                    */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
markread(                          /* mark a message as read               */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
delmsg(                            /* delete current message in context    */
void *workb);                      /*   GME work space (provided by caller)*/

int                                /*   returns standard GME status codes  */
modmsg(                            /* modify current message in context    */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
aprvmsg(                           /* approve/unapprove current message    */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text,                        /*   message body text buffer           */
BOOL approve);                     /*   TRUE=approve, FALSE=unapprove      */

int                                /*   returns standard GME status codes  */
exmtmsg(                           /* exempt/unexempt current message      */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text,                        /*   message body text buffer           */
BOOL exempt);                      /*   TRUE=exempt, FALSE=unexempt        */

int                                /*   returns VAL code                   */
setafwd(                           /* set auto-forwardee for current user  */
char *newfwde);                    /*   new auto-forwardee                 */

int                                /*   returns VAL code                   */
wrtany(void);                      /* can current user E-mail anyone       */
                                   /*   (other than Sysop)                 */

int                                /*   returns standard access level code */
foracc(                            /* get current user's forum access level*/
unsigned fid);                     /*   given forum ID                     */

int                                /*   returns standard access level code */
gforac(                            /* get a user's forum access level      */
char *uid,                         /*   given any User-ID                  */
unsigned fid);                     /*   and forum ID                       */

int                                /*   returns standard access level code */
qforac(                            /* get a user's forum access level      */
struct qscfg *qsc,                 /*   given quickscan                    */
unsigned fid);                     /*   and forum ID                       */

char *
accstr(                            /* string describing forum access level */
int acclvl);                       /*   access level to describe           */

int                                /*   returns new number of echoes       */
addecho(                           /* add an echo to list                  */
char *echoes,                      /*   echo list buffer                   */
char *newadr,                      /*   echo address to add                */
int necho);                        /*   current number of echoes           */

int                                /*   returns new number of echoes       */
delecho(                           /* delete an echo from list             */
char *echoes,                      /*   echo list buffer                   */
int echonum,                       /*   index of echo address to delete    */
int necho);                        /*   current number of echoes           */

/* importer/exporter interface functions */

int                                /*   returns standard GME status codes  */
impmsg(                            /* import a message                     */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

void
register_exp(                      /* register an exporter                 */
struct exporter *exp);             /*   pointer to exporter control block  */

BOOL
valpfx(                            /* is this a valid exporter prefix?     */
char *prefix);                     /*   prefix to check                    */

BOOL
expavl(void);                      /* are any exporters available?         */

BOOL
isexpa(                            /* is this an exporter-style address    */
char *adr);                        /*   address to check                   */

int
numexp(void);                      /* get number of available exporters    */

int                                /*   returns NOIDX if not found         */
expidx(                            /* index of exporter in handler array   */
char *to);                         /*   address containing prefix          */

struct expinfo *                   /*   returns pointer to static buffer   */
expinf(                            /* get info on an exporter              */
int idx);                          /*   given exporter index               */

char *                             /*   ptr to temp area (may be msgbuf)   */
exphlp(                            /* get help message for an exporter     */
int idx);                          /*   given exporter index               */

/* backward-compatibility functions */

BOOL                               /*   returns TRUE if successful         */
_oldsend(                          /* backward-compatible to 6.X sendmsg() */
struct oldmsg *msg,                /*   6.X message structure              */
char *to);                         /*   destination address                */

char *                             /*   pointer to filespec                */
_oldafs(                           /* backward-compatible attachment fspec */
struct oldmsg *msg);               /*   old message structure              */

char *                             /*   returns NULL if none               */
tpcfnm(                            /* extract file name from topic         */
char *tpc);                        /*   topic string                       */

