/***************************************************************************
 *                                                                         *
 *   EDITASM.C                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Full Screen/Line Editor module's assembly source module.  *
 *                                                                         *
 *          Modifications for 6.0 - R. A. Rose 4/6/92                      *
 *             Full Screen Editor - R. A. Rose 11/9/90                     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "editfse.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

#define TASM_AVL 1

#ifdef TASM_AVL
#pragma inline
#endif

#ifndef TASM_AVL
void
chiscon(chan)                      /* Display from cursor on to EOL        */
int chan;
{
     register int i;

     for (i=80 ; i >= fsecpt->x ; i--) {
          if (fsecpt->begstg[i-1] != ' ') {
               break;
          }
     }
     chiouc(chan,ICRPOS,i-fsecpt->x+1);
     if (i != 80) {
          chious(chan,"\33[0K");
     }
     chious(chan,"\33[");
     chinum(chan,fsecpt->y);
     chious(chan,";");
     chinum(chan,fsecpt->x);
     chious(chan,"f");
}

void
chimvcl(src,dst,cnt)                    /* Move memory with source clear   */
char *src, *dst;
register int cnt;
{
     register int i;

     for (i=0 ; i < cnt ; i++) {
          dst[i]=src[i];
          src[i]=' ';
     }
}

void
chirmov(src,dst,cnt)                    /* Move Memory with no clear       */
char *src, *dst;
register int cnt;
{
     register int i;

     for (i=0 ; i < cnt ; i++) {
          dst[i]=src[i];
     }
}

void
chiouc(btchn,stg,cnt)                   /* Output a string by count        */
register int btchn,cnt;
char *stg;
{
     register int i;

     for (i=0 ; i < cnt ; i++) {
          chiout(btchn,stg[i]);
     }
}

void
chinum(btchn,val)                       /* Chiout a numeric value (0-99)   */
register int btchn,val;
{
     static char buf[]="00";

     buf[0]='0'+(val/10);
     buf[1]='0'+(val%10);
     chious(btchn,buf+(val > 9 ? 0 : 1));
}
#else
void
chiscon(chan)                      /* Display from cursor on to EOL        */
int chan;
{
     static char ceol[]="\33[0K\33[00;00f";

#ifdef __HUGE__
asm    push      ds
asm    mov       ax,EDITASM_DATA   /*  Manually load DS!                    */
asm    mov       ds,ax             /*  ...Borland 4 won't without a C ref   */
#endif
asm    push      es
asm    mov       ax,seg fsecpt
asm    mov       es,ax
asm    les       di,es:fsecpt
asm    mov       dx,es:[di].(struct fseusr)x
asm    mov       bx,es:[di].(struct fseusr)y
asm    mov       cx,81
asm    sub       cx,dx
asm    mov       dh,bl               /* DH=Y position, DL=X position */
asm    les       di,es:[di].begstg
asm    mov       si,di
asm    add       di,79
asm    mov       al,' '
asm    std
asm    repe scasb
asm    je        clr2eol
asm    push      dx                       /* save cursor position        */
asm    add       cx,1
asm    push      cx                       /* parameter: number to print  */
asm    xor       dh,dh
asm    add       si,dx
asm    dec       si
asm    push      es                       /* parameter: segment to print */
asm    push      si                       /* parameter: offset to print  */
asm    push      chan                     /* parameter: channel to go to */
asm    call far ptr _chiouc
asm    add       sp,8
asm    pop       dx                       /* restore cursor position     */
       clr2eol:
/* dh=fsecpt->y dl=fsecpt->x */
asm    cld
asm    push      ds
asm    pop       es
asm    mov       di,offset ceol
asm    add       di,6                     /* y parameter location        */
asm    mov       al,dh
asm    cbw
asm    mov       bx,10
asm    idiv      bl                       /* AH=remainder,  AL=quotent   */
asm    add       ax,0x3030                /* add a '00'                  */
asm    stosw
asm    add       di,1                     /* now at x parameter location */
asm    mov       al,dl
asm    cbw
asm    mov       bx,10
asm    idiv      bl                       /* AH=remainder,  AL=quotent   */
asm    add       ax,0x3030                /* add a '00'                  */
asm    stosw
asm    push      ds
asm    push      offset ceol
asm    push      chan
asm    call far ptr chious
asm    add       sp,6
asm    pop       es
#ifdef __HUGE__
asm    pop       ds                /*  restore DS to entry value           */
#endif
}

void
chimvcl(src,dst,cnt)                    /* Move memory with source clear   */
char *src, *dst;
int cnt;
{
asm    cld
asm    push      es
asm    push      ds
asm    mov       cx,cnt
asm    push      cx
asm    les       di,dst
asm    lds       si,src
asm    push      si
asm    rep movsb
asm    push      ds
asm    pop       es
asm    pop       di
asm    pop       cx
asm    mov       ax,0x2020
asm    rep stosb
asm    pop       ds
asm    pop       es
}

void
chirmov(src,dst,cnt)                    /* Move Memory with no clear       */
char *src, *dst;
register int cnt;
{
asm    cld
asm    push      es
asm    push      ds
asm    mov       cx,cnt
asm    les       di,dst
asm    lds       si,src
asm    rep movsb
asm    pop       ds
asm    pop       es
}

void
chiouc(btchn,stg,cnt)                   /* Output a string by count        */
int btchn,cnt;
char *stg;
{
#ifdef __HUGE__
asm  push ds
asm  mov  ax,EDITASM_DATA          /*  Manually load DS!                    */
asm  mov  ds,ax                    /*  ...Borland 4 won't without a C ref   */
#endif
asm    push      es
asm    mov       bx,cnt
asm    les       di,stg
asm    mov       al,es:[di+bx]
asm    mov byte ptr es:[di+bx],0
asm    push      ax
asm    push      di

asm    push      es
asm    push      di
asm    push      btchn
asm    call far ptr chious
asm    add       sp,6

asm    pop       di
asm    pop       ax
asm    mov       bx,cnt
asm    mov byte ptr es:[di+bx],al
asm    pop       es
#ifdef __HUGE__
asm  pop  ds                       /*  restore DS to entry value                        */
#endif
}

void
chinum(btchn,val)                       /* Chiout a numeric value (0-99)   */
int btchn,val;
{
     static char buf[]="00";

asm    push      es
asm    push      ds
asm    pop       es
asm    mov       di,offset buf
asm    mov       ax,val
asm    mov       bx,10
asm    idiv      bl                       /* AH=remainder,  AL=quotent    */
asm    add       ax,0x3030                /* add a '00'                   */
                                          /* AH=ones digit, AL=tens digit */
asm    cld
asm    stosw                              /* write reverses byte order    */
asm    sub       al,0x31                  /* a '0' will set carry flag    */
asm    jc        onedig
asm    dec       di
       onedig:
asm    dec       di
asm    mov       ax,btchn
asm    push      es
asm    push      di
asm    push      ax
asm    call far ptr chious
asm    add       sp,6
asm    pop       es
}
#endif
