/***************************************************************************
 *                                                                         *
 *   CSREGIS.C                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1995 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is the Registry agent.                                           *
 *                                                                         *
 *                                                - Bill Hyatt 9/4/94      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "registry.h"
#include "galregis.h"

#define FILREV "$Revision:   1.0.1.1.1.0  $"

#define   XBYTPQ    1+1+4          /* xtra bytes per ques in reg info stgs */
#define   RPFXSZ    3              /* size of "# of flds" ind in info stgs */
#define   MXRINF    MAXDPKV-RPFXSZ /* maximum size of reg info stgs        */

/* flags to indicate which Registry keys user has */
#define   HASAKY 0x01              /* user has registry agent access key   */
#define   HASCKY 0x02              /* user has key to create an entry      */
#define   HASVKY 0x04              /* user has key to view entries         */

#define   FLDSEP "\1"              /* field sep char for entries fm client */

STATIC void regread(int direction,struct saunam *dpknam);
STATIC void regwrite(struct saunam *dpknam,unsigned length,void *value);
STATIC void regxdone(void);
STATIC void regabort(void);

STATIC void makrinf(void);

struct agent regagt={              /* agent information structure          */
     "GALREG",                     /* appid                                */
     regread,                      /* read-dynapak function pointer        */
     regwrite,                     /* write-dynapak function pointer       */
     regxdone,                     /* file xfer-done function pointer      */
     regabort                      /* abort-request function pointer       */
};

STATIC
char *rinfstgs[MAXFLD];            /* strings to store registry info       */

char *regakey;                     /* key req'd to access registry agent   */

void
inicsregis(void)                   /* initialize registry agent            */
{
     register_agent(&regagt);
     regakey=stgopt(REGAKEY);
     makrinf();
}

STATIC void
makrinf(void)                      /* put registry info into rinfstgs[]    */
{
     int cfld,sidx=0,didx=0,lencsr=RPFXSZ,lenques,lim;
     char *csques[MAXFLD],*cslbl[MAXFLD],*csentsum;

     setmem(rinfstgs,MAXFLD*sizeof(char *),0);
     csentsum=stgopt(CSENTSUM);
     lencsr+=strlen(csentsum)+1;
     for (cfld=0 ; cfld < numfds ; cfld++) {
          cslbl[cfld]=stgopt(fldmsg(cfld)+LBLOFF);
          stpans(cslbl[cfld]);
          reflow(cslbl[cfld]);
          csques[cfld]=stgopt(fldmsg(cfld)+CSQOFF);
          stp4cs(csques[cfld]);
          lenques=+strlen(csques[cfld])+strlen(cslbl[cfld])+XBYTPQ;
          lencsr+=lenques;
          if (lencsr > MXRINF || cfld == numfds-1) {
               if (lencsr > MXRINF) {
                    rinfstgs[sidx]=alczer(lencsr+RPFXSZ+1-lenques);
               }
               else {
                    rinfstgs[sidx]=alczer(lencsr+RPFXSZ+1);
               }
               if (sidx == 0) {
                    strcat(rinfstgs[sidx],spr("%d\t",numfds));
                    strcat(rinfstgs[sidx],spr("%s\t",csentsum));
               }
               lim=lencsr > MXRINF ? cfld : numfds;
               strcat(rinfstgs[sidx],spr("%d\t",lim-didx));
               for (; didx < lim ; didx++) {
                    strcat(rinfstgs[sidx],csques[didx]);
                    strcat(rinfstgs[sidx],spr("\t%d\t",reginf[didx].anssiz));
                    strcat(rinfstgs[sidx],cslbl[didx]);
                    if (didx < lim-1) {
                         strcat(rinfstgs[sidx],"\t");
                    }
               }
               lencsr=lenques;
               sidx++;
          }
     }
     for (cfld=0 ; cfld < numfds ; cfld++) {
          free(cslbl[cfld]);
          free(csques[cfld]);
     }
}

STATIC void
regread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg,*uid,*dirent;
     static char qtmp[PROSIZ+SUMSIZ+1];
     static struct regrec regrec;
     int stgnum,i,regkys=0;
     BOOL recxst,qryok;

     if (stdchk(regakey) && sameas(dpknam->usrid,usaptr->userid)) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sau:key")) {
               if (haskey(regakey)) {
                    regkys|=HASAKY;
               }
               if (haskey(regkey)) {
                    regkys|=HASCKY;
               }
               if (haskey(viewkey)) {
                    regkys|=HASVKY;
               }
               rsp2read(dpknam,sizeof(int),&regkys);
               return;
          }
          if (sameto("sau:inf ",dpkstg)) {
               if (direction == 0) {
                    stgnum=atoi(skpwrd(dpknam->suffix)+1);
                    if (stgnum >= 0 && rinfstgs[stgnum] != NULL) {
                         rsp2read(dpknam,STGLEN,rinfstgs[stgnum]);
                         return;
                    }
               }
          }
          if (sameto("sau:rgt",dpkstg)) {
               uid=skpwrd(dpknam->suffix)+1;
               if (haskey(viewkey)
                   || (sameto("sau:rgt ",dpkstg)
                    && sameas(usaptr->userid,uid))) {
                    setbtv(regbb);
                    recxst=FALSE;
                    if (sameto("sau:rgtp ",dpkstg)) {
                         recxst=altbtv(&regrec,uid,0);
                    }
                    else if (sameto("sau:rgt ",dpkstg)) {
                         recxst=acqbtv(&regrec,uid,0);
                    }
                    else if (sameto("sau:rgtn ",dpkstg)) {
                         recxst=agtbtv(&regrec,uid,0);
                    }
                    if (recxst) {
                         strcpy(rsptmp,spr("%s\t",regrec.userid));
                         for (i=0 ; i < numfds ; i++) {
                              stzcpy(qtmp,regrec.profil+reginf[i].ansidx,
                                     reginf[i].anssiz+1);
                              strcat(rsptmp,qtmp);
                              strcat(rsptmp,"\t");
                         }
                         strcat(rsptmp,regrec.sumlin);
                         rsp2read(dpknam,STGLEN,rsptmp);
                         return;
                    }
               }
          }
          if (sameto("sau:rqy",dpkstg)) {
               uid=skpwrd(dpknam->suffix)+1;
               if (haskey(viewkey)
                   || (sameto("sau:rqy ",dpkstg)
                    && sameas(usaptr->userid,uid))) {
                    setbtv(regbb);
                    qryok=TRUE;
                    if (sameto("sau:rqyp ",dpkstg)) {
                         recxst=qltbtv(uid,0);
                    }
                    else if (sameto("sau:rqy ",dpkstg)) {
                         recxst=qeqbtv(uid,0);
                    }
                    else if (sameto("sau:rqyn ",dpkstg)) {
                         recxst=qgtbtv(uid,0);
                    }
                    else {
                         qryok=FALSE;
                    }
                    if (qryok) {
                         rsp2read(dpknam,sizeof(int),&recxst);
                         return;
                    }
               }
          }
          if (sameto("sau:dir ",dpkstg)) {
               if (haskey(viewkey) && direction != 0) {
                    setbtv(regbb);
                    uid=skpwrd(dpknam->suffix)+1;
                    recxst=direction == 1 ? agtbtv(&regrec,uid,0)
                                          : altbtv(&regrec,uid,0);
                    if (recxst) {
                         dirent=spr("%s\t%s",regrec.userid,regrec.sumlin);
                         *namtmp=*dpknam;
                         stzcpy(namtmp->suffix,
                                spr("dir %s",regrec.userid),SFXSIZ);
                         rsp2read(namtmp,STGLEN,dirent);
                         return;
                    }
               }
          }
     }
     rejectreq();
}

STATIC void
regwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstg,*curfld;
     int maxlen,i;
     static struct regrec regrec;
     static char prostg[PROSIZ+SUMSIZ+1];
     BOOL recxst=FALSE;

     if (stdchk(regakey) && sameas(dpknam->usrid,usaptr->userid)) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sau:ent")) {
               if (haskey(regkey)) {
                    maxlen=numfds+SUMSIZ;
                    for (i=0 ; i < numfds ; maxlen+=reginf[i++].anssiz) {
                    }
                    if (length > 0 && length < maxlen) {
                         b2ccpy(prostg,(char *)value,length+1);
                         if (itemcntd(prostg,FLDSEP) == numfds+1) {
                              setmem(&regrec,sizeof(struct regrec),0);
                              stzcpy(regrec.userid,usaptr->userid,UIDSIZ);
                              setbtv(regbb);
                              if (acqbtv(&regrec,regrec.userid,0)) {
                                   recxst=TRUE;
                                   regrec.sumlin[0]='\0';
                                   setmem(regrec.profil,PROSIZ,0);
                              }
                              for (i=0 ; i < numfds ; i++) {
                                   curfld=itemidxd(prostg,i,FLDSEP);
                                   movmem(curfld,regrec.profil+reginf[i].ansidx,
                                          min(strlen(curfld),reginf[i].anssiz));
                              }
                              stzcpy(regrec.sumlin,itemidxd(prostg,i,FLDSEP),
                                     SUMSIZ);
                              if (recxst) {
                                   updbtv(&regrec);
                              }
                              else {
                                   insbtv(&regrec);
                              }
                              rsp2write(TRUE,0,NULL);
                              return;
                         }
                    }
               }
          }
     }
     rejectreq();
}

STATIC void
regxdone(void)                     /* file transfer-done handler           */
{
}

STATIC void
regabort(void)                     /* abort-request handler                */
{
}

