/***************************************************************************
 *                                                                         *
 *   CSEML.C                                                               *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Worldgroup Client/Server electronic mail service handler. *
 *                                                                         *
 *                                                - J. Alvrus  10/20/94    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "filexfer.h"
#include "gme.h"
#include "galmsg.h"
#include "emlfor.h"
#include "csef.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

#define SLFMTY  "sau:slfmty"       /* rd/wrt show Forum msgs in E-mail dpk */
#define SAFWDEE "sau:safwdee"      /* read/write auto-forwardee dpk name   */
#define CDETAIL "cdetail "         /* carrier detail dpk suffix            */
#define RDESFX  "rdeml "           /* get new E-mail dpk suffix            */
#define EMLATT  "emlatt "          /* get E-mail attachment dpk suffix     */
#define SLISFX  "slist "           /* sysop dist list suffix               */
#define ELISFX  "elist "           /* sysop dist list suffix (when editing)*/
#define CRLSFX  "crtlst "          /* create dist list suffix              */
#define ADLSFX  "addlst "          /* add to dist list suffix              */
#define FWDEML  "fwdeml "          /* forward a message suffix             */
#define CPYEML  "cpyeml "          /* copy a message suffix                */
#define BKTRACK "bktrack "         /* backtrack from message suffix        */

STATIC void eread(int direction,struct saunam *dpknam);
STATIC void ewrite(struct saunam *dpknam,unsigned length,void *value);
STATIC void exdone(void);
STATIC void eabort(void);

struct agent emlagt={              /* agent information structure          */
     "GALEML",                     /*   appid                              */
     eread,                        /*   read-dynapak function pointer      */
     ewrite,                       /*   write-dynapak function pointer     */
     exdone,                       /*   file xfer-done function pointer    */
     eabort                        /*   abort-request function pointer     */
};

struct newslst {                   /* create new sysop list dpk structure  */
     char key[KEYSIZ-1];           /*   key required to use list           */
     int surchg;                   /*   charge to use list                 */
};

STATIC char *csekey;               /* key required to use C/S E-mail agent */
STATIC char *annocmd;              /* cmd line for E-mail client announcmnt*/

STATIC void cseanno(void);
STATIC BOOL csemlcfl(void *work,unsigned forum,long msgid);
STATIC void emlacc(struct saunam *dpknam);
STATIC int emsgacc(void);
STATIC void cdetail(int direction,struct saunam *dpknam);
STATIC void fillcdet(struct cdetail *cdet,int expi,struct expinfo *exp);
STATIC void chk4new(struct saunam *dpknam);
STATIC void cfindnew(void);
STATIC void findnew(void);
STATIC void goread(int direction,struct saunam *dpknam);
STATIC void crsvrdbuf(void);
STATIC void rsvrdbuf(void);
STATIC void creademl(void);
STATIC void reademl(void);
STATIC void cmrkoff(void);
STATIC void mrkoff(void);
STATIC void emlatt(struct saunam *dpknam);
STATIC void bktrack(struct saunam *dpknam);
STATIC void crdbktk(void);
STATIC void rdbktk(void);
STATIC void slstinf(int direction, struct saunam *dpknam);
STATIC void elstinf(int direction, struct saunam *dpknam);
STATIC void glstfil(struct saunam *dpknam);
STATIC void crtslst(struct saunam *dpknam,unsigned length,struct newslst *value);
STATIC void adlst(struct saunam *dpknam,char *addr);
STATIC void fwdeml(struct saunam *dpknam,char *fwdinf);
STATIC void cpyeml(struct saunam *dpknam,char *cpyinf);

void
inicseml(void)                     /* initialize Client/Server E-mail agent*/
{
     register_agent(&emlagt);
     csekey=stgopt(CSEKEY);
     if (ynopt(CSANNO)) {
          annocmd=stgopt(ANNOCMD);
          hook_announce(cseanno);
          dclanno(sizeof(struct rqinfo));
     }
     setcfl(csemlcfl);
}

STATIC void
cseanno(void)                      /* new mail announcer                   */
{
     if (!haskey(csekey)) {
          addanno("");
          return;
     }
     rqiptr=(struct rqinfo *)annomem;
     efwork=rqiptr->u.work;
     msg=(struct message *)vdatmp;
     msgtxt=((char *)vdatmp)+sizeof(struct message);
     switch (rqiptr->stt) {
     case 0:
          inigmerq(efwork);
          inormrd(efwork,usaptr->userid,EMLID,firstnew(usaptr->userid,EMLID));
          rqiptr->stt=1;
     case 1:
          switch (nextmsg(efwork,msg,msgtxt)) {
          case GMEAGAIN:
               break;
          case GMEOK:
               clsgmerq(efwork);
               setmbk(efmb);
               addannom(getmsg(CSNEWEML),emlagt.appid,annocmd);
               break;
          default:
               clsgmerq(efwork);
               addanno("");
               break;
          }
     }
}

STATIC BOOL                        /*   returns TRUE if a conflict         */
csemlcfl(                          /* C/S E-mail conflict checker          */
void *work,                        /*   work area being used to read       */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid)                        /*   message ID w/possible conflict     */
{
     return(cscflchk(emlagt.appid,work,forum,msgid));
}

STATIC void
eread(                             /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstr;

     dpkstr=cnvs2d(dpknam);
     if (direction == 0 && sameas("sau:emlacc",dpkstr)) {
          if (stdchk(csekey)) {
               emlacc(dpknam);
          }
          else {
               setmem(rsptmp,sizeof(struct emlacc),0);
               rsp2read(dpknam,sizeof(struct emlacc),rsptmp);
          }
          return;
     }
     if (!stdchk(csekey)) {
          rejectreq();
          return;
     }
     cssetup();
     if (direction == 0 && sameto("sauf:",dpkstr)
      && sameto(EMLATT,dpknam->suffix)) {
          emlatt(dpknam);
     }
     else if (direction == 0 && sameto("saf:",dpkstr)
      && sameto(SLISFX,dpknam->suffix)) {
          glstfil(dpknam);
     }
     else if (sameto("sau:",dpkstr) && sameto(CDETAIL,dpknam->suffix)) {
          cdetail(direction,dpknam);
     }
     else if (direction == 0 && sameas("sau:qrynew",dpkstr)) {
          chk4new(dpknam);
     }
     else if (direction == 0 && sameas(SLFMTY,dpkstr)) {
          *(int *)rsptmp=qsptr->flags&FORUM2 ? VBTRUE : FALSE;
          rsp2read(dpknam,sizeof(int),rsptmp);
     }
     else if (direction == 0 && sameas(SAFWDEE,dpkstr)) {
          rsp2read(dpknam,strlen(qsptr->fwdee),qsptr->fwdee);
     }
     else if (sameto("sau:",dpkstr) && sameto(RDESFX,dpknam->suffix)) {
          goread(direction,dpknam);
     }
     else if (direction == 0 && sameto("sau:",dpkstr)
      && sameto(BKTRACK,dpknam->suffix)) {
          bktrack(dpknam);
     }
     else if (direction >= 0 && sameto("sa:",dpkstr)
      && sameto(SLISFX,dpknam->suffix)) {
          slstinf(direction,dpknam);
     }
     else if (direction >= 0 && sameto("sa:",dpkstr)
      && sameto(ELISFX,dpknam->suffix)) {
          elstinf(direction,dpknam);
     }
     else {
          rejectreq();
     }
}

STATIC void
ewrite(                            /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     int tmpint;
     char *dpkstr;

     dpkstr=cnvs2d(dpknam);
     if (!stdchk(csekey)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     cssetup();
     if (length > 0 && sameto("saf:",dpkstr)
      && sameto(UPLATT,dpknam->suffix)) {
          ASSERT(length == sizeof(struct filinf));
          uplatt(dpknam,(struct filinf *)value);
     }
     else if (sameto("sa:",dpkstr) && sameto(CRLSFX,dpknam->suffix)) {
          crtslst(dpknam,length,(struct newslst *)value);
     }
     else if (length == sizeof(int) && sameas(SLFMTY,dpkstr)) {
          if (*(int *)value) {
               qsptr->flags|=FORUM2;
          }
          else {
               qsptr->flags&=~FORUM2;
          }
          rsp2write(TRUE,0,NULL);
     }
     else if (sameas(SAFWDEE,dpkstr)) {
          tmpint=setafwd(unpad((char *)value));
          rsp2write(tmpint == VALYES,sizeof(int),&tmpint);
     }
     else if (sameto("sa:",dpkstr) && sameto(ADLSFX,dpknam->suffix)) {
          adlst(dpknam,unpad((char *)value));
     }
     else if (length >= sizeof(struct newdpk)-1 && sameto("sa:",dpkstr)
      && sameas(WRTNEW,dpknam->suffix)) {
          wrtnew(dpknam,(struct newdpk *)value);
     }
     else if (length >= sizeof(struct newdpk)-1 && sameto("sa:",dpkstr)
      && sameas(WRTRPL,dpknam->suffix)) {
          wrtrpl(dpknam,(struct newdpk *)value);
     }
     else if (sameto("sa:",dpkstr) && sameto(CCLSFX,dpknam->suffix)) {
          gcclst(dpknam,unpad((char *)value));
     }
     else if (sameto("sa:",dpkstr) && sameto(FWDEML,dpknam->suffix)) {
          fwdeml(dpknam,unpad((char *)value));
     }
     else if (sameto("sa:",dpkstr) && sameto(CPYEML,dpknam->suffix)) {
          cpyeml(dpknam,unpad((char *)value));
     }
     else {
          rsp2write(FALSE,0,NULL);
     }
}

STATIC void
exdone(void)                       /* file transfer-done handler           */
{
     cssetup();
     if (iswrite()) {
          if (sameto(UPLATT,rqiptr->dpknam.suffix)) {
               uladone();
          }
     }
     else {
          if (sameto(EMLATT,rqiptr->dpknam.suffix)) {
               dldone(rqiptr->u.tag);
          }
     }
}

STATIC void
eabort(void)                       /* abort-request handler                */
{
     cssetup();
     if (sameto(EMLATT,rqiptr->dpknam.suffix)) {
          if (rqiptr->stt == 0) {
               clsgmerq(efwork);
          }
          else {
               dlabt(rqiptr->u.tag);
          }
     }
     else if (sameas(WRTNEW,rqiptr->dpknam.suffix)
           || sameas(WRTRPL,rqiptr->dpknam.suffix)) {
          wrtabt();
     }
     else if (sameto(UPLATT,rqiptr->dpknam.suffix)) {
          uplabt();
     }
     else {
          if (gmerqopn(efwork)) {
               clsgmerq(efwork);
          }
          if (rqiptr->flags&BUFINU) {
               unrarea(wrmpool,rqiptr->wrthdl);
          }
     }
}

STATIC void
emlacc(                            /* get user's E-mail access             */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     int tmpint;

     tmpint=emsgacc();
     if (haskey(massky)) {
          tmpint|=EAMSLST;
     }
     if (haskey(edstky)) {
          tmpint|=EAEDLST;
     }
     ((struct emlacc *)rsptmp)->flags=tmpint;
     if (alwcpy) {
          ((struct emlacc *)rsptmp)->ccmax=usrptr->flags&MASTER ? -1 : csmaxcc;
     }
     else {
          ((struct emlacc *)rsptmp)->ccmax=0;
     }
     ((struct emlacc *)rsptmp)->txtlen=(long)(TXTLEN-1);
     rsp2read(dpknam,sizeof(struct emlacc),rsptmp);
}

STATIC int
emsgacc(void)                      /* form E-mail per-message access flags */
{
     int tmpint;

     tmpint=haskey(emlkey) ? EAWRITE : 0;
     if (alweat && haskey(eatkey)) {
          tmpint|=EAATTACH;
     }
     if (alwrrr && haskey(rrrkey)) {
          tmpint|=EARECREQ;
     }
     if (alwpri && haskey(prikey)) {
          tmpint|=EAPRIMSG;
     }
     if (haskey(fprlock)) {
          tmpint|=EAINDATT;
     }
     return(tmpint);
}

STATIC void
cdetail(                           /* get details on carrier               */
int direction,                     /*   direction for read                 */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     int i,n;
     char *cp,tmppfx[PFXSIZ];
     struct expinfo *exp;

     n=numexp();
     if (n == 0) {
          rejectreq();
          return;
     }
     if (direction == 0) {
          i=expidx(&dpknam->suffix[sizeof(CDETAIL)-1]);
          if (i == NOIDX) {
               rejectreq();
               return;
          }
          exp=expinf(i);
          if (haskey(exp->wrtkey)) {
               fillcdet((struct cdetail *)rsptmp,i,exp);
               rsp2read(dpknam,sizeof(struct cdetail)-1
                              +strlen(((struct cdetail *)rsptmp)->info),rsptmp);
          }
          else {
               rejectreq();
          }
     }
     else if (direction > 0) {
          i=0;
          stlcpy(tmppfx,&dpknam->suffix[sizeof(CDETAIL)-1],PFXSIZ);
          cp=strchr(tmppfx,':');
          if (cp != NULL) {
               *cp='\0';
          }
          while (i < n && stricmp(expinf(i)->prefix,tmppfx) <= 0) {
               ++i;
          }
          while (i < n && !haskey((exp=expinf(i))->wrtkey)) {
               ++i;
          }
          if (i < n) {
               fillcdet((struct cdetail *)rsptmp,i,exp);
               *namtmp=*dpknam;
               stlcpy(namtmp->suffix,CDETAIL,SFXSIZ);
               stlcat(namtmp->suffix,exp->prefix,SFXSIZ);
               stlcat(namtmp->suffix,":",SFXSIZ);
               rsp2read(namtmp,sizeof(struct cdetail)-1
                              +strlen(((struct cdetail *)rsptmp)->info),rsptmp);
          }
          else {
               rejectreq();
          }
     }
     else if (direction < 0) {
          i=n-1;
          stlcpy(tmppfx,&dpknam->suffix[sizeof(CDETAIL)-1],PFXSIZ);
          cp=strchr(tmppfx,':');
          if (cp != NULL) {
               *cp='\0';
          }
          while (i >= 0 && stricmp(expinf(i)->prefix,tmppfx) >= 0) {
               --i;
          }
          while (i >= 0 && !haskey((exp=expinf(i))->wrtkey)) {
               --i;
          }
          if (i >= 0) {
               fillcdet((struct cdetail *)rsptmp,i,exp);
               *namtmp=*dpknam;
               stlcpy(namtmp->suffix,CDETAIL,SFXSIZ);
               stlcat(namtmp->suffix,exp->prefix,SFXSIZ);
               stlcat(namtmp->suffix,":",SFXSIZ);
               rsp2read(namtmp,sizeof(struct cdetail)-1
                              +strlen(((struct cdetail *)rsptmp)->info),rsptmp);
          }
          else {
               rejectreq();
          }
     }
}

STATIC void
fillcdet(                          /* fill in carrier details structure    */
struct cdetail *cdet,              /*   details buffer                     */
int expi,                          /*   exporter index                     */
struct expinfo *exp)               /*   exporter info structure            */
{
     char *cp;

     c2bcpy(cdet->prefix,exp->prefix,PFXSIZ-1);
     c2bcpy(cdet->name,exp->name,EXPNSZ-1);
     cdet->flags=0;
     if ((exp->flags&EXPATT) && haskey(exp->attkey)) {
          cdet->flags|=EAATTACH;
     }
     if ((exp->flags&EXPRRR) && haskey(exp->rrrkey)) {
          cdet->flags|=EARECREQ;
     }
     if ((exp->flags&EXPPRI) && haskey(exp->prikey)) {
          cdet->flags|=EAPRIMSG;
     }
     cp=stlcpy(cdet->info,exp->desc,EXPDSZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,exp->exmp,MAXADR);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,exphlp(expi),MAXDPKV-sizeof(struct cdetail)-strlen(cdet->info));
     stp4cs(cp);
}

STATIC void
chk4new(                           /* check for new E-mail                 */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,EMLID,firstnew(usaptr->userid,EMLID));
     movmem(dpknam,&rqiptr->dpknam,sizeof(struct saunam));
     findnew();
}

STATIC void
cfindnew(void)                     /* cycled checking for new mail         */
{
     cssetup();
     findnew();
}

STATIC void
findnew(void)                      /* checking for new mail                */
{
     msg=(struct message *)vdatmp;
     msgtxt=((char *)vdatmp)+sizeof(struct message);
     switch (nextmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(cfindnew);
          break;
     case GMEOK:
          clsgmerq(efwork);
          rsp2read(&rqiptr->dpknam,sizeof(long),&msg->msgid);
          break;
     default:
          clsgmerq(efwork);
          rejectreq();
          break;
     }
}

STATIC void
goread(                            /* read E-mail handler                  */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name in use                */
{
     long msgid;

     if (!lsfxval((unsigned long *)&msgid,&dpknam->suffix[sizeof(RDESFX)-1])) {
          rejectreq();
          return;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,EMLID,msgid);
     rqiptr->stt=(signed char)direction;
     rqiptr->dpknam=*dpknam;
     rsvrdbuf();
}

STATIC void
crsvrdbuf(void)                    /* cycled reserve buffer for read       */
{
     cssetup();
     cycleme(NULL);
     rsvrdbuf();
}

STATIC void
rsvrdbuf(void)                     /* reserve pool buffer for read         */
{
     rqiptr->wrthdl=rsvarea(wrmpool);
     if (rqiptr->wrthdl == NOHDL) {
          cycleme(crsvrdbuf);
     }
     else {
          rqiptr->flags|=BUFINU;
          cswrtup();
          reademl();
     }
}

STATIC void
creademl(void)                     /* cycled read E-mail message           */
{
     cssetup();
     cswrtup();
     cycleme(NULL);
     reademl();
}

STATIC void
reademl(void)                      /* read E-mail message                  */
{
     switch (readir(rqiptr->stt,efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(creademl);
          break;
     case GMEOK:
          rqiptr->flags|=(unsigned char)(msg->flags&RECREQ);
          mrkoff();
          break;
     default:
          clsgmerq(efwork);
          unrarea(wrmpool,rqiptr->wrthdl);
          rejectreq();
          break;
     }
}

STATIC void
cmrkoff(void)                      /* cycled mark-message-read process     */
{
     cssetup();
     cswrtup();
     cycleme(NULL);
     mrkoff();
}

STATIC void
mrkoff(void)                       /* mark message read function           */
{
     int rc;

     cssetup();
     switch (rc=markread(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(cmrkoff);
          return;
     case GMEAFWD:
     case GMERRG:
     case GMEOK:
          switch (rc) {
          case GMEAFWD:
               rrgnot(gmexinf());
               break;
          case GMERRG:
               rrgnot(msg->from);
               break;
          }
          if (rqiptr->stt != 0) {
               stlcpy(rqiptr->dpknam.suffix,RDESFX,SFXSIZ);
               stlcat(rqiptr->dpknam.suffix,longstr(msg->msgid),
                      SFXSIZ);
          }
          msg->flags|=(rqiptr->flags&(unsigned char)RECREQ);
          msg2dpk(msg,msgtxt,(struct msgdpk *)rsptmp,TRUE);
          if (msg->forum == EMLID) {
               ((struct msgdpk *)rsptmp)->axes=(char)emsgacc();
          }
          else {
               ((struct msgdpk *)rsptmp)->axes=(char)foracc(msg->forum);
          }
          rsp2read(&rqiptr->dpknam,
                 sizeof(struct msgdpk)+strlen(((struct msgdpk *)rsptmp)->info),
                 rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
     unrarea(wrmpool,rqiptr->wrthdl);
}

STATIC void
emlatt(                            /* get attachment to E-mail message     */
struct saunam *dpknam)             /*   dynapak name in use                */
{
     long msgid;

     if (!lsfxval((unsigned long *)&msgid,&dpknam->suffix[sizeof(EMLATT)-1])) {
          rejectreq();
          return;
     }
     rqiptr->stt=0;
     rqiptr->dpknam=*dpknam;
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,EMLID,msgid);
     rd4att();
}

STATIC void
bktrack(                           /* backtrack from E-mail message        */
struct saunam *dpknam)             /*   dpk name in use                    */
{
     long msgid;

     if (!lsfxval((unsigned long *)&msgid,&dpknam->suffix[sizeof(BKTRACK)-1])) {
          rejectreq();
          return;
     }
     rqiptr->dpknam=*dpknam;
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,EMLID,msgid);
     rdbktk();
}

STATIC void
crdbktk(void)                      /* cycled backtrack                     */
{
     cssetup();
     rdbktk();
}

STATIC void
rdbktk(void)                       /* backtrack from message               */
{
     switch (*(int *)rsptmp=readpar(efwork,(struct message *)vdatmp,
                                    ((char *)vdatmp)+sizeof(struct message))) {
     case GMEAGAIN:
          cycleme(crdbktk);
          break;
     case GMEOK:
          if (markread(efwork,(struct message *)vdatmp,
                       ((char *)vdatmp)+sizeof(struct message)) != GMEOK) {
               clsgmerq(efwork);
               rejectreq();
               return;
          }
          msg2dpk((struct message *)vdatmp,
                  ((char *)vdatmp)+sizeof(struct message),
                  (struct msgdpk *)rsptmp,TRUE);
          rsp2read(&rqiptr->dpknam,
                 sizeof(struct msgdpk)+strlen(((struct msgdpk *)rsptmp)->info),
                 rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC void
slstinf(                           /* get sysop list info                  */
int direction,                     /*   direction of read (0 or 1)         */
struct saunam *dpknam)             /*   dpk name in use                    */
{
     char *cp;
     char tmpkey[KEYSIZ];

     ASSERT(sameto(SLISFX,dpknam->suffix));
     switch (direction) {
     case 0:
          cp=dpknam->suffix+sizeof(SLISFX)-1;
          if (dlstxst(cp)) {
               getslst(cp,tmpkey,(int *)rsptmp);
               if (haskey(tmpkey)) {
                    rsp2read(dpknam,sizeof(int),rsptmp);
                    return;
               }
          }
          break;
     case 1:
          movmem(dpknam,&rqiptr->dpknam,sizeof(struct saunam));
          cp=rqiptr->dpknam.suffix+sizeof(SLISFX)-1;
          while (nxtslst(cp,tmpkey,(int *)rsptmp) == GMEOK) {
               if (haskey(tmpkey)) {
                    rsp2read(&rqiptr->dpknam,sizeof(int),rsptmp);
                    return;
               }
          }
          break;
     default:
          ASSERT(FALSE);
     }
     rejectreq();
}

STATIC void
elstinf(                           /* get sysop list info (when editing)   */
int direction,                     /*   direction of read (0 or 1)         */
struct saunam *dpknam)             /*   dpk name in use                    */
{
     int tmpchg;
     char *cp;
     char tmpkey[KEYSIZ];

     ASSERT(sameto(ELISFX,dpknam->suffix));
     if (haskey(edstky)) {
          switch (direction) {
          case 0:
               cp=dpknam->suffix+sizeof(ELISFX)-1;
               if (dlstxst(cp)) {
                    getslst(cp,tmpkey,&tmpchg);
                    c2bcpy(((struct newslst *)rsptmp)->key,tmpkey,KEYSIZ-1);
                    ((struct newslst *)rsptmp)->surchg=tmpchg;
                    rsp2read(dpknam,sizeof(int),rsptmp);
                    return;
               }
               break;
          case 1:
               movmem(dpknam,&rqiptr->dpknam,sizeof(struct saunam));
               cp=rqiptr->dpknam.suffix+sizeof(ELISFX)-1;
               if (nxtslst(cp,tmpkey,&tmpchg) == GMEOK) {
                    c2bcpy(((struct newslst *)rsptmp)->key,tmpkey,KEYSIZ-1);
                    ((struct newslst *)rsptmp)->surchg=tmpchg;
                    rsp2read(&rqiptr->dpknam,sizeof(struct newslst),rsptmp);
                    return;
               }
               break;
          default:
               ASSERT(FALSE);
          }
     }
     rejectreq();
}

STATIC void
glstfil(                           /* get sysop list file                  */
struct saunam *dpknam)             /*   dpk name in use                    */
{
     char *cp;

     ASSERT(sameto(SLISFX,dpknam->suffix));
     cp=dpknam->suffix+sizeof(SLISFX)-1;
     if (slstfil(cp,(char *)rsptmp) == GMEOK) {
          rsp2read(dpknam,STGLEN,rsptmp);
          return;
     }
     rejectreq();
}

STATIC void
crtslst(                           /* create new sysop distribution list   */
struct saunam *dpknam,             /*   dpk name in use                    */
unsigned length,                   /*   length of dynapak                  */
struct newslst *newlst)            /*   new list structure                 */
{
     int rc;
     char *cp;
     char tmpkey[KEYSIZ];

     if (length != sizeof(struct newslst)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     cp=dpknam->suffix+sizeof(CRLSFX)-1;
     b2ccpy(tmpkey,newlst->key,KEYSIZ-1);
     rc=newslst(efwork,cp,tmpkey,newlst->surchg);
     if (rc == GMEOK) {
          clsgmerq(efwork);
     }
     rsp2write(rc == GMEOK,sizeof(int),&rc);
}

STATIC void
adlst(                             /* add an entry to a server-side list   */
struct saunam *dpknam,             /*   dynapak name in use                */
char *addr)                        /*   address to add                     */
{
     int rc;
     char *cp;

     inigmerq(efwork);
     cp=dpknam->suffix+sizeof(ADLSFX)-1;
     rc=edtslst(efwork,cp);
     if (rc == GMEOK) {
          rc=addslst(efwork,addr);
          if (rc == GMEOK) {
               clsgmerq(efwork);
          }
     }
     rsp2write(rc == GMEOK,sizeof(int),&rc);
}

STATIC void
fwdeml(                            /* forward an E-mail message            */
struct saunam *dpknam,             /*   dynapak name in use                */
char *fwdinf)                      /*   address to fwd to/comments         */
{
     long msgid;

     if (!lsfxval((unsigned long *)&msgid,&dpknam->suffix[sizeof(FWDEML)-1])) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,EMLID,msgid);
     csfwd(dpknam,fwdinf);
}

STATIC void
cpyeml(                            /* copy an E-mail message               */
struct saunam *dpknam,             /*   dynapak name in use                */
char *cpyinf)                      /*   address to copy to/comments        */
{
     long msgid;

     if (!lsfxval((unsigned long *)&msgid,&dpknam->suffix[sizeof(CPYEML)-1])) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,EMLID,msgid);
     cscopy(dpknam,cpyinf);
}

