/***************************************************************************
 *                                                                         *
 *   CSEFU.C                                                               *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Client/Server E-mail and Forums utilities and common functions.       *
 *                                                                         *
 *                                                - J. Alvrus 10/20/94     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "gme.h"
#include "filexfer.h"
#include "datutils.h"
#include "galmsg.h"
#include "emlfor.h"
#include "csef.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

int wrmpool,                       /* E-mail/Forums write msg pool handle  */
    csmaxcc;                       /* max # cc:s for C/S users             */

struct rqinfo *rqiptr;             /* E-mail/Forums per-request memory     */
struct wrtbuf *wrtbuf;             /* current message writing buffer       */

STATIC void csefcon(void);
STATIC void csefdisc(void);
STATIC BOOL rsvwrtb(void);
STATIC void dowrite(BOOL isreply);
STATIC BOOL pfnerr(char *str,unsigned forum);
STATIC void rejwrt(struct wrterr *err);
STATIC void startsnd(void);
STATIC void cswrtcbk(int evt,int rc);
STATIC void csndnew(void);
STATIC void sndnew(void);
STATIC void csndrpl(void);
STATIC void sndrpl(void);
STATIC BOOL ndpk2msg(struct newdpk *new,struct message *msg,char *text,
                     char *filatt);
STATIC void crd4fwd(void);
STATIC void rd4fwd(void);
STATIC void ccsfwdit(void);
STATIC void csfwdit(void);
STATIC void crd4cpy(void);
STATIC void rd4cpy(void);
STATIC void ccscpyit(void);
STATIC void cscpyit(void);
STATIC void rejcfwd(long rc);
STATIC char *addcmt(char *txt,char *cmt,char *buf);

void
inics(void)                        /* initialize Client/Server stuff       */
{
     unsigned wrmsiz;

     dclmrq(sizeof(struct rqinfo));
     dclvda(sizeof(struct message)+txtlen());
     csmaxcc=numopt(CSMAXCC,0,32767);
     hook_connect(csefcon);
     hook_disconnect(csefdisc);
     wrmsiz=sizeof(struct wrtbuf)+txtlen()-1;
     wrmsiz=max(wrmsiz,sizeof(struct fordsk)+MAXFDV);
     wrmpool=newpool(wrmsiz,2*nterms,nterms/numopt(CHNPBUF,1,256)+1);
     inicseml();
     inicsfor();
}

void
cssetup(void)                      /* set up stuff for C/S E-mail/Forums   */
{
     setmbk(efmb);
     rqiptr=(struct rqinfo *)mrqptr;
     efwork=rqiptr->u.work;
     qsptr=myqsptr();
}

void
efcurreq(                          /* set current request for E-mail/Forums*/
int reqid)                         /*   request ID to set to               */
{
     curreq(reqid);
     cssetup();
}

STATIC void
csefcon(void)                      /* C/S E-mail/Forums connect handler    */
{
     struct qscfg *qsc;

     qsc=myqsptr();
     if (!sameas(qsc->userid,usaptr->userid)) {
          inigmeu();
     }
     if (qsc->flags&CLARPL) {
          peruflg[usrnum]|=CARSAV;
          qsc->flags&=~CLARPL;
     }
     else {
          peruflg[usrnum]&=~CARSAV;
     }
}

STATIC void
csefdisc(void)                     /* C/S E-mail/Forums disconnect handler */
{
     if (!sameas(myqsptr()->userid,usaptr->userid)) {
          inigmeu();
     }
     if (peruflg[usrnum]&CARSAV) {
          myqsptr()->flags|=CLARPL;
     }
     clsgmeu();
     peruflg[usrnum]=0;
     if (usrscn[usrnum] != NULL) {
          unrscan(usrnum);
          usrscn[usrnum]=NULL;
     }
}

BOOL                               /*   returns TRUE if a conflict         */
cscflchk(                          /* C/S conflict checker                 */
char *appid,                       /*   app ID to check for                */
void *work,                        /*   work area being used to read       */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid)                        /*   message ID w/possible conflict     */
{
     int i,ncsreqs;
     struct rqinfo *tmprqi;
     struct wrtbuf *tmpwrt;

     ncsreqs=nterms*MAXREQS;
     if (msgid == 0L) {
          for (i=0 ; i < ncsreqs; ++i) {
               if (ismyreq(i,appid)) {
                    tmprqi=(struct rqinfo *)mrqoff(i);
                    if (work != &tmprqi->u.work) {
                         if (sameas(tmprqi->dpknam.suffix,WRTNEW)
                          || sameas(tmprqi->dpknam.suffix,WRTRPL)) {
                              tmpwrt=areaptr(wrmpool,tmprqi->wrthdl);
                              if (tmpwrt->msg.forum == forum) {
                                   return(TRUE);
                              }
                         }
                         else if (gmerqopn(&tmprqi->u.work)) {
                              if (chkmycfl(&tmprqi->u.work,forum,msgid)) {
                                   return(TRUE);
                              }
                         }
                    }
               }
          }
          return(FALSE);
     }
     for (i=0 ; i < ncsreqs ; ++i) {
          if (ismyreq(i,appid)) {
               tmprqi=(struct rqinfo *)mrqoff(i);
               if (work != &tmprqi->u.work && gmerqopn(&tmprqi->u.work)) {
                    if (chkmycfl(&tmprqi->u.work,forum,msgid)) {
                         return(TRUE);
                    }
               }
          }
     }
     return(FALSE);
}

void
crd4att(void)                      /* cycled read message for att dl       */
{
     cssetup();
     rd4att();
}

void
rd4att(void)                       /* read message in prep for att dl      */
{
     char tmptag[TSLENG];

     msg=(struct message *)vdatmp;
     switch (readmsg(efwork,msg,(char *)rsptmp)) {
     case GMEAGAIN:
          cycleme(crd4att);
          return;
     case GMEOK:
          rqiptr->stt=1;
          if (tagatt(efwork,msg,tmptag) == GMEOK) {
               clsgmerq(efwork);
               movmem(tmptag,rqiptr->u.tag,TSLENG);
               stlcpy((char *)rsptmp,dlname(msg),MAXPATH);
               strcat((char *)rsptmp,";");
               stlcat((char *)rsptmp,msg->attname,MAXPATH+FLNSIZ);
               if (dlstart(rqiptr->u.tag)) {
                    rsp2read(&rqiptr->dpknam,STGLEN,rsptmp);
                    return;
               }
          }
          else {
               clsgmerq(efwork);
          }
          break;
     default:
          clsgmerq(efwork);
          break;
     }
     rejectreq();
}

void
wrtrpl(                            /* C/S write new message handler        */
struct saunam *dpknam,             /*   dynapak name in use                */
struct newdpk *new)                /*   dynapak contents                   */
{
     int rc,pflvl;
     struct message *tmpmsg;

     if (rsvwrtb()) {
          if (!ndpk2msg(new,msg,msgtxt,filatt)) {
               peruflg[usrnum]&=~WRTIPG;
               unrarea(wrmpool,rqiptr->wrthdl);
               rsp2write(FALSE,0,NULL);
               return;
          }
          rqiptr->dpknam=*dpknam;
          inigmerq(efwork);
          inormrd(efwork,usaptr->userid,new->orgfor,new->msgid);
          tmpmsg=(struct message *)vdatmp;
          rc=readmsg(efwork,tmpmsg,(char *)vdatmp+sizeof(struct message));
          ASSERT(rc != GMEAGAIN);
          if (rc == GMEOK) {
               msg->gmid=tmpmsg->gmid;
               msg->thrid=tmpmsg->thrid;
               stlcpy(msg->history,tmpmsg->history,HSTSIZ);
               if (msg->forum == EMLID) {
                    stlcpy(msg->to,tmpmsg->from,MAXADR);
               }
               else if (!sameas(tmpmsg->from,msg->to)) {
                    pflvl=getdefp(msg->forum)->pfnlvl;
                    if (pflvl == DFTPFN) {
                         pflvl=pfceil;
                    }
                    if (!haskey(syskey) && profan(msg->to) > 3-pflvl) {
                         ((struct wrterr *)rsptmp)->flags=ADDRESS;
                         ((struct wrterr *)rsptmp)->rc=PFNERR;
                         rejwrt((struct wrterr *)rsptmp);
                         return;
                    }
               }
          }
          dowrite(TRUE);
     }
}

void
wrtnew(                            /* C/S write new message handler        */
struct saunam *dpknam,             /*   dynapak name in use                */
struct newdpk *new)                /*   dynapak contents                   */
{
     if (rsvwrtb()) {
          if (!ndpk2msg(new,msg,msgtxt,filatt)) {
               peruflg[usrnum]&=~WRTIPG;
               unrarea(wrmpool,rqiptr->wrthdl);
               rsp2write(FALSE,0,NULL);
               return;
          }
          rqiptr->dpknam=*dpknam;
          inigmerq(efwork);
          dowrite(FALSE);
     }
}

STATIC BOOL                        /*   returns TRUE if able to reserve buf*/
rsvwrtb(void)                      /* reserve a write buffer               */
{
     if (peruflg[usrnum]&WRTIPG) {
          ((struct wrterr *)rsptmp)->flags=0;
          ((struct wrterr *)rsptmp)->rc=WRTBUSY;
          rsp2write(FALSE,sizeof(struct wrterr),rsptmp);
          return(FALSE);
     }
     rqiptr->wrthdl=rsvarea(wrmpool);
     if (rqiptr->wrthdl == NOHDL) {
          ((struct wrterr *)rsptmp)->flags=0;
          ((struct wrterr *)rsptmp)->rc=WRTBUSY;
          rsp2write(FALSE,sizeof(struct wrterr),rsptmp);
          return(FALSE);
     }
     rqiptr->flags|=BUFINU;
     cswrtup();
     peruflg[usrnum]|=WRTIPG;
     return(TRUE);
}

STATIC void
dowrite(                           /* C/S write a message handler          */
BOOL isreply)                      /*   is this message a reply            */
{
     if (isreply) {
          rqiptr->flags|=ISREPLY;
     }
     ((struct wrterr *)rsptmp)->rc=PFNERR;
     if (pfnerr(msg->topic,msg->forum) || pfnerr(msgtxt,msg->forum)) {
          ((struct wrterr *)rsptmp)->flags=THEMSG;
          rejwrt((struct wrterr *)rsptmp);
          return;
     }
     if ((msg->flags&FILATT) && pfnerr(msg->attname,msg->forum)) {
          ((struct wrterr *)rsptmp)->flags=(int)FILATT;
          rejwrt((struct wrterr *)rsptmp);
          return;
     }
     if ((msg->flags&FILATT) && !valfnm(msg->attname)) {
          ((struct wrterr *)rsptmp)->rc=GMEERR;
          ((struct wrterr *)rsptmp)->flags=(int)FILATT;
          rejwrt((struct wrterr *)rsptmp);
          return;
     }
     wrtbuf->cclist=NULL;
     if (msg->flags&CCEXP) {
          if (msg->forum != EMLID || !alwcpy
           || (csmaxcc == 0 && !(usrptr->flags&MASTER))) {
               ((struct wrterr *)rsptmp)->flags=CCOPY;
               ((struct wrterr *)rsptmp)->rc=GMEERR;
               rejwrt((struct wrterr *)rsptmp);
               return;
          }
     }
     if ((unsigned)msg->forum != EMLID) {
          ((struct wrterr *)rsptmp)->flags=FORUM;
          if (!fidxst((unsigned)msg->forum)) {
               ((struct wrterr *)rsptmp)->rc=GMENFND;
               rejwrt((struct wrterr *)rsptmp);
               return;
          }
          if (foracc((unsigned)msg->forum) < WRAXES) {
               ((struct wrterr *)rsptmp)->rc=GMEACC;
               rejwrt((struct wrterr *)rsptmp);
               return;
          }
     }
     stlcpy(msg->from,usaptr->userid,MAXADR);
     ((struct wrterr *)rsptmp)->rc=val2gme(valadr(efwork,msg->from,msg->to,
                                                  msg->forum));
     if (((struct wrterr *)rsptmp)->rc != GMEOK) {
          ((struct wrterr *)rsptmp)->flags=ADDRESS;
          rejwrt((struct wrterr *)rsptmp);
          return;
     }
     if (msg->flags&FILATT) {
          if (msg->flags&FILIND) {
               ((struct wrterr *)rsptmp)->flags=(int)FILIND;
               if (!haskey(fprlock)) {
                    ((struct wrterr *)rsptmp)->rc=GMEACC;
                    rejwrt((struct wrterr *)rsptmp);
                    return;
               }
               if (!fexist(filatt)) {
                    ((struct wrterr *)rsptmp)->rc=GMEIVA;
                    rejwrt((struct wrterr *)rsptmp);
                    return;
               }
          }
          else {
               stlcpy(filatt,ulname(msg),MAXPATH);
          }
          ((struct wrterr *)rsptmp)->rc=val2gme(valatt(efwork,msg->from,
                                                       msg->to,msg->forum));
          if (((struct wrterr *)rsptmp)->rc != GMEOK) {
               ((struct wrterr *)rsptmp)->flags=(int)FILATT;
               rejwrt((struct wrterr *)rsptmp);
               return;
          }
     }
     if (msg->flags&RECREQ) {
          ((struct wrterr *)rsptmp)->rc=val2gme(valrrr(efwork,msg->from,
                                                       msg->to,msg->forum));
          if (((struct wrterr *)rsptmp)->rc != GMEOK) {
               ((struct wrterr *)rsptmp)->flags=(int)RECREQ;
               rejwrt((struct wrterr *)rsptmp);
               return;
          }
     }
     if (msg->flags&PRIMSG) {
          ((struct wrterr *)rsptmp)->rc=val2gme(valpri(efwork,msg->from,
                                                       msg->to,msg->forum));
          if (((struct wrterr *)rsptmp)->rc != GMEOK) {
               ((struct wrterr *)rsptmp)->flags=(int)PRIMSG;
               rejwrt((struct wrterr *)rsptmp);
               return;
          }
     }
     if (msg->flags&CCEXP) {
          rqiptr->stt=WAIT4CC;
          return;
     }
     if ((msg->flags&FILATT) && !(msg->flags&FILIND)) {
          rqiptr->stt=WAIT4ATT;
          return;
     }
     startsnd();
}

STATIC BOOL
pfnerr(                            /* is string too profane?               */
char *str,                         /*   string to check                    */
unsigned forum)                    /*   forum to use for profanity level   */
{
     int maxpfn;

     if (haskey(syskey)) {
          return(FALSE);
     }
     if (forum == EMLID) {
          maxpfn=3-pfceil;
     }
     else {
          maxpfn=getdefp(forum)->pfnlvl;
          if (maxpfn == DFTPFN) {
               maxpfn=3-pfceil;
          }
          else {
               maxpfn=3-maxpfn;
          }
     }
     return(profan(str) > maxpfn);
}

STATIC void
rejwrt(                            /* reject write request with error code */
struct wrterr *err)                /*   error structure to return          */
{
     peruflg[usrnum]&=~WRTIPG;
     unrarea(wrmpool,rqiptr->wrthdl);
     clsgmerq(efwork);
     rsp2write(FALSE,sizeof(struct wrterr),err);
}

void
gcclst(                            /* got cc: list for message             */
struct saunam *dpknam,             /*   dynapak name in use                */
char *cclist)                      /*   ';'-deliminated list of cc:s       */
{
     int ncc,tmprq,othrq;
     char *cp;
     struct wrterr err;
     struct rqinfo *tmprqi;

     ASSERT(sameto(CCLSFX,dpknam->suffix));
     tmprq=s2rq(&dpknam->suffix[sizeof(CCLSFX)-1]);
     if (tmprq >= 0) {
          othrq=srvrqid(usrnum,tmprq);
          if (ismyreq(othrq,dpknam->appid)) {
               tmprqi=(struct rqinfo *)mrqoff(othrq);
               if (sameas(tmprqi->dpknam.suffix,WRTNEW)
                || sameas(tmprqi->dpknam.suffix,WRTRPL)) {
                    if (tmprqi->stt == WAIT4CC) {
                         if (*cclist != '\0' && !(usrptr->flags&MASTER)) {
                              ncc=0;
                              cp=cclist;
                              while (ncc < csmaxcc && cp != NULL) {
                                   cp=strchr(cp+1,';');
                                   ++ncc;
                              }
                              if (cp != NULL) {
                                   *cp='\0';
                              }
                         }
                         cp=malloc(strlen(cclist)+1);
                         if (cp == NULL) {
                              err.flags=CCOPY;
                              err.rc=GMEMEM;
                              rsp2write(FALSE,sizeof(struct wrterr),&err);
                              return;
                         }
                         strcpy(cp,cclist);
                         rsp2write(TRUE,0,NULL);
                         efcurreq(othrq);
                         cswrtup();
                         wrtbuf->cclist=cp;
                         if ((msg->flags&FILATT) && !(msg->flags&FILIND)) {
                              rqiptr->stt=WAIT4ATT;
                              return;
                         }
                         startsnd();
                         return;
                    }
               }
          }
     }
     rsp2write(FALSE,0,NULL);
}

void
uplatt(                            /* upload an attachment to a new msg    */
struct saunam *dpknam,             /*   dynapak name in use                */
struct filinf *finfo)              /*   file dynapak info structure        */
{
     int tmprq;
     struct rqinfo *tmprqi;

     ASSERT(sameto(UPLATT,dpknam->suffix));
     tmprq=s2rq(&dpknam->suffix[sizeof(UPLATT)-1]);
     if (tmprq >= 0) {
          rqiptr->othrqid=srvrqid(usrnum,tmprq);
          if (ismyreq(rqiptr->othrqid,dpknam->appid)) {
               tmprqi=(struct rqinfo *)mrqoff(rqiptr->othrqid);
               if (sameas(tmprqi->dpknam.suffix,WRTNEW)
                || sameas(tmprqi->dpknam.suffix,WRTRPL)) {
                    if (tmprqi->stt == WAIT4ATT) {
                         rqiptr->dpknam=*dpknam;
                         rqiptr->u.uplinf.date=finfo->date;
                         rqiptr->u.uplinf.time=finfo->time;
                         wrtbuf=areaptr(wrmpool,tmprqi->wrthdl);
                         stlcpy(rqiptr->u.uplinf.attpath,wrtbuf->filatt,
                                MAXPATH);
                         tmprqi->stt=UPINGATT;
                         ok2write(wrtbuf->filatt);
                         return;
                    }
               }
          }
     }
     rsp2write(FALSE,0,NULL);
}

void
uladone(void)                      /* done uploading attachment to message */
{
     struct rqinfo *tmprqi;

     if (ismyreq(rqiptr->othrqid,rqiptr->dpknam.appid)) {
          tmprqi=(struct rqinfo *)mrqoff(rqiptr->othrqid);
          if (tmprqi->stt == UPINGATT) {
               setdtd(rqiptr->u.uplinf.attpath,rqiptr->u.uplinf.time,
                      rqiptr->u.uplinf.date);
               rsp2write(TRUE,0,NULL);
               efcurreq(rqiptr->othrqid);
               cswrtup();
               startsnd();
               return;
          }
     }
     unlink(rqiptr->u.uplinf.attpath);
     rsp2write(FALSE,0,NULL);
}

void
uplabt(void)                       /* attachment upload aborted            */
{
     struct rqinfo *tmprqi;

     unlink(rqiptr->u.uplinf.attpath);
     if (ismyreq(rqiptr->othrqid,rqiptr->dpknam.appid)) {
          tmprqi=(struct rqinfo *)mrqoff(rqiptr->othrqid);
          if (tmprqi->stt == UPINGATT) {
               tmprqi->stt=WAIT4ATT;
          }
     }
}

void
wrtabt(void)                       /* message write request aborted        */
{
     cswrtup();
     clsgmerq(efwork);
     if (wrtbuf->cclist != NULL) {
          free(wrtbuf->cclist);
     }
     switch (rqiptr->stt) {
     case SENDING:
          unlink(filatt);
     }
     unrarea(wrmpool,rqiptr->wrthdl);
     peruflg[usrnum]&=~WRTIPG;
}

void
cswrtup(void)                      /* set global ptrs to current write buf */
{
     ASSERT(rqiptr->wrthdl != NOHDL);
     wrtbuf=areaptr(wrmpool,rqiptr->wrthdl);
     msg=&wrtbuf->msg;
     msgtxt=wrtbuf->text;
     filatt=wrtbuf->filatt;
}

STATIC void
startsnd(void)                     /* start sending message                */
{
     setgmecb(efwork,cswrtcbk);
     rqiptr->stt=SENDING;
     wrtbuf->primsg=0L;
     if (rqiptr->flags&ISREPLY) {
          sndrpl();
     }
     else {
          sndnew();
     }
}

STATIC void
cswrtcbk(                          /* write message callback for C/S       */
int evt,                           /*   current event                      */
int rc)                            /*   result of last write operation     */
{
     switch (evt) {
     case EVTDSTS:
          rqiptr->flags|=WDSTING;
          break;
     case EVTDSTD:
          rqiptr->flags&=~WDSTING;
          break;
     case EVTCCST:
          rqiptr->flags|=WCCING;
          break;
     case EVTDONE:
          if (wrtbuf->primsg == 0L) {
               wrtbuf->primsg=msg->msgid;
          }
          if (rc > GMEAGAIN) {
               if (rqiptr->flags&WCCING) {
                    if (rc == GMEAFWD) {
                         cpynot(gmexinf());
                    }
                    else {
                         cpynot(msg->to);
                    }
               }
               else {
                    if (rc == GMEAFWD) {
                         wrtnot(gmexinf(),msg);
                    }
                    else {
                         wrtnot(msg->to,msg);
                    }
               }
          }
          else if ((rqiptr->flags&WCCING) && !(rqiptr->flags&WDSTING)) {
               if (qroom(usrnum,NORMAL)) {
                    *namtmp=rqiptr->dpknam;
                    strcpy(namtmp->suffix,"wrtccerr ");
                    stlcat(namtmp->suffix,spr("%d",rc),SFXSIZ);
                    senddpk(usrnum,rqiptr->dpknam.appid,NORMAL,namtmp,
                            STGLEN,msg->to);
               }
          }
          break;
     }
}

STATIC void
csndnew(void)                      /* cycled send a new message process    */
{
     cssetup();
     cswrtup();
     sndnew();
}

STATIC void
sndnew(void)                       /* send a new message                   */
{
     struct wrterr err;

     switch (err.rc=sendmsg(efwork,msg,msgtxt,filatt,wrtbuf->cclist)) {
     case GMEAGAIN:
          cycleme(csndnew);
          return;
     case GMEAFWD:
     case GMEOK:
          if (!(rqiptr->flags&(WDSTING|WCCING))) {
               if (err.rc == GMEAFWD) {
                    wrtnot(gmexinf(),msg);
               }
               else {
                    wrtnot(msg->to,msg);
               }
          }
          if (wrtbuf->primsg == 0L) {
               rsp2write(TRUE,sizeof(long),&msg->msgid);
          }
          else {
               rsp2write(TRUE,sizeof(long),&wrtbuf->primsg);
          }
          break;
     default:
          err.flags=THEMSG;
          rsp2write(FALSE,sizeof(struct wrterr),&err);
          break;
     }
     if (wrtbuf->cclist != NULL) {
          free(wrtbuf->cclist);
     }
     unrarea(wrmpool,rqiptr->wrthdl);
     peruflg[usrnum]&=~WRTIPG;
}

STATIC void
csndrpl(void)                      /* cycled send a reply process          */
{
     cssetup();
     cswrtup();
     sndrpl();
}

STATIC void
sndrpl(void)                       /* send a reply                         */
{
     struct wrterr err;

     switch (err.rc=reply(efwork,msg,msgtxt,filatt,wrtbuf->cclist)) {
     case GMEAGAIN:
          cycleme(csndrpl);
          return;
     case GMEAFWD:
     case GMEOK:
          if (!(rqiptr->flags&(WDSTING|WCCING))) {
               if (err.rc == GMEAFWD) {
                    wrtnot(gmexinf(),msg);
               }
               else {
                    wrtnot(msg->to,msg);
               }
          }
          if (wrtbuf->primsg == 0L) {
               rsp2write(TRUE,sizeof(long),&msg->msgid);
          }
          else {
               rsp2write(TRUE,sizeof(long),&wrtbuf->primsg);
          }
          break;
     default:
          err.flags=THEMSG;
          rsp2write(FALSE,sizeof(struct wrterr),&err);
          break;
     }
     if (wrtbuf->cclist != NULL) {
          free(wrtbuf->cclist);
     }
     unrarea(wrmpool,rqiptr->wrthdl);
     peruflg[usrnum]&=~WRTIPG;
}

STATIC BOOL                        /*   returns TRUE if dpk valid          */
ndpk2msg(                          /* convert new msg dpk to msg struct    */
struct newdpk *new,                /*   new message dynapak structure      */
struct message *msg,               /*   message header structure           */
char *text,                        /*   text buffer                        */
char *filatt)                      /*   file attachment (if indirect)      */
{
     char *scp,*ecp;

     ASSERT(new != NULL);
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(filatt != NULL);
     setmem(msg,sizeof(struct message),0);
     msg->forum=(unsigned)new->forum;
     msg->msgid=new->msgid;
     msg->gmid=new->gmid;
     msg->thrid=new->thrid;
     b2ccpy(msg->attname,new->attname,FLNSIZ);
     msg->flags=(long)new->flags;
     scp=unpad(new->info);
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(filatt,scp,MAXPATH);
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(msg->to,scp,MAXADR);
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(msg->topic,scp,TPCSIZ);
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(msg->history,scp,HSTSIZ);
     text[0]='\r';
     stlcpy(&text[1],ecp+1,TXTLEN-1);
     ecp=text+strlen(text);
     while (ecp > text && *ecp <= ' ') {
          *ecp--='\0';
     }
     return(TRUE);
}

void
csfwd(                             /* C/S common forward-message function  */
struct saunam *dpknam,             /*   dynapak name in use                */
char *fwdinf)                      /*   address to fwd to/comments         */
{
     rqiptr->wrthdl=rsvarea(wrmpool);
     if (rqiptr->wrthdl == NOHDL) {
          *(long *)rsptmp=(long)WRTBUSY;
          rsp2write(FALSE,sizeof(long),rsptmp);
          return;
     }
     rqiptr->flags|=BUFINU;
     cswrtup();
     rqiptr->dpknam=*dpknam;
     stlcpy(msgtxt,fwdinf,TXTLEN);
     rd4fwd();
}

STATIC void
crd4fwd(void)                      /* cycled read message for forward      */
{
     cssetup();
     cswrtup();
     rd4fwd();
}

STATIC void
rd4fwd(void)                       /* read message in prep for forward     */
{
     int rc,maxpfn;
     char *cp;

     switch (rc=readmsg(efwork,msg,(char *)rsptmp)) {
     case GMEAGAIN:
          cycleme(crd4fwd);
          return;
     case GMEOK:
          stlcpy((char *)vdatmp,msgtxt,TXTLEN);
          cp=strchr(vdatmp,FLDSEP);
          if (cp != NULL) {
               *cp++='\0';
               if (msg->forum == EMLID) {
                    maxpfn=3-pfceil;
               }
               else {
                    maxpfn=getdefp(msg->forum)->pfnlvl;
                    if (maxpfn == DFTPFN) {
                         maxpfn=3-pfceil;
                    }
                    else {
                         maxpfn=3-maxpfn;
                    }
               }
               if (profan(cp) > maxpfn) {
                    rejcfwd(PFNERR);
                    break;
               }
          }
          if (msg->forum != EMLID) {
               forctx(efwork,msg->forum,FSQFOR);
          }
          msg->forum=EMLID;
          stlcpy(msg->to,(char *)vdatmp,MAXADR);
          rc=val2gme(vfwdadr(efwork,usaptr->userid,msg->to,EMLID));
          if (rc != GMEOK) {
               rejcfwd(rc == GMEERR ? BADADR : rc);
               break;
          }
          if (msg->flags&FILATT) {
               rc=val2gme(vfwdatt(efwork,usaptr->userid,msg->to,EMLID));
               if (rc != GMEOK) {
                    rejcfwd(rc == GMEERR ? GMEIVA : rc);
                    break;
               }
          }
          if ((msg->flags&PRIMSG)
           && vfwdpri(efwork,usaptr->userid,msg->to,EMLID) != VALYES) {
               msg->flags&=~PRIMSG;
          }
          ASSERT(!(msg->flags&RECREQ));
          addcmt((char *)rsptmp,cp,msgtxt);
          csfwdit();
          break;
     default:
          rejcfwd(rc);
          break;
     }
}

STATIC void
ccsfwdit(void)                     /* cycled C/S forward message process   */
{
     cssetup();
     cswrtup();
     csfwdit();
}

STATIC void
csfwdit(void)                      /* C/S forward a message process        */
{
     int rc;

     switch (rc=fwdmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(ccsfwdit);
          return;
     case GMEOK:
     case GMEAFWD:
          rsp2write(TRUE,sizeof(long),&msg->msgid);
          break;
     default:
          *(long *)rsptmp=(long)rc;
          rsp2write(FALSE,sizeof(long),rsptmp);
          break;
     }
     clsgmerq(efwork);
     unrarea(wrmpool,rqiptr->wrthdl);
}

void
cscopy(                            /* C/S common copy-message function     */
struct saunam *dpknam,             /*   dynapak name in use                */
char *cpyinf)                      /*   address to copy to/comments        */
{
     rqiptr->wrthdl=rsvarea(wrmpool);
     if (rqiptr->wrthdl == NOHDL) {
          *(long *)rsptmp=(long)WRTBUSY;
          rsp2write(FALSE,sizeof(long),rsptmp);
          return;
     }
     rqiptr->flags|=BUFINU;
     cswrtup();
     rqiptr->dpknam=*dpknam;
     stlcpy(msgtxt,cpyinf,TXTLEN);
     rd4cpy();
}

STATIC void
crd4cpy(void)                      /* cycled read message for copy         */
{
     cssetup();
     cswrtup();
     rd4cpy();
}

STATIC void
rd4cpy(void)                       /* read message in prep for forward     */
{
     int rc,maxpfn;
     char *cp;

     switch (rc=readmsg(efwork,msg,(char *)rsptmp)) {
     case GMEAGAIN:
          cycleme(crd4cpy);
          return;
     case GMEOK:
          stlcpy((char *)vdatmp,msgtxt,TXTLEN);
          cp=strchr(vdatmp,FLDSEP);
          if (cp != NULL) {
               *cp++='\0';
               if (msg->forum == EMLID) {
                    maxpfn=3-pfceil;
               }
               else {
                    maxpfn=getdefp(msg->forum)->pfnlvl;
                    if (maxpfn == DFTPFN) {
                         maxpfn=3-pfceil;
                    }
                    else {
                         maxpfn=3-maxpfn;
                    }
               }
               if (profan(cp) > maxpfn) {
                    rejcfwd(PFNERR);
                    break;
               }
          }
          stlcpy(msg->to,(char *)vdatmp,MAXADR);
          rc=val2gme(valadr(efwork,usaptr->userid,msg->to,EMLID));
          if (rc != GMEOK) {
               rejcfwd(rc == GMEERR ? BADADR : rc);
               break;
          }
          if (msg->flags&FILATT) {
               rc=val2gme(valatt(efwork,usaptr->userid,msg->to,EMLID));
               if (rc != GMEOK) {
                    rejcfwd(rc == GMEERR ? GMEIVA : rc);
                    break;
               }
          }
          if ((msg->flags&PRIMSG)
           && valpri(efwork,usaptr->userid,msg->to,EMLID) != VALYES) {
               msg->flags&=~PRIMSG;
          }
          ASSERT(!(msg->flags&RECREQ));
          addcmt((char *)rsptmp,cp,msgtxt);
          msg->forum=EMLID;
          cscpyit();
          break;
     default:
          rejcfwd(rc);
          break;
     }
}

STATIC void
ccscpyit(void)                     /* cycled C/S forward message process   */
{
     cssetup();
     cswrtup();
     cscpyit();
}

STATIC void
cscpyit(void)                      /* C/S forward a message process        */
{
     int rc;

     switch (rc=copymsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(ccscpyit);
          return;
     case GMEOK:
     case GMEAFWD:
          rsp2write(TRUE,sizeof(long),&msg->msgid);
          break;
     default:
          *(long *)rsptmp=(long)rc;
          rsp2write(FALSE,sizeof(long),rsptmp);
          break;
     }
     clsgmerq(efwork);
     unrarea(wrmpool,rqiptr->wrthdl);
}

STATIC void
rejcfwd(                           /* reject copy or forward request       */
long rc)                           /*   error code to return               */
{
     unrarea(wrmpool,rqiptr->wrthdl);
     clsgmerq(efwork);
     rsp2write(FALSE,sizeof(long),&rc);
}

STATIC char *                      /*   returns pointer to destination buf */
addcmt(                            /* add comments to message text         */
char *txt,                         /*   buffer containing text             */
char *cmt,                         /*   buffer containing comments         */
char *buf)                         /*   destination buffer                 */
{
     long avlspc;

     avlspc=TXTLEN-strlen(txt)-strlen(abvcmt)-strlen(blwcmt)-2*UIDSIZ;
     if (cmt != NULL && cmt[0] != '\r' && cmt[0] != '\n') {
          --avlspc;
     }
     if (cmt == NULL || *cmt == '\0' || avlspc <= 0L) {
          stlcpy(buf,txt,TXTLEN);
     }
     else {
          sprintf(buf,abvcmt,usaptr->userid);
          if (cmt[0] == '\r' || cmt[0] == '\n') {
               stlcat(buf,cmt,(unsigned)avlspc);
          }
          else {
               stlcat(buf,"\r",(unsigned)avlspc);
               stlcat(buf,cmt,(unsigned)avlspc);
          }
          sprintf(buf+strlen(buf),blwcmt,usaptr->userid);
          stlcat(buf,txt,TXTLEN);
     }
     return(buf);
}

int                                /*   returns GME status code            */
readir(                            /* read E-mail with direction           */
int dir,                           /*   direction to read                  */
void *work,                        /*   GME work area                      */
struct message *msg,               /*   message header buffer              */
char *text)                        /*   message text buffer                */
{
     switch (dir) {
     case 0:
          return(readmsg(work,msg,text));
     case 1:
          return(nextmsg(work,msg,text));
     case -1:
          return(prevmsg(work,msg,text));
     default:
          ASSERT(FALSE);
     }
     return(GMEERR);
}

void
vdamsg(void)                       /* set msg and msgtxt to point at vdatmp*/
{
     msg=(struct message *)vdatmp;
     msgtxt=(char *)vdatmp+sizeof(struct message);
}

long
s2mn(                              /* converts string to msg# w/ error chk */
char *s)                           /*   string to convert                  */
{
     long n;

     if (!alldgs(s)) {
          return(-1L);
     }
     n=atol(s);
     if (n == 0L && s[0] != '0') {
          return(-1L);
     }
     return(n);
}

int
s2rq(                              /* converts string to reqid w/error chk */
char *s)                           /*   string to convert                  */
{
     int n;

     if (!alldgs(s)) {
          return(-1);
     }
     n=atoi(s);
     if (n == 0L && s[0] != '0') {
          return(-1);
     }
     return(n);
}

char *                             /*   returns pointer to static buffer   */
longstr(                           /* convert long int to left-padded str  */
long n)                            /*   number to convert                  */
{
     static char s[11];

     sprintf(s,"%010lu",n);
     return(s);
}

struct msgdpk *                    /*   returns copy of pointer to dest    */
msg2dpk(                           /* copy message to dynapak form         */
struct message *msg,               /*   message header                     */
char *text,                        /*   message text                       */
struct msgdpk *dmsg,               /*   message dynapak buffer             */
BOOL incltxt)                      /*   include message text in dmsg?      */
{
     char *cp;

     dmsg->forum=msg->forum;
     if (msg->forum == EMLID) {
          setmem(dmsg->fornam,FORNSZ-1,' ');
     }
     else {
          c2bcpy(dmsg->fornam,getfnm(msg->forum),FORNSZ-1);
     }
     dmsg->msgid=msg->msgid;
     dmsg->gmid=msg->gmid;
     dmsg->thrid=msg->thrid;
     c2bcpy(dmsg->attname,msg->attname,FLNSIZ-1);
     dmsg->crdatim=d2vdat(msg->crdate,msg->crtime);
     dmsg->rplto=msg->rplto;
     dmsg->nrpl=msg->nrpl;
     dmsg->flags=(int)msg->flags;
     stlcpy(dmsg->info,msg->from,MAXADR);
     cp=dmsg->info+strlen(dmsg->info);
     *cp++=FLDSEP;
     stlcpy(cp,msg->to,MAXADR);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,msg->topic,TPCSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,msg->history,HSTSIZ);
     if (incltxt) {
          cp+=strlen(cp);
          *cp++=FLDSEP;
          lf2cr(text);
          if (text[0] == '\r') {
               ++text;
          }
          stlcpy(cp,stpans(text),TXTLEN);
     }
     ASSERT(sizeof(struct msgdpk)+strlen(dmsg->info) <= MAXDPKV);
     return(dmsg);
}
