/***************************************************************************
 *                                                                         *
 *   CHANDIR.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Channel-specific directories, named CHANXX, where XX is the hex       *
 *   channel number, 00 to FF.                                             *
 *                                                                         *
 *                                              - R. Stein  7/20/94        *
 *                                                                         *
 ***************************************************************************/

extern
char *chdpfx;                      /* channel directory prefix             */
extern
long chdsiz;                       /* max bytes users allowed to store here*/

void
chdmak(void);                      /* make a channel directory             */

int
chdrem(void);                      /* remove a channel directory           */
                                   /* returns 0=ok, else=error             */

char *
chdpath(                           /* path of file in current channel dir  */
char *filespec);                   /* file name, wildcard, or NULL=dir name*/

char *
uchdpath(                          /* path of file in a channel directory  */
int unum,                          /* user number, 0 to nterms-1           */
char *filespec);                   /* file name, wildcard, or NULL=dir name*/

long
chdroom(void);                     /* find room in current channel dir     */
                                   /* also sets numfils, numbyts, numbytp  */

