/***************************************************************************
 *                                                                         *
 *   CHANDIR.C                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Channel-specific directories, named CHANXX, where XX is the hex       *
 *   channel number, 00 to FF.                                             *
 *                                                                         *
 *                                              - R. Stein  7/20/94        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "values.h"
#include "majorbbs.h"
#include "chandir.h"
#include "galchdir.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

STATIC void chdfin(void);

STATIC void (*oldfin)();           /* old value of module[0]->finrou       */

FILE *chdmb;                       /* GALCHDIR.MCV file                    */
char *chdpfx;                      /* channel directory prefix             */
long chdsiz;                       /* max bytes users allowed to store here*/
char *sysroom;                     /* key required to circumvent CHDSIZ    */

void EXPORT
init__chandir(void)
{
     int unmsav;
     struct fndblk fb;

     chdmb=opnmsg("GALCHDIR.MCV");
     chdpfx=stgopt(CHDPFX);
     chdsiz=lngopt(CHDSIZ,0,MAXLONG);
     sysroom=stgopt(SYSROOM);
     unmsav=usrnum;
     usrnum=nterms-1;
     chdmak();                     /* make sure CHDPFX will work on chan 00*/
     chdrem();
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          if (fnd1st(&fb,chdpath(NULL),FAMDIR)
           && deldir(chdpath(NULL)) != 0) {
               catastro("CANNOT EMPTY THE CHANNEL-SPECIFIC DIRECTORY %s:\n%s",
                        chdpath(NULL),deldirerr);
          }
     }
     usrnum=unmsav;
     oldfin=module[0]->finrou;
     module[0]->finrou=chdfin;
}

void
chdmak(void)                       /* make a channel directory             */
{
     char *cp;
     struct fndblk fb;

     if (mkdir(cp=chdpath(NULL)) != 0
      && (!fnd1st(&fb,cp,FAMDIR) || !(fb.attr&FAMDIR))) {
          catastro("Can't make the %s directory "
                   "specified by option CHDPFX",cp);
     }
}

int
chdrem(void)                       /* remove a channel directory           */
{
     return(rmdir(chdpath(NULL)));
}

char *
chdpath(                           /* path of file in current channel dir  */
char *filespec)                    /* file name, wildcard, or NULL=dir name*/
{                                  /* (usrnum implicit input)              */
     return(uchdpath(usrnum,filespec));
}

char *
uchdpath(                          /* path of file in a channel directory  */
int unum,                          /* user number, 0 to nterms-1           */
char *filespec)                    /* file name, wildcard, or NULL=dir name*/
{
     if (filespec == NULL) {
          return(spr("%s%02X",chdpfx,channel[unum]));
     }
     else {
          return(spr("%s%02X\\%s",chdpfx,channel[unum],filespec));
     }
}

long
chdroom(void)                      /* find room in current channel dir     */
{                                  /* also sets numfils, numbyts, numbytp  */
     long nfree;

     nfree=dskfre(drvnum(chdpfx));
     if (chdsiz == 0L || haskey(sysroom)) {
          return(nfree);
     }
     cntdirs(chdpath("*.*"));
     return(min(nfree,chdsiz-numbytp));
}

STATIC void
chdfin(void)                       /* shutdown, try to empty chan-spec dirs*/
{
     int unmsav;

     unmsav=usrnum;
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          deldir(chdpath(NULL));
     }
     usrnum=unmsav;
     (*oldfin)();
}

