VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SQLLoginDialog"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
Attribute VB_Description = "This class describes an object for managing a standard SQL login dialog."
Option Explicit
Public Name As String


' Show is the only method exposed for SQLLoginDialog.
Public Function Show(ByVal Caption As String, _
        ByVal Username As String, ByVal DBName As String) As String
    Dim frmNew As New frmSQLLoginDialog

    ' The form is created upon the first reference to its
    ' properties.
    With frmNew
        .Caption = Caption
        .txtDatabase.Text = DBName
        .txtUsername.Text = Username
        ' After setting the properties, show the dialog.
        .Show vbModal
        ' If the user canceled the dialog, return an empty string.
        If .DialogCanceled Then
            Show = ""
        Else  ' Assemble and return the completed login string.
            Show = "ODBC;UID=" & .txtUsername.Text & _
                ";PWD=" & .txtPassword.Text & ";DATABASE=" & _
                .txtDatabase.Text & ";LoginTimeOut=30"
        End If
    End With
    Unload frmNew
End Function




