Attribute VB_Name = "Module2"

Sub FOpenProc()
    Dim RetVal
    On Error Resume Next
    Dim OpenFileName As String
    frmMDI.CMDialog1.Filename = ""
    frmMDI.CMDialog1.ShowOpen
    If Err <> 32755 Then    ' User chose Cancel.
        OpenFileName = frmMDI.CMDialog1.Filename
        ' If the file is larger than 65K, it can't
        ' be opened, so cancel the operation.
        If FileLen(OpenFileName) > 65000 Then
            MsgBox "The file is too large to open."
            Exit Sub
        End If
        
        OpenFile (OpenFileName)
        UpdateFileMenu (OpenFileName)
        ' Show the toolbar if they aren't already visible.
        If gToolsHidden Then
            frmMDI!imgcutbutton.Visible = True
            frmMDI!imgcopybutton.Visible = True
            frmMDI!imgPasteButton.Visible = True
            gToolsHidden = False
        End If
    End If
End Sub

Function GetFileName(Filename As Variant)
    ' Display a Save As dialog box and return a filename.
    ' If the user chooses Cancel, return an empty string.
    On Error Resume Next
    frmMDI.CMDialog1.Filename = Filename
    frmMDI.CMDialog1.ShowSave
    If Err <> 32755 Then    ' User chose Cancel.
        GetFileName = frmMDI.CMDialog1.Filename
    Else
        GetFileName = ""
    End If
End Function

Function OnRecentFilesList(Filename) As Integer
  Dim i

  For i = 1 To 4
    If frmMDI.mnuRecentFile(i).Caption = Filename Then
      OnRecentFilesList = True
      Exit Function
    End If
  Next i
    OnRecentFilesList = False
End Function

Sub OpenFile(Filename)
    Dim NL, TextIn, GetLine
    Dim fIndex As Integer

    NL = Chr(13) + Chr(10)
    
    On Error Resume Next
    ' Open the selected file.
    Open Filename For Input As #1
    If Err Then
        MsgBox "Can't open file: " + Filename
        Exit Sub
    End If
    ' Change the mouse pointer to an hourglass.
    Screen.MousePointer = 11
    
    ' Change the form's caption and display the new text.
    fIndex = FindFreeIndex()
    Document(fIndex).Tag = fIndex
    Document(fIndex).Caption = UCase(Filename)
    Document(fIndex).Text1.Text = Input(LOF(1), 1)
    FState(fIndex).Dirty = False
    Document(fIndex).Show
    Close #1
    ' Reset the mouse pointer.
    Screen.MousePointer = 0
End Sub

Sub SaveFileAs(Filename)
On Error Resume Next
    Dim Contents As String

    ' Open the file.
    Open Filename For Output As #1
    ' Place the contents of the notepad into a variable.
    Contents = frmMDI.ActiveForm.Text1.Text
    ' Display the hourglass mouse pointer.
    Screen.MousePointer = 11
    ' Write the variable contents to a saved file.
    Print #1, Contents
    Close #1
    ' Reset the mouse pointer.
    Screen.MousePointer = 0
    ' Set the form's caption.
    If Err Then
        MsgBox Error, 48, App.Title
    Else
        frmMDI.ActiveForm.Caption = UCase(Filename)
        ' Reset the dirty flag.
        FState(frmMDI.ActiveForm.Tag).Dirty = False
    End If
End Sub

Sub UpdateFileMenu(Filename)
        Dim RetVal
        ' Check if the open filename is already in the File menu control array.
        RetVal = OnRecentFilesList(Filename)
        If Not RetVal Then
          ' Write open filename to MDINOTEPAD.INI.
          WriteRecentFiles (Filename)
        End If
        ' Update the list of the most recently opened files in the File menu control array.
        GetRecentFiles
End Sub

