/*
 * WLTVAR.CPP
 *
 * Text Variables
 *
 */

#include "gcomm.h"
#include "majorbbs.h"
#include <strstrea.h>
#include <list>
#include "galacth.h"
#include "dnf.h"
#include "wltvar.h"
#include "ahutil.h"
#include "infwlah.h"

#define FILREV "$Revision: 1 $"
             
enum tvbtype {TVB_BASIC,TVB_HTML,TVB_ENC,TVB_LINKED};

basicTvb tv_goToUrl("WL_GOTO_URL");
basicTvb tv_msgid("WL_MSGID");
basicTvb tv_templateMask("WL_TEMPLATE_MASK");
basicTvb tv_errorCode("WL_ERR_CODE");
basicTvb tv_errorMessage("WL_ERR_MESSAGE");

MARKSOURCE(wltvar);


VOID
initTextVars()
{
//     ::setmbk(wlMsgFile);
//     ::rstmbk();
}

const CHAR*
htmlFmtCrlf(
const CHAR* str)
{
     static string res("");

     ASSERT(str != NULL);
     res="";

     while (*str != NULL) {
          if (*str == '\r') {
               res+="<BR>";
          }
          else if (*str == ' ' && *(str+1) == ' ') {
               res+="&nbsp;";
          }
          else if (*str != '\n') {
               res+=*str;
          }
          ++str;
     }
     return(res.c_str());
}


VOID
clearTextVars()
{
     tv_goToUrl="";
     tv_msgid="";
     tv_errorCode="";
     tv_errorMessage="";
}

VOID
setTemplateMask(
const string& templ,
const dnfHandler* dnf)
{
     if (templ.length() == 0) {
          if (dnf != NULL) {
               tv_templateMask=dnf->getMap().getFile();
          }
          else {
               tv_templateMask="";
          }
     }
     else {
          tv_templateMask=templ;
     }
}

VOID
setErrorVars(                      // set error variables
INT err,                           // error code
const CHAR* errstg)                // error string to set
{
     tv_errorCode=err;
     tv_errorMessage=errstg;
}


