/***************************************************************************
 *                                                                         *
 *   WLAGENT.CPP                                                            *
 *                                                                         *
 *   Webcast List Server Agent Class.                                            *
 *                                                  - N.Hammond 2/02       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "phasedbg.h"
#include <list>

#include "wlagent.h"
#include "wltvar.h"
#include "wlmsg.h"
// synthesis classes
#include "synbase.h"
#include "syninval.h"
#include "syngfil.h"
#include "synScript.h"
#include "synVidlink.h"
#include "syninita.h"

#define URLARG(x) sameas(ses->urlargv(0),x)
#define VBTIMEOUT 120000L      // video broadcaster timeout (in milliseconds). 5 mins=300,000(2=120000)
webAgent *theWebAgent;             // pointer to agent

MARKSOURCE(wlagt);

CHAR tmpbuf[500];

extern "C" VOID EXPORT             // init our agent
init__infwlah(VOID)
{
     theWebAgent=new webAgent;
}

webAgent::webAgent() : acthAgent("Webcast List Server","scripts")
{
     registerAgent(acthVersion);
     initAgent();
}

webAgent::~webAgent()
{
     finishAgent();
}

static VOID
CheckTimestamp(VOID)                // See if any broadcasters have timed out
{
     INT i; ULONG curtick;
     curtick=::GetTickCount();
     for (i=0; i < BLISTSIZE; i++) {
         if (*theWebAgent->BcasterList[i].regno != '\0'
         && (curtick - theWebAgent->BcasterList[i].timestamp) > VBTIMEOUT) {
            *theWebAgent->BcasterList[i].regno='\0'; // remove from list
         }
     }
    rtkick(60,CheckTimestamp);
}

VOID
webAgent::initAgent()               // registry agent initialization
{
     ::initTextVars();
     for (INT i=0; i < BLISTSIZE; i++) {
         *BcasterList[i].regno='\0';
     }
     rtkick(2,CheckTimestamp);
}

VOID
webAgent::finishAgent()             // shutdown the agent
{
}

acthSynthesis*                      //   pointer to new synthesis obj
webAgent::newSynthesis(             // create a new synthesis
acthSession* ses)                   //   acthSession ptr
{
     INT narg=ses->urlargc();

     //logit("newSynthesis url=%s",ses->url());
     if (narg > 0) {
          if (narg == 2 && ::sameas(ses->urlargv(0),"file")) {
             return(new synGenericFile(ses,true,1));
          }
          //if (sameas(ses->urlargv(0),"script")) {
          if (sameas(ses->urlargv(0),"wlregistry.dll")) {
               return(new synScript(ses,true,1));
          }
          if (sameas(ses->urlargv(0),"vidlink")) {
               return(new synVidlink(ses,true,1));
          }
     }
     if (narg == 0 || (narg == 1 && ::strchr(ses->urlargv(0),'.') != 0)) {
          return(new synInitial(ses,true,0));
     }
     return(new synInvalidURL(ses));
}


