/*
 *   WLAH.H
 *
 *   Active HTML Misc Header
 */

#include "infwlah.h"

#ifndef __WLAH_H
#define __WLAH_H

#define PPFIX "galacth/infwlah"

extern VOID logit(char *logstg, ...);

typedef enum {
     ERR_NOERROR=0,
     ERR_PARAMMISSING,
     ERR_UIDNFND,
     ERR_DEMO,

     ERR_LASTERROR   // this must be last err, insert new before
} errorcodes;

extern INT errArray[];

CHAR *                             //   returns allocated buffer
urlEncodeStr(                      // encode special characters in a URL
const CHAR *src);                  //   unencoded URL

size_t
urlEncodeSize(                     // size of encoded URL (incl '\0')
const CHAR *src);                  //   unencoded URL

CHAR *                             //   returns pointer to destination
urlEncodeBuf(                      // encode special characters in URL
CHAR *buf,                         //   buffer to receive encoded string
const CHAR *src,                   //   unencoded URL
size_t bufSiz);                    //   size of destination buffer

CHAR *                             //   returns pointer to destination
urlDecodeBuf(                      // decode special characters in URL
CHAR *buf,                         //   buffer to receive decoded string
const CHAR *src,                   //   unencoded URL
size_t bufSiz);                    //   size of destination buffer

bool
urlNeedEncode(                     // does this character need to be encoded?
CHAR c);                           //   character to check

bool                               //   returns true if replaced a token
ReplaceStringFirst(                // replace first of one string with another
CHAR * buf,                        //   buffer containing string to modify
size_t bufSiz,                     //   size of buffer
CHAR const * strOld,               //   old string to be replaced
CHAR const * strNew);              //   new string to replace with

CHAR *                             //   returns a pointer to substring or NULL
FindString(                        // find a string within another
CHAR * str,                        //   string to search
CHAR const * sub);                 //   substring to search for

CHAR * SQLFixup(CHAR *stg);
CHAR * StrReplace(char *Str, char *OldStr, char *NewStr);

#endif // __WLAH_H
