/*
 * SYNINITA.CPP
 *
 *   Initial Synthesis Class
 *   This is a bit different than normal because expects startup parms
 *   gotoUrl= and msgid= on url line (actually defual to homepage and 1 if not found)
 *
 */


#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "ahutil.h"
#include "syninita.h"
#include "infwlah.h"
#include "wltvar.h"

#define FILREV "$Revision: 1 $"

dnfStep dnfNoFrameSteps[]={
     dnfStep(DNFMAPEND)
};
dnfMap filNoFrameMap(PPFIX "/index.htm","Response",dnfNoFrameSteps);

dnfStep dnffilErrorSteps[]={
     dnfStep(DNFMAPEND)
};
dnfMap filErrorMap(PPFIX "/error.htm","webcast list server startup error",dnffilErrorSteps);

//
//  Default URL Synthesis Member Functions
//

MARKSOURCE(syninita);

ACTHCODE
synInitial::proceedRequest()            // setup request context
{
     ACTHCODE rc=synBaseAuth::proceedRequest();
     if (rc != ACTHMORE) {
          return(rc);
     }
    m_SynState=(m_err == ERR_NOERROR ? SYNSTATE_SYNTH : SYNSTATE_RESPONSE);
    return(rc);
}

ACTHCODE
synInitial::proceedSynth()              // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synInitial::proceedDerivedResponse()    // proceed with response
{
     ACTHCODE rc=ACTHMORE;

     if (m_dnf == NULL) {
         if (m_err != ERR_NOERROR) { // picks up errors from  proceedRequest above
             return(errorResponse(filErrorMap,PPFIX "/"));
         }

          string strRedirloc=""; //g_strRedirNoFrame;  // redirection for the default no-frames response (REDNOF msg)
          dnfMap* pMap=&filNoFrameMap;
          CHAR ch='N';

          if (m_onsuccessFile != NULL) {
               strRedirloc=m_onsuccessFile;
          }
          else if (strRedirloc.length() == 0
           || ses->urlargc() != m_lvlcnt) {
               CHAR* fnbuf;
               if (ses->urlargc() > m_lvlcnt) {
                    const CHAR* fnptr=ses->urlargv(m_lvlcnt);
                    fnbuf=new CHAR[strlen(fnptr)+1];
                    strcpy(fnbuf,fnptr);
               }
               else {
                    fnbuf=new CHAR[sizeof("INDEX*.HTM")+1];
                    strcpy(fnbuf,"INDEX.HTM");
               }
               strRedirloc=fnbuf;
               delete [] fnbuf;
          }
          if (isProtocol(strRedirloc.c_str()) || strRedirloc[0] == '/') {
               ses->setStatus("302 Redirect");
               ostrstream ost;
               if (strRedirloc[0] == '/') {
                    ost << "http://" << ses->host() << strRedirloc.c_str() << ends;
               }
               else {
                    ost << strRedirloc.c_str() << ends;
               }
               ses->headerField("Location",ost.str());
               ses->contypeMIME("text/html");
               bout << "Request redirected to: <A HREF=\"" << ost.str();
               bout << "\">" << ost.str() << "</A>" << crlf;
               ost.rdbuf()->freeze(0);
               rc=ACTHDONE;
             shocst("redir","");  
          }
          else {
               CHAR* fnbuf=new CHAR[strRedirloc.length()+1];
               strcpy(fnbuf,strRedirloc.c_str());
               strrpl(fnbuf,'*',ch);
               string strfname=PPFIX "/";
               strfname+=fnbuf;
               m_dnf=dnfCreateHandler(&bout,pMap,strfname.c_str());
               delete [] fnbuf;
          }
     }
     else if (m_dnf->process() == DNFEND) {
          rc=ACTHDONE;
     }
     return(rc);
}

INT
synInitial::translateError()           // translate err to mcv file op (make this global!)
{
     if (m_err > 0 && m_err < ERR_LASTERROR) {
          return(errArray[m_err]);
     }
     m_errtext=spr("%d",(INT)m_err);
     return(ERROOPS);
}

