/*
 * synVidlink.CPP
 *
 * SCRIPT Synthesis
 *
 */

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "gme.h"
#include "synVidlink.h"
#include "wlmsg.h"
#include "wlah.h"
#include "infwlah.h"
#include "wltvar.h"
#include "smtpexp.h" // for smtpHost()

#define FILREV "$Revision: 1 $"


static
dnfStep dnfSuccessSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap VidlinkSuccessMap(PPFIX "/Scripts/index.htm","Success Response",dnfSuccessSteps);

dnfStep dnfVidlinkErrorSteps[]={
     dnfStep(DNFMAPEND)
};
dnfMap VidlinkErrorMap(PPFIX "/Scripts/error.htm","Error Response",dnfVidlinkErrorSteps);

MARKSOURCE(synVidlink);

ACTHCODE
synVidlink::proceedRequest()            // setup request context
{
     //logit("url=%s",ses->url());
    ACTHCODE rc=synBaseAuth::proceedRequest();

    if (!ses->param("userid",uid,sizeof(uid))) {
        m_err=ERR_PARAMMISSING;
        m_errtext="userid";
    }
    m_SynState=(m_err == ERR_NOERROR ? SYNSTATE_SYNTH : SYNSTATE_RESPONSE);
    return(rc);
}

ACTHCODE
synVidlink::proceedSynth()              // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synVidlink::proceedDerivedResponse()    // proceed with response
{
   INT i; GBOOL fnd;

if (m_dnf == NULL) {

 // See if userid in the broadcast list
   for (i=0,fnd=FALSE; i < BLISTSIZE; i++) {
		if (sameas(theWebAgent->BcasterList[i].username,uid)) {
            fnd=TRUE;
            break;
      }
   }
   if (fnd) {
     bout << theWebAgent->BcasterList[i].hostname;
   }
   else {
     bout << "Not broadcasting";
     //return(errorResponse(VidlinkErrorMap,PPFIX "/Scripts/")); dosn;t work
   }
   return(ACTHDONE);
} else {
   return(ACTHDONE);
}

}

INT
synVidlink::translateError()           // translate err to mcv file op (make this global!)
{
     if (m_err > 0 && m_err < ERR_LASTERROR) {
          return(errArray[m_err]);
     }
     m_errtext=spr("%d",(INT)m_err);
     return(ERROOPS);
}


