/*
 * SYNscript.H
 *
 * script Synthesis Header
 *
 */

#ifndef __SYNSCRIPT_H
#define __SYNSCRIPT_H

#include "synbase.h"
#include "wlah.h"
#include "wlmsg.h"

class synScript : public synBaseAuth {   // generic file output
public:
     synScript(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=1) : synBaseAuth(_ses,anonok,AgentKey,lvlcnt)
     {
       *btype='\0';
       *regno='\0';
     }

     ~synScript()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();          // output the response

     INT
     translateError();                  // translate err to mcv file op

private:
     CHAR btype[50];     // broadcaster type param
     CHAR regno[10];
     INT idx;
};

#endif // __SYNSCRIPT_H
