/*
 * SYNSCRIPT.CPP
 *
 * SCRIPT Synthesis
 *
 */

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "gme.h"
#include "synScript.h"
#include "wlmsg.h"
#include "wlah.h"
#include "infwlah.h"
#include "wltvar.h"
#include "smtpexp.h" // for smtpHost()

#define FILREV "$Revision: 1 $"

void hpDebug(char *first, ...);			// Inserted at HiPACE

static
dnfStep dnfSuccessSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap ScriptSuccessMap(PPFIX "/Scripts/index.htm","Success Response",dnfSuccessSteps);

dnfStep dnfScriptErrorSteps[]={
     dnfStep(DNFMAPEND)
};
dnfMap ScriptErrorMap(PPFIX "/Scripts/error.htm","Tell-a-friend Error",dnfScriptErrorSteps);

enum {BHOST,BNAME,BEMAIL,BAUXINFO};
dnfStep blsteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,BHOST,"BHOST"),
          dnfStep(DNFCOLUMN,BNAME,"BNAME"),
          dnfStep(DNFCOLUMN,BEMAIL,"BEMAIL"),
          dnfStep(DNFCOLUMN,BAUXINFO,"BAUXINFO"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND),
};
dnfMap blmap(PPFIX "/Scripts/index.htm","Broadcaster List",blsteps);

MARKSOURCE(synScript);

ACTHCODE
synScript::proceedRequest()            // setup request context
{
   INT i,e; GBOOL fnd;
     //logit("url=%s",ses->url());
     ACTHCODE rc=synBaseAuth::proceedRequest();

     strcpy(btype,itemidxd(ses->url(),1,"?"));
     strcpy(vdatmp,itemidxd(ses->url(),2,"?")); // get other parms list that's sep by '&'
     strcpy(regno,itemidxd(vdatmp,1,"&"));


	 //hpDebug("btype is \"%s\"", btype);
	 //hpDebug("vdatmp is \"%s\"", vdatmp);
	 //hpDebug("regno is \"%s\"", regno);
	 
     if (sameas(btype,"BroadcasterOn")) {  // add to broadcaster array
       // already in list? Also set e to first open slot
       for (i=0,e=-1,fnd=FALSE; i < BLISTSIZE; i++) {
         if (e == -1 && *theWebAgent->BcasterList[i].regno=='\0')
            e=i;
		if (sameas(theWebAgent->BcasterList[i].regno,regno)) {
            fnd=TRUE;
            theWebAgent->BcasterList[i].timestamp = ::GetTickCount();  // update timestamp
            break;
         }
       }
       // If not in list, add it to empty slot
       if (!fnd && e != -1) {
         // Fix up string data (replace + with space)
         CHAR *stg=vdatmp;
         while (*stg != '\0') {
             if (*stg == '+')
                 *stg=' ';
             ++stg;
         }
         strcpy(theWebAgent->BcasterList[e].regno,regno);
         strcpy(theWebAgent->BcasterList[e].version,itemidxd(vdatmp,0,"&"));
         strcpy(theWebAgent->BcasterList[e].hostname,itemidxd(vdatmp,2,"&"));
         strcpy(theWebAgent->BcasterList[e].username,itemidxd(vdatmp,3,"&"));
         strcpy(theWebAgent->BcasterList[e].email,itemidxd(vdatmp,4,"&"));
         strcpy(theWebAgent->BcasterList[e].auxinfo,itemidxd(vdatmp,6,"&"));
         theWebAgent->BcasterList[e].timestamp = ::GetTickCount();
         //Bdata.bdisplay,itemidxd(vdatmp,5,"&"));
         // m_audio
       }
       return(ACTHDONE);
       // return(ACTHDONE); comment out here so get an invalid resp from server

     } else if (sameas(btype,"BroadcasterOff")) {
       // already in list?
       for (i=0; i < BLISTSIZE; i++) {
         if (sameas(theWebAgent->BcasterList[i].regno,regno)) {
            *theWebAgent->BcasterList[i].regno='\0'; // remove from list
            break;
         }
       }
       return(ACTHDONE);

     } else if (sameas(btype,"GetBroadcasterList")) {
       // keep going to synthis below
      /*
       if (!registered_version) {
          m_err=ERR_DEMO;
          m_errtext="";
       }
      */

     } else {
       logit("unknown url=%s",ses->url());
       m_err=ERR_PARAMMISSING;
       m_errtext="Unknown URL";
       //return(ACTHDONE);
     }

/*
   for (i=0; i < 2; i++) {
     shocst("bcasterlist hostname","%d) %s",i,theWebAgent->BcasterList[i].hostname);
     shocst("bcasterlist username","%d) %s",i,theWebAgent->BcasterList[i].username);
     shocst("bcasterlist email","%d) %s",i,theWebAgent->BcasterList[i].email);
     shocst("bcasterlist regno","%d) %s",i,theWebAgent->BcasterList[i].regno);
     shocst("bcasterlist version","%d) %s",i,theWebAgent->BcasterList[i].version);
     shocst("bcasterlist auxinfo","%d) %s",i,theWebAgent->BcasterList[i].auxinfo);
     //shocst("bcasterlist m_audio","%d) %d",i,theWebAgent->BcasterList[i].m_audio);
   }
*/
     if (rc != ACTHMORE) {
          return(rc);
     }

    m_SynState=(m_err == ERR_NOERROR ? SYNSTATE_SYNTH : SYNSTATE_RESPONSE);
    return(rc);
}

ACTHCODE
synScript::proceedSynth()              // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synScript::proceedDerivedResponse()    // proceed with response
{
    ACTHCODE rc=ACTHMORE;
    if (m_dnf == NULL) {
         m_dnf=new dnfHandler(blmap,bout);
         idx=-1;
     } else {
         switch (m_dnf->process()) {
           case DNFROWBEGIN:
                if (++idx < BLISTSIZE) {
                     if (*theWebAgent->BcasterList[idx].regno=='\0')
                        m_dnf->sayAgain();
                } else {
                     m_dnf->tableDone();
                }
                break;
           case BNAME:
                bout << urlDecodeBuf(tmpbuf,theWebAgent->BcasterList[idx].username,sizeof(tmpbuf));
                break;
           case BHOST:
                bout << theWebAgent->BcasterList[idx].hostname;
                break;
           case BEMAIL:
                bout << urlDecodeBuf(tmpbuf,theWebAgent->BcasterList[idx].email,sizeof(tmpbuf));
                break;
           case BAUXINFO:
                bout << urlDecodeBuf(tmpbuf,theWebAgent->BcasterList[idx].auxinfo,sizeof(tmpbuf));
                break;
           case DNFEND:
                rc=ACTHDONE;
                break;
           }
    }

    return(rc);
}

INT
synScript::translateError()           // translate err to mcv file op (make this global!)
{
     if (m_err > 0 && m_err < ERR_LASTERROR) {
          return(errArray[m_err]);
     }
     m_errtext=spr("%d",(INT)m_err);
     return(ERROOPS);
}



void hpDebug(char *first, ...)			// Inserted at HiPACE
{
   va_list marker;
   
   char *buf = new char [10240];

   if (buf)
   {
	   va_start( marker, first );
	   vsprintf((char *)buf, first, marker);
	   va_end( marker );
	   FILE *fp = fopen ("inf.txt", "a");
	   if (fp)
	   {
		   fprintf (fp, "%s\n\n#####\n\n", buf);
		   fclose(fp);
	   }
	   delete []buf;
   }
}										// END: Inserted at HiPACE