/*
 * SYNGFIL.CPP
 *
 *   Generic File Synthesis
 *
 */

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "syngfil.h"
#include "wlmsg.h"
#include "infwlah.h"
#include "wltvar.h"

#define FILREV "$Revision: 1 $"

static
dnfStep dnfSuccessSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap filSuccessMap(PPFIX "/file/index.htm","Success Response",dnfSuccessSteps);

MARKSOURCE(syngfil);

ACTHCODE
synGenericFile::proceedRequest()            // setup request context
{
     ACTHCODE rc=synBaseAuth::proceedRequest();
     m_SynState=SYNSTATE_SYNTH;
     return(rc);
}

ACTHCODE
synGenericFile::proceedSynth()              // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synGenericFile::proceedDerivedResponse()    // proceed with response
{
     ACTHCODE rc=ACTHMORE;

     if (m_dnf == NULL) {
          m_dnf=dnfCreateHandlerURL(ses,&filSuccessMap,PPFIX);
          if (m_dnf != NULL) {
               CHAR fileExtension[GCMAXEXT+1];
               const CHAR* fileName=m_dnf->getMap().getFile();
               fileparts(GCPART_EXTN,fileName,fileExtension,GCMAXEXT+1);
               ses->contypeFext(fileExtension);
          }
     }
     else if (m_dnf->process() == DNFEND) {
          rc=ACTHDONE;
     }
     return(rc);
}

INT
synGenericFile::translateError()           // translate err to mcv file op (make this global!)
{
     if (m_err > 0 && m_err < ERR_LASTERROR) {
          return(errArray[m_err]);
     }
     m_errtext=spr("%d",(INT)m_err);
     return(ERROOPS);
}


