/*
 *   SYNBASE.H
 *
 *   Base Synthesis Header
 *
 */

#include "cyctimer.h"
#include "galacth.h"
#include "wlagent.h"
#include "dnf.h"
#include <cstring.h>
#include "wlah.h"
#include "wltvar.h"

#ifndef __SYNBASE_H
#define __SYNBASE_H

class synBase : public acthSynthesis {
public:
     synBase(acthSession* _ses);

     virtual
     ~synBase();

     ACTHCODE
     proceed();                         // acthSynthesis proceed implementation

protected:
     virtual
     ACTHCODE
     proceedRequest()=0;                // setup request context

     virtual
     ACTHCODE
     proceedSynth()=0;                  // synthesise the response

     virtual
     ACTHCODE
     proceedResponse()=0;               // output the response

     bool
     startProc();                       // cycle timer ok to start

     bool
     contProc(                          // cycle timer ok to continue
     ACTHCODE rc);                      //  return code so far

     enum synstate {SYNSTATE_REQUEST,SYNSTATE_SYNTH,SYNSTATE_RESPONSE};

     enum synstate m_SynState;          // request state
     cycleTimer m_timer;                // cycle timer object
};

class synBaseAuth : public synBase {
public:
     synBaseAuth(
     acthSession* _ses,
     bool anonok,
     CHAR const * reqkey,
     INT lvlcnt=0);

     virtual
     ~synBaseAuth();

protected:
     virtual
     ACTHCODE
     proceedRequest();                  // setup request context

     virtual
     ACTHCODE
     proceedSynth()=0;                  // synthesise the response

     virtual
     ACTHCODE
     proceedDerivedResponse()=0;        // output response

     virtual
     INT
     translateError()=0;                // translate error to msg file text

     ACTHCODE                           //   continue synthesis?
     errorResponse(                     // an error was encountered
     dnfMap& map,                       //   map to use for error response
     CHAR const * path);                //   path to the template directory

     ACTHCODE                           //   continue synthesis?
     successResponse(                   // process onsuccess parameter
     dnfMap& map,                       //   map to use for error response
     CHAR const * path);                //   path to the template directory

     VOID
     setErrorVars();                    // set error text variables

     bool m_anonok;                     // anon access is ok
     INT  m_lvlcnt;                     // how deep is this url (/forums/view/)
     acthUserID* m_usr;                 // the current user
     struct usracc m_usracc;            // user account structure
     bool m_succRedir;                  // redirect on success?
     bool m_errRedir;                   // redirect on error?
     CHAR* m_onsuccessFile;             // path to redirect onsuccess to
     string m_onerrorFile;              // path to redirect onerror to
     CHAR const * m_reqKey;             // key required to access URL
     errorcodes m_err;                  // error status
     string m_errtext;                  // extra info on the error
     enum synsubstate {
        SYNSUB_BUILDMAP,
        SYNSUB_BUILDCONTEXT,
        SYNSUB_WRITEFSTREAM,
        SYNSUB_FINISHUPLOAD,
        SYNSUB_FINALFINISHUPLOAD,
        SYNSUB_MOVEFILE,
        SYNSUB_UPDONE
     };
     enum synsubstate m_SynSubState;    // substate of request synthesis
     dnfHandler* m_dnf;                 // dnf Handler
     string m_strTemplate;              // template used for request
     CHAR* m_errParam;                  // contents of onerror parameter
     bool m_bActive;                    // active website?

private:
     virtual
     ACTHCODE
     proceedResponse();                 // output the response

     VOID
     initTemplates();                   // init onerror/onsuccess templates

     bool                               //   should we redirect?
     getOnParam(                        // get onsuccess/onerror parameter
     CHAR const * paramName,            //   name of param we're getting
     CHAR const * dftFileName,          //   default file name to use
     CHAR** pStorePtr);                 //   buffer to store param value

     VOID
     setusaptr();                       // set the current user acc pointer

private:
    synBaseAuth(acthSession* _ses);     // default activeh constructer-not impl
};

#endif // __SYNBASE_H
