/***************************************************************************
 *                                                                         *
 *   CYCTIMER.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Generic class for timing cycled processes using an average time       *
 *   slice.                                                                *
 *                                                                         *
 *                                            - J. Alvrus   9/4/97         *
 *                                                                         *
 ***************************************************************************/

#ifndef __CYCTIMER_H
#define __CYCTIMER_H

#include "gcomm.h"

class cycleTimer {                 // class for timing cycled processes
public:
     cycleTimer();                 // default constructor

     cycleTimer(                   // constructor with time slice
     INT sliceSize);               //   average time slice to use (ms)

     VOID
     setSlice(                     // set time slice
     INT sliceSize);               //   average time slice to use (ms)

     bool
     start();                      // can we start a process?

     bool
     haveTime();                   // do we have time to continue process?

     VOID
     reset();                      // clear timer state

private:                           // private data members
#ifdef DEBUG
     bool m_sliceSet;              //   has time slice size been set?
#endif // DEBUG
     ULONG m_timeSlice;            //   desired average time slice
     ULONG m_timeDebt;             //   current time debt
     ULONG m_begTime;              //   start time of current process
};

#endif // __CYCTIMER_H
