/***************************************************************************
 *                                                                         *
 *   CYCTIMER.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Generic class for timing cycled processes using an average time       *
 *   slice.                                                                *
 *                                                                         *
 *                                            - J. Alvrus   9/4/97         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "cyctimer.h"

#define FILREV "$Revision: 4 $"

cycleTimer::cycleTimer() :         // default constructor
#ifdef DEBUG
     m_sliceSet(false),
#endif // DEBUG
     m_timeDebt(0)
{
}

cycleTimer::cycleTimer(            // construct and init time slice
INT sliceSize) :                   //   average time slice to use (ms)
#ifdef DEBUG
     m_sliceSet(false),
#endif // DEBUG
     m_timeDebt(0)
{
     setSlice(sliceSize);
}

VOID
cycleTimer::setSlice(              // set time slice
INT sliceSize)                     //   average time slice to use (ms)
{
     ASSERT(sliceSize > 0);
     m_timeSlice=(sliceSize*65536UL)/1000UL;
#ifdef DEBUG
     m_sliceSet=true;
#endif // DEBUG
}

bool
cycleTimer::start()                // can we start a process?
{
     ASSERT(m_sliceSet);
     if (m_timeDebt >= m_timeSlice) {
          m_timeDebt-=m_timeSlice;
          return(false);
     }
     m_begTime=::hrtval()-m_timeDebt;
     m_timeDebt=0;
     return(true);
}

bool
cycleTimer::haveTime()             // do we have time to continue process?
{
     ASSERT(m_sliceSet);
     ULONG usedTime=::hrtval()-m_begTime;
     if (usedTime >= m_timeSlice) {
          m_timeDebt=usedTime-m_timeSlice;
          return(false);
     }
     return(true);
}

VOID
cycleTimer::reset()                // clear timer state
{
     m_timeDebt=0;
}
