/***************************************************************************
 *                                                                         *
 *   AHUTIL.H                                                              *
 *                                                                         *
 *        Copyright 1997, Galacticomm, Inc., All Rights Reserved           *
 *                                                                         *
 *        Utilites for Active HTML Interface                               *
 *                                                                         *
 *                                                - Phil Henning 3/17/97   *
 *                                                  Nathan Osterc          *
 *                                                                         *
 ***************************************************************************/

#ifndef __AHUTIL_H
#define __AHUTIL_H
#include "galacth.h"

CHAR*                               // converted string
Str2Url(                            // convert string to url
CHAR* pszText,                      // text to convert
CHAR *target="\" TARGET = \"_top\">"); // target

CHAR*
EncodeBackSlash(                    // Encodes backslash character
CHAR *str);

CHAR*
UrlLink(                            // Is text a possible URL?
CHAR* pszText);                     // text to check

CHAR *                              // zstring anchor tag
BuildUrlLink(                       // make an anchor tag from psz
CHAR* pszWhole,                     // Pointer to the zstring
CHAR* pszURLStart,                  // Pointer to the url sub zstring
CHAR *target="\" TARGET = \"_top\">"); // default target of href

CHAR*
FindInStr(                          // find substring within string
CHAR* pszText,                      // string to search
CHAR* pszToFind);                   // substring to search for

INT FndUrlLngth(CHAR* psUrl);       // find length of url
VOID AddHttp(CHAR *pszUrl);         // add http:// to front of zstring
GBOOL IsValidUrlChr(CHAR ch);       // is char valid for a url?

CHAR*                               // stripped string
Stp4Html(                           // strip <>"& replace with &gt, etc
CHAR* pszText);                     // string to parse

CHAR* pls2spc (CHAR* stg);          // convert '+' in a stg to ' '
CHAR* spc2pls (CHAR* stg);          // convert ' ' in a stg to '+'

struct usracc *                     // returns usracc (or NULL)
GetAccPtr(                          // Get pointer to users usracc
const CHAR *uid);                   // the uid in question

CHAR *                              // returns cookie value
getCookie(                          // Gets a cookie value (returns NULL if no)
const CHAR *cookieName,             // the CookieName
acthSession *ses);                  // Pointer to current session object

VOID
setCookie(                         // establish a cookie value for the browser
const CHAR *cookieName,            // the cookie name to set
const CHAR *cookieVal,             // value to set in the cookie
const CHAR *expdate,               // Date of expiration (can be NULL)
const CHAR *path,                  // path (can be NULL)
const CHAR *domain,                // domain name (can be NULL)
GBOOL secure,                      // Only transmitted over secure connex?
acthSession *ses);                 // pointer to current session object

INT                                // resulting INT
htoi(                              // Convert hex string to integer
CHAR *hexa);                       // hex string to convert

CHAR*                              // converted string
BackSlash2Percent(                 // change '\' to a '%'
CHAR *str);                        // string to change

CHAR*                              // converted string
Percent2BackSlash(                 // change % to '\'
CHAR *str);                        // string to change


enum BrowserType
{
     BROWSER_NETSCAPE,             // Netscape (any version)
     BROWSER_IE,                   // MS Internet Explorer (any version)
     BROWSER_OTHER                 // other
};

BrowserType                        //   BROWSER_IE, BROWSER_NETSCAPE or BROWSER_OTHER
getClientType(                     // get browser type from User-Agent: header
const CHAR *agentStr);             //   User-Agent: header

INT                                //   browser major version #, or 0
getClientVer(                      // get browser version
const CHAR *agentStr);             //   request User-Agent: header

//  The two functions below were added because if the user is online
//  at the same time as the web-hit occurs, certain GME functios and
//  possibly other functions being called from AH weren't updating the
//  online user's information

VOID
setUserNum4AH(                     // set usrnum=othusn if user is online
const CHAR *uid);                  // the user in question

VOID
resetUserNum4AH(                   // reset usrnum to olduser if valid
const CHAR *uid);                  // the user in question

GBOOL                             // True or false
isURLTemplate(                    // is the template a URL
const CHAR *templStr);            // the template string

const CHAR*                        //   pointer to internal buffer
htmlFormatMessage(                 // format a message to output
const CHAR* msg,                   //   message to format
GBOOL reflow,                      //   should the message be reflowed?
GBOOL plaintext);                  //   suppress HTML formatting

bool
stringInRange(                     // see if given string is in a range
CHAR start,                        // start of range
CHAR end,                          // end of range
const CHAR *checkStr);             // string to check

GBOOL
isReflowChar(                          // is character a reflow char?
CHAR ch);                              // char to check

GBOOL
isQuoteChar(                            // is character a quote char?
const CHAR* ch);                        // char to check

GBOOL
isQuoteLine(                            // is quoted line?
const CHAR* line);                      // line to check

GBOOL
isEOL(                                  // is end-of-line?
CHAR ch);                               // char to check

const CHAR*                        // encoded string
htmlEncodeCh(                      // encode a single character
CHAR ch);                          // character to encode

bool
isProtocol(                        // is string a possible protocol
const CHAR* stg);                  // string to check


#endif // __AHUTIL_H
