// wgmDlg.cpp : implementation file
//

#include "stdafx.h"
#include "wgm.h"
#include "wgmdefs.h"
#include "wgmDlg.h"
#include "SelApp.h"
#include "ModuleInfo.h"
#include "ReadOnly.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define LABEL_PHONE      "Phone number:"
#define LABEL_SERVER     "Server name:"
#define LABEL_DOMAIN     "Domain name:"
#define LABEL_NONE       ""

#define MSG_GALDNS       "GALDNS.MSG"

#define CNF_HOSTNAM      "HOSTNAM"
#define CNF_DOMAIN       "DOMAIN"

extern "C" DllImport CHAR *getRegString(CHAR *string);

CHAR *supfil[NUMSUP]={             // array of installation support files
     "setup.exe",                  //   Windows setup executable
     "setup.ins",                  //   compiled installation script
     "gcomm.bmp",                  //   Gcomm logo for display
     "~ins0762.lib"                //   installation script support file
};

CHAR *fstfil[NUMFST]={             // array of files forced to first disk
     "setup.exe",                  //   Windows setup executable
     "setup.ins",                  //   compiled installation script
     "gcomm.bmp",                  //   Gcomm logo for display
     "wgm.ver",                    //   version info
     "~ins0762.lib",               //   installation script support file
     "disk.1",                     //   first disk id
     "_setup.lst",                 //   list of installation files
     "_winupd.lst",                //   list of files for \windows\system
     "*.ico",                      //   system's .ICO file
     "*.osg"                       //   system's .OSG file
};

CHAR *exp2win[NUMEXP]={            // array of files not in _WINUPD.LST
     "gcsvcman.exe",               //   WGM executable
     "wgmupdat.exe",               //   WGM updater executable
     "npwg32.dll",                 //   32-bit Netscape plug-in .DLL
     "npwg16.dll"                  //   32-bit Netscape plug-in .DLL
};

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
     CAboutDlg();

// Dialog Data
     //{{AFX_DATA(CAboutDlg)
     enum { IDD = IDD_ABOUTBOX };
     //}}AFX_DATA

     // ClassWizard generated virtual function overrides
     //{{AFX_VIRTUAL(CAboutDlg)
     protected:
     virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
     //}}AFX_VIRTUAL

// Implementation
protected:
     //{{AFX_MSG(CAboutDlg)
     //}}AFX_MSG
     DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
     //{{AFX_DATA_INIT(CAboutDlg)
     //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
     CDialog::DoDataExchange(pDX);
     //{{AFX_DATA_MAP(CAboutDlg)
     //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
     //{{AFX_MSG_MAP(CAboutDlg)
          // No message handlers
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()


extern CModuleInfo moduleInfo;

/////////////////////////////////////////////////////////////////////////////
// CWgmDlg dialog

CWgmDlg::CWgmDlg(CWnd* pParent /*=NULL*/)
     : CDialog(CWgmDlg::IDD, pParent)
{
     ssfils=NULL;
     nssfils=0;
     icosiz=0L;
     osgsiz=0L;
     numfil=0;
     numfst=0;
     m_compressStarted = FALSE;
     m_refresh=NULL;
     //{{AFX_DATA_INIT(CWgmDlg)
     m_bldtyp=0;
     m_newusr=0;
     m_conname = _T("");
     m_uid = _T("");
     m_psw = _T("");
     m_sysname = _T("");
     m_bfile = _T("");
     m_drive = 0;
     //}}AFX_DATA_INIT
     GetOldSettings();
     // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
     m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CWgmDlg::~CWgmDlg()
{
     INT i;
     Cffblk fb;

     if (nssfils != 0) {
          for (i=0 ; i < nssfils ; i++) {
               free(ssfils[i]);
          }
          free(ssfils);
     }
     unlink("wgminst" SLS "wgminst.zip");
     rename(spr("%s" SLS "wgminst.zip",INSTMP),"wgminst" SLS "wgminst.zip");
     if (!fnd1st(&fb,"wgminst" SLS "nodel.flg",0)) {
          unlinktree(INSTMP);
     }
}

void CWgmDlg::DoDataExchange(CDataExchange* pDX)
{
     CDialog::DoDataExchange(pDX);
     //{{AFX_DATA_MAP(CWgmDlg)
     DDX_Radio(pDX, IDC_BLDTYP0, m_bldtyp);
     DDX_Radio(pDX, IDC_NEWUSR0, m_newusr);
     DDX_Text(pDX, IDC_CONNAME, m_conname);
     DDV_MaxChars(pDX, m_conname, 43);
     DDX_Text(pDX, IDC_UIDEDIT, m_uid);
     DDV_MaxChars(pDX, m_uid, 29);
     DDX_Text(pDX, IDC_PASSEDIT, m_psw);
     DDV_MaxChars(pDX, m_psw, 9);
     DDX_Text(pDX, IDC_SYSLABEL, m_sysname);
     DDV_MaxChars(pDX, m_sysname, 43);
     DDX_Text(pDX, IDC_EFNAME, m_bfile);
     DDV_MaxChars(pDX, m_bfile, 8);
     DDX_Radio(pDX, IDC_ADRIVE, m_drive);
     //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWgmDlg, CDialog)
     //{{AFX_MSG_MAP(CWgmDlg)
     ON_WM_SYSCOMMAND()
     ON_WM_DESTROY()
     ON_WM_PAINT()
     ON_WM_QUERYDRAGICON()
     ON_MESSAGE(WM_THREADFINISHED,OnThreadFinished)
     ON_BN_CLICKED(IDC_SELAPPS, OnSelapps)
     ON_CBN_SELCHANGE(IDC_CONNECT, OnSelchangeConnect)
     ON_BN_CLICKED(IDC_NEWUSR0, OnNewusr0)
     ON_BN_CLICKED(IDC_NEWUSR1, OnNewusr1)
     ON_BN_CLICKED(IDC_BLDTYP0, OnBldtyp0)
     ON_BN_CLICKED(IDC_BLDTYP1, OnBldtyp1)
     ON_BN_CLICKED(IDC_NEWUSR2, OnNewusr2)
     ON_WM_CLOSE()
     ON_BN_CLICKED(IDCANCELWGM, OnCancelwgm)
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWgmDlg message handlers

BOOL CWgmDlg::OnInitDialog()
{
     CDialog::OnInitDialog();

     // Add "About..." menu item to system menu.

     // IDM_ABOUTBOX must be in the system command range.
     ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
     ASSERT(IDM_ABOUTBOX < 0xF000);

     CMenu* pSysMenu = GetSystemMenu(FALSE);
     CString strAboutMenu;
     strAboutMenu.LoadString(IDS_ABOUTBOX);
     if (!strAboutMenu.IsEmpty())
     {
          pSysMenu->AppendMenu(MF_SEPARATOR);
          pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
     }

     // Set the icon for this dialog.  The framework does this automatically
     //  when the application's main window is not a dialog
     SetIcon(m_hIcon, TRUE);            // Set big icon
     SetIcon(m_hIcon, FALSE);      // Set small icon

     SetupDialog();

     return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWgmDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
     if ((nID & 0xFFF0) == IDM_ABOUTBOX)
     {
          CAboutDlg dlgAbout;
          dlgAbout.DoModal();
     }
     else
     {
          CDialog::OnSysCommand(nID, lParam);
     }
}

void CWgmDlg::OnDestroy()
{
     WinHelp(0L, HELP_QUIT);
     CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWgmDlg::OnPaint()
{
     if (IsIconic())
     {
          CPaintDC dc(this); // device context for painting

          SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

          // Center icon in client rectangle
          int cxIcon = GetSystemMetrics(SM_CXICON);
          int cyIcon = GetSystemMetrics(SM_CYICON);
          CRect rect;
          GetClientRect(&rect);
          int x = (rect.Width() - cxIcon + 1) / 2;
          int y = (rect.Height() - cyIcon + 1) / 2;

          // Draw the icon
          dc.DrawIcon(x, y, m_hIcon);
     }
     else
     {
          CDialog::OnPaint();
     }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWgmDlg::OnQueryDragIcon()
{
     return (HCURSOR) m_hIcon;
}

LONG CWgmDlg::OnThreadFinished(UINT nThread, LONG lParam)
{
     switch(nThread) {
     case THREAD_GETINFO:
          break;
     case THREAD_MAKEDISK:
          break;
     case THREAD_MAKEFILE:
          break;
     default:
          break;
     }
     return(0);
}

void CWgmDlg::OnSelapps()
{
     CSelApp sdlg;

     sdlg.DoModal();
}

VOID CWgmDlg::InitData(VOID)
{
     CHAR *ptr;
     CHAR *opval;
     CHAR regno[REGSIZ];
     Cffblk icofb;

     if (getRegString(regno) != NULL) {
          stlcpy(regnum,regno,REGSIZ);
     }

     if ((ptr=mstscan("bbsmainm.msg","aboutico",FILSIZ)) != NULL) {
          if (fnd1st(&icofb,spr("wgsicons" SLS "%s",ptr),0)) {
               stlcpy(icofil,ptr,FILSIZ);
          }
          else {
               icofil[0]='\0';
          }
     }
     else {
          icofil[0]='\0';
     }
     m_bfile=m_wgmrec.winfnm;
     m_sysname=m_wgmrec.sysnam;
     if (strlen(m_wgmrec.dmnnam) == 0) {
          opval=mstscan(MSG_GALDNS,CNF_HOSTNAM,18);
          if (opval != NULL) {
               stlcpy(m_wgmrec.dmnnam,opval,44);
               stlcat(m_wgmrec.dmnnam,".",44);
          }
          opval=mstscan(MSG_GALDNS,CNF_DOMAIN,27);
          if (opval != NULL) {
               stlcat(m_wgmrec.dmnnam,opval,44);
          }
     }
     switch(m_wgmrec.conmth) {
     case CONNECT_MODEM:
          m_conname=m_wgmrec.syspho;
          break;
     case CONNECT_SERIAL:
          break;
     case CONNECT_LAN:
          m_conname=m_wgmrec.srvnam;
          break;
     case CONNECT_TCPIP:
          m_conname=m_wgmrec.dmnnam;
          break;
     default:
          m_wgmrec.conmth=CONNECT_TCPIP;
          m_conname="";
          break;
     }
     m_bldtyp=((m_wgmrec.bldwht == BUILD_DISK) ? 0 : 1);
     m_newusr=((m_wgmrec.newusr > 0) ? 1 : 0);
}

void CWgmDlg::SetupDialog(VOID)
{
     static CHAR *contypes[4]={
          "Dial-up Modem","Direct Serial Cable","Novell SPX","TCP/IP Telnet"
     };

     CComboBox* pcbox=(CComboBox *)GetDlgItem(IDC_CONNECT);
     for (int i=0 ; i < MAX_CONMETH ; i++) {
          pcbox->AddString(contypes[i]);
     }
     SetDlgItemText(IDC_REGNO,regnum);
     pcbox->SetCurSel(m_wgmrec.conmth);
     switch(m_wgmrec.conmth) {
     case CONNECT_MODEM:
          SetDlgItemText(IDC_CNCTEXT,LABEL_PHONE);
          SetDlgItemText(IDC_CONNAME,m_wgmrec.syspho);
          break;
     case CONNECT_SERIAL:
          SetDlgItemText(IDC_CNCTEXT,LABEL_NONE);
          SetDlgItemText(IDC_CONNAME,LABEL_NONE);
          break;
     case CONNECT_LAN:
          SetDlgItemText(IDC_CNCTEXT,LABEL_SERVER);
          SetDlgItemText(IDC_CONNAME,m_wgmrec.srvnam);
          break;
     case CONNECT_TCPIP:
          SetDlgItemText(IDC_CNCTEXT,LABEL_DOMAIN);
          SetDlgItemText(IDC_CONNAME,m_wgmrec.dmnnam);
          break;
     default:
          SetDlgItemText(IDC_CNCTEXT,LABEL_DOMAIN);
          SetDlgItemText(IDC_CONNAME,LABEL_NONE);
          break;
     }
     OnBldtyp0();
     OnNewusr0();
}

void CWgmDlg::OnSelchangeConnect()
{
     SHORT item;
     CComboBox* pcbox=(CComboBox *)GetDlgItem(IDC_CONNECT);

     UpdateData();
     if (m_wgmrec.conmth != CONNECT_SERIAL) {
          switch(m_wgmrec.conmth) {
          case CONNECT_MODEM:
               stlcpy(m_wgmrec.syspho,(LPCTSTR)m_conname,PHOSIZ);
               break;
          case CONNECT_LAN:
               stlcpy(m_wgmrec.srvnam,(LPCTSTR)m_conname,SRVSIZ);
               break;
          case CONNECT_TCPIP:
               stlcpy(m_wgmrec.dmnnam,(LPCTSTR)m_conname,DMNSIZ);
               break;
          }
     }
     item=(SHORT)pcbox->GetCurSel();
     switch(item) {
     case CONNECT_MODEM:
          SetDlgItemText(IDC_CNCTEXT,LABEL_PHONE);
          SetDlgItemText(IDC_CONNAME,m_wgmrec.syspho);
          break;
     case CONNECT_SERIAL:
          ShowConnectionFields(FALSE);
          break;
     case CONNECT_LAN:
          SetDlgItemText(IDC_CNCTEXT,LABEL_SERVER);
          SetDlgItemText(IDC_CONNAME,m_wgmrec.srvnam);
          break;
     case CONNECT_TCPIP:
          SetDlgItemText(IDC_CNCTEXT,LABEL_DOMAIN);
          SetDlgItemText(IDC_CONNAME,m_wgmrec.dmnnam);
          break;
     default:
          SetDlgItemText(IDC_CNCTEXT,LABEL_DOMAIN);
          SetDlgItemText(IDC_CONNAME,LABEL_NONE);
          break;
     }
     if ((item < 0) || (item >= MAX_CONMETH)) {
          m_wgmrec.conmth=CONNECT_TCPIP;
     }
     else {
          m_wgmrec.conmth=item;
     }
     ShowConnectionFields((m_wgmrec.conmth != CONNECT_SERIAL));
}

void CWgmDlg::EnableUserFields(BOOL bEnabled)
{
     (CStatic *)GetDlgItem(IDC_UID)->EnableWindow(bEnabled);
     (CStatic *)GetDlgItem(IDC_PASS)->EnableWindow(bEnabled);
     (CEdit *)GetDlgItem(IDC_UIDEDIT)->EnableWindow(bEnabled);
     (CEdit *)GetDlgItem(IDC_PASSEDIT)->EnableWindow(bEnabled);
}

void CWgmDlg::ShowConnectionFields(BOOL bEnabled)
{
     INT iState;

     iState=(bEnabled ? SW_SHOWNORMAL : SW_HIDE);
     (CStatic *)GetDlgItem(IDC_CNCTEXT)->ShowWindow(iState);
     (CEdit *)GetDlgItem(IDC_CONNAME)->ShowWindow(iState);
}

void CWgmDlg::OnNewusr0()
{
     UpdateData();
     EnableUserFields((m_newusr == 2));
}

void CWgmDlg::OnNewusr1()
{
     OnNewusr0();
}

void CWgmDlg::OnNewusr2()
{
     OnNewusr0();
}

void CWgmDlg::EnableFilenameFields(BOOL bEnabled)
{
     (CStatic *)GetDlgItem(IDC_SFNAME)->EnableWindow(bEnabled);
     (CEdit *)GetDlgItem(IDC_EFNAME)->EnableWindow(bEnabled);
     (CStatic *)GetDlgItem(IDC_SDRIVE)->EnableWindow(!bEnabled);
     (CButton *)GetDlgItem(IDC_ADRIVE)->EnableWindow(!bEnabled);
     (CButton *)GetDlgItem(IDC_BDRIVE)->EnableWindow(!bEnabled);
}

void CWgmDlg::OnBldtyp0()
{
     UpdateData();
     EnableFilenameFields((m_bldtyp == 1));
}

void CWgmDlg::OnBldtyp1()
{
     OnBldtyp0();
}

void CWgmDlg::OnOK()
{
     INT i;
     FILE *modlsfp;
     FILE *savfp;

     DisableControls();

     UpdateData();
     m_wgmrec.newusr=((m_newusr > 0) ? 1 : 0);
     if (m_newusr < 2) {
          m_wgmrec.lognam[0]='\0';
          m_wgmrec.logpsw[0]='\0';
     }
     else {
          stlcpy(m_wgmrec.lognam,(LPCTSTR)m_uid,UIDSIZ);
          stlcpy(m_wgmrec.logpsw,(LPCTSTR)m_psw,PSWSIZ);
     }
     stlcpy(m_wgmrec.sysnam,(LPCTSTR)m_sysname,NAMSIZ);
     switch(m_wgmrec.conmth) {
     case CONNECT_MODEM:
          stlcpy(m_wgmrec.syspho,m_conname,PHOSIZ);
          break;
     case CONNECT_SERIAL:
          break;
     case CONNECT_LAN:
          stlcpy(m_wgmrec.srvnam,m_conname,SRVSIZ);
          break;
     case CONNECT_TCPIP:
          stlcpy(m_wgmrec.dmnnam,m_conname,DMNSIZ);
          break;
     default:
          break;
     }     
     m_wgmrec.bldwht=((m_bldtyp == 0) ? BUILD_DISK : BUILD_FILE);
     if (m_wgmrec.bldwht == BUILD_FILE) {
          stlcpy(m_wgmrec.winfnm,(LPCTSTR)m_bfile,GCMAXFILE+1);
     }
     if (!CheckData()) {
          EnableControls();
          return;
     }
     if ((savfp=fopen(SAVFIL,FOPWB)) == NULL) {
          catastro("WGMDWN: Error opening wgsmkwgm.sav for output!");
     }
     if (fwrite(&m_wgmrec,sizeof(osminf),1,savfp) != 1) {
          catastro("WGMDWN: Error updating wgsmkwgm.sav!");
     }
     fclose(savfp);
     if ((modlsfp=fopen(MODLSFIL,FOPWA)) == NULL) {
          catastro(spr("Error writing to %s!",MODLSFIL));
     }
     for (i=0 ; i < moduleInfo.modcnt ; i++) {
          if (moduleInfo.selmods[i]) {
               fprintf(modlsfp,"%s\n",moduleInfo.modarray[i].mdfnam);
          }
     }
     fclose(modlsfp);
     DoCompress();
     m_compressStarted = TRUE;
}

BOOL CWgmDlg::CheckData(VOID)
{
     CHAR *ptst;

     // Make sure we have a system Icon name
     if (strlen(m_wgmrec.sysnam) > 0) {
          ptst=m_wgmrec.sysnam;
          while (*ptst != '\0') {
               if (!((*ptst >= 32) && (*ptst < 127))) {
                    AfxMessageBox(IDS_BADSYSNAM);
                    return(FALSE);
               }
               ptst++;
          }
     }
     else {
          AfxMessageBox(IDS_BADSYSNAM);
          return(FALSE);
     }
     switch(m_wgmrec.conmth) {
     case CONNECT_MODEM:
          if (strlen(m_wgmrec.syspho) > 0) {
               ptst=m_wgmrec.syspho;
               while (*ptst != '\0') {
                    if (((*ptst < '0') || (*ptst > '9'))
                      && (*ptst != '-')
                      && (*ptst != '(')
                      && (*ptst != ')')
                      && (*ptst != ',')
                      && (*ptst != ' ')) {
                         AfxMessageBox(IDS_BADPHONUM);
                         return(FALSE);
                    }
                    ptst++;
               }
          }
          else {
               AfxMessageBox(IDS_BADPHONUM);
               return(FALSE);
          }
          break;
     case CONNECT_SERIAL:
          break;
     case CONNECT_LAN:
          if (strlen(m_wgmrec.srvnam) > 0) {
               ptst=m_wgmrec.srvnam;
               while (*ptst != '\0') {
                    if (!((*ptst >= 32) && (*ptst < 127))) {
                         AfxMessageBox(IDS_BADSRVNAM);
                         return(FALSE);
                    }
                    ptst++;
               }
          }
          else {
               AfxMessageBox(IDS_BADSRVNAM);
               return(FALSE);
          }
          break;
     case CONNECT_TCPIP:
          if (strlen(m_wgmrec.dmnnam) > 0) {
               ptst=m_wgmrec.dmnnam;
               while (*ptst != '\0') {
                    if (!((*ptst >= 32) && (*ptst < 127))) {
                         AfxMessageBox(IDS_BADDMNNAM);
                         return(FALSE);
                    }
                    ptst++;
               }
          }
          else {
               AfxMessageBox(IDS_BADDMNNAM);
               return(FALSE);
          }
          break;
     default:
          AfxMessageBox(IDS_BADCONMETH);
          return(FALSE);
          break;
     }
     if (m_newusr == 2) {
          if (strlen(m_wgmrec.lognam) > 0) {
               ptst=m_wgmrec.lognam;
               while (*ptst != '\0') {
                    if (!isuidc(*ptst)) {
                         AfxMessageBox(IDS_BADLOGNAM);
                         return(FALSE);
                    }
                    ptst++;
               }
          }
          else {
               AfxMessageBox(IDS_BADLOGNAM);
               return(FALSE);
          }
          if (strlen(m_wgmrec.logpsw) > 0) {
               ptst=m_wgmrec.logpsw;
               while (*ptst != '\0') {
                    if (!((*ptst <= 255) && (isalnum(*ptst) || ispunct(*ptst)))) {
                         AfxMessageBox(IDS_BADLOGPSW);
                         return(FALSE);
                    }
                    ptst++;
               }
          }
          else {
               AfxMessageBox(IDS_BADLOGPSW);
               return(FALSE);
          }
     }
     if (m_wgmrec.bldwht == BUILD_FILE) {
          if (strlen(m_wgmrec.winfnm) > 0) {
               ptst=m_wgmrec.winfnm;
               while (*ptst != '\0') {
                    if (!(isvalfc(*ptst) && *ptst != '.' && *ptst != ' ')) {
                         AfxMessageBox(IDS_BADWINFNM);
                         return(FALSE);
                    }
                    ptst++;
               }
          }
          else {
               AfxMessageBox(IDS_BADWINFNM);
               return(FALSE);
          }
     }
     return(TRUE);
}

BOOL CWgmDlg::isuidc(CHAR c)
{
     return(((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z')
          || (c == '.' || c == ' ' || c == ',' || c == '-' || c == '_')
          || (c == '\'') || (c >= '0' && c <= '9') || (c >= '\x80' && c <= '\xA5')
          || (c >= '\xE0' && c <= '\xEF')) ? TRUE : FALSE);
}

VOID CWgmDlg::DoCompress(VOID)
{
     INT i;
     INT j;
     INT nasfils;
     INT ninc=0;
     FILE *fp;
     FILE *wupdfp;
     CHAR appid[AIDSIZ];
     CHAR incdir[GCMAXPTH];
     CHAR filbuf[GCMAXFNM];
     CHAR **incmdfs=NULL;
     GBOOL inwgm;
     GBOOL isexp;
     GBOOL hasshr;
     GBOOL included;
     GBOOL addedft=FALSE;
     struct modinf *csrec;
     Cffblk fb;

     m_cmpobj.SetMinimize(TRUE);
     m_cmpobj.SetUpdateWindow((CDialog *)this);
     unlinktree(INSTMP);
     if (MKDIR(INSTMP) != 0) {
          catastro("Unable to create temporary directory %s!",INSTMP);
     }
     for (i=0 ; i < NUMSUP ; i++) {          // copy installation support files
          cpyfil("wgminst",supfil[i]);
     }
     if (tfsopn(MODLSFIL) == 1) {      // get incmdfs[] ready
          incmdfs=(CHAR **)alczer(moduleInfo.modcnt*sizeof(CHAR *));
          while (tfsrdl() != TFSDUN) {
               if (tfstate == TFSLIN) {
                    incmdfs[ninc]=(CHAR *)alczer(GCMAXFNM);
                    stlcpy(incmdfs[ninc],tfsbuf,GCMAXFNM);
                    ninc++;
               }
          }
     }
     for (i=0 ; i < moduleInfo.modcnt ; i++) {
          csrec=&moduleInfo.modarray[i];
          for (j=0,included=FALSE ; j < ninc ; j++) {
               if (sameas(csrec->mdfnam,incmdfs[j])) {
                    included=TRUE;
                    break;
               }
          }
          if (included) {
               fileparts(GCPART_FILE,csrec->mdfnam,appid,AIDSIZ);
               m_cmpobj.CompressFile(appid,csrec->ncsexe,TRUE);
               if (csrec->supfils != NULL) {
                    nasfils=itemcntd(csrec->supfils," ");
                    for (j=0 ; j < nasfils ; j++) {
                         m_cmpobj.CompressFile(appid,itemidxd(csrec->supfils,j," "),TRUE);
                    }
               }
          }
     }
     if (tfsopn("gcsvcman\\gcsvcman.lst") != 1) {
          catastro("SUPINS: error opening gcsvcman.lst!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN) {
               if (!sameas(tfsbuf,"wgm.ver")) {
                    m_cmpobj.CompressFile("gcsvcman",tfsbuf,FALSE);
                    if (samend(tfsbuf,".dll") || samend(tfsbuf,".vbx")
                     || samend(tfsbuf,".exe")) {
                         isexp=FALSE;
                         for (i=0 ; i < NUMEXP ; i++) {
                              if (sameas(tfsbuf,exp2win[i])) {
                                   isexp=TRUE;
                                   break;
                              }
                         }
                         if (!isexp) {
                              add2ss(tfsbuf);
                         }
                    }
               }
               else {
                    cpyfil("gcsvcman",tfsbuf);
               }
          }
     }
     for (i=0 ; i < ninc ; i++) {
          if (tfsopn(incmdfs[i]) != 1) {
               catastro("DOBLD: error opening %s!",incmdfs[i]);
          }
          hasshr=FALSE;
          while (tfsrdl() != TFSDUN) {
               if (tfstate == TFSLIN) {
                    if (sameto("Shared support files:",tfsbuf)) {
                         hasshr=TRUE;
                         tfsabt();
                    }
               }
          }
          if (hasshr) {
               if (tfsopn(incmdfs[i]) != 1) {
                    catastro("DOBLD: error opening %s for processing!",
                             incmdfs[i]);
               }
               while (tfsrdl() != TFSDUN) {
                    if (tfstate == TFSLIN) {
                         if (tfspfx("Shared support files:")) {
                              unpad(tfspst);
                              add2ss(tfspst);
                         }
                    }
               }
          }
          else {
               if (!addedft) {
                    add2ss(OLDSSFLS);
                    addedft=TRUE;
               }
          }
     }
     if ((wupdfp=fopen(spr("%s\\_winupd.lst",INSTMP),FOPWA)) == NULL) {
          catastro("Error opening _winupd.lst for output!");
     }
     if ((fp=fopen("gcsvcman\\gcsvcman.lst",FOPRA)) == NULL) {
          catastro("SUPINSTMP: error opening gcsvcman.lst!");
     }
     for (i=0 ; i < nssfils ; i++) {
          inwgm=FALSE;
          rewind(fp);
          while (fgets(filbuf,GCMAXFNM,fp) != NULL) {
               unpad(filbuf);
               if (sameas(filbuf,ssfils[i])) {
                    inwgm=TRUE;
                    break;
               }
          }
          if (!inwgm) {
               m_cmpobj.CompressFile("galssf",ssfils[i],FALSE);
          }
          fprintf(wupdfp,"%s\n",ssfils[i]);
     }
     fclose(fp);
     m_cmpobj.CompressFile("wgminst","readme.wri",FALSE);
     fclose(wupdfp);
     if (incmdfs != NULL) {
          for (i=0 ; i < ninc ; i++) {
               free(incmdfs[i]);
          }
          free(incmdfs);
     }
     stlcpy(incdir,spr("wgminst\\%s",INCDIR),GCMAXPTH);
     if (fnd1st(&fb,spr("%s\\*.*",incdir),0)) {
          do {
               if (!sameas(fb.ff_name,INCFIL)) {
                    cpyfil(incdir,fb.ff_name);
               }
          } while (fndnxt(&fb));
     }
     makosg();
     makico();
}


void CWgmDlg::DoBuild()
{
     CHAR winexe[GCMAXFNM];
     FILE *fp=NULL;
     Cffblk fb;
     CString cmdlin;

     gendsk1();
     m_shell.SetUpdateWindow((CDialog *)this);
     if (m_wgmrec.bldwht == BUILD_FILE) {       // put it all together
          unpad(m_wgmrec.winfnm);
          sprintf(winexe,"%s.exe",m_wgmrec.winfnm);
          fnmcse(winexe);
          // display name of file being made (winexe)
          lastfil(NODRIVE);
          if ((fp=fopen(spr("%s\\_setup.lst",INSTMP),FOPWA)) == NULL) {
               catastro("Error opening _setup.lst for output!");
          }
          if (!fnd1st(&fb,spr("%s\\*.*",INSTMP),0)) {
               catastro("Error generating _setup.lst - no files found!");
          }
          do {
               fprintf(fp,"%s\n",fb.ff_name);
          } while (fndnxt(&fb));
          fprintf(fp,"wgminst.exe\n");
          fclose(fp);
          UpdateWindow();
          m_refresh=(CDialog *)this;
          m_cmpobj.Zip(INSTMP "\\wgminst", INSTMP "\\*.*");
     }
     else {
          if ((fp=fopen(spr("%s\\_setup.lst",INSTMP),FOPWA)) == NULL) {
               catastro("DoBuild(): Could not open _setup.lst for output.");
          }
          if (!fnd1st(&fb,spr("%s\\*.*",INSTMP),0)) {
               catastro("DoBuild(): Could not generate _setup.lst - no files to process.");
          }
          do {
               if (!(sameas(fb.ff_name,"wgm.ver")
                  || sameas(fb.ff_name,"setup.exe")
                  || sameas(fb.ff_name,"setup.ins")
                  || sameas(fb.ff_name,"gcomm.bmp")
                  || sameas(fb.ff_name,"_winupd.lst")
                  || sameas(fb.ff_name,"_setup.lst")
                  || sameas(fb.ff_name,"disk.1")
                  || samend(fb.ff_name,"*.ico")
                  || samend(fb.ff_name,"*.osg"))) {
                    fprintf(fp,"%s\n",fb.ff_name);
               }
          } while (fndnxt(&fb));
          fclose(fp);
          getlsts();
     }
}

VOID CWgmDlg::cpyfil(const CHAR *srcdir,const CHAR *srcfil)
{
     CWaitCursor wait;
     UpdateWindow();
     if (!CopyFile(spr("%s\\%s",srcdir,srcfil),spr("%s\\%s",INSTMP,srcfil),FALSE)) {
          catastro(spr("cpyfil(): Could not copy file: %s",srcfil));
     }
}

VOID CWgmDlg::add2ss(const CHAR *fils2add)
{
     INT ninstg,i,j;
     GBOOL alrdyin,fsttok;
     CHAR *curfil,*filstg,*tokptr;

     filstg=(CHAR *)alczer(strlen(fils2add)+1);
     tokptr=strtok((CHAR *)fils2add,DELIMS);
     fsttok=TRUE;
     do {
          if (!fsttok) {
               strcat(filstg," ");
          }
          else {
               fsttok=FALSE;
          }
          strcat(filstg,tokptr);
     } while ((tokptr=strtok(NULL,DELIMS)) != NULL);
     ninstg=itemcntd(filstg," ");
     if (nssfils == 0) {
          ssfils=(CHAR **)alczer(ninstg*sizeof(CHAR *));
          for (i=0 ; i < ninstg ; i++) {
               ssfils[i]=(CHAR *)alczer(GCMAXFNM);
               stlcpy(ssfils[i],itemidxd(filstg,i," "),GCMAXFNM);
          }
          nssfils=ninstg;
     }
     else {
          for (i=0 ; i < ninstg ; i++) {
               curfil=itemidxd(filstg,i," ");
               for (j=0,alrdyin=FALSE ; j < nssfils ; j++) {
                    if (sameas(curfil,ssfils[j])) {
                         alrdyin=TRUE;
                         break;
                    }
               }
               if (!alrdyin) {
                    ssfils=(CHAR **)alcrsz(ssfils,nssfils*sizeof(CHAR *),
                                           (nssfils+1)*sizeof(CHAR *));
                    ssfils[nssfils]=(CHAR *)alczer(GCMAXFNM);
                    stlcpy(ssfils[nssfils],curfil,GCMAXFNM);
                    nssfils++;
               }
          }
     }
     free(filstg);
}


VOID CWgmDlg::makosg(VOID)
{
     CHAR osgfil[FILSIZ];
     FILE *osgfp;
     Cffblk fb;

     stlcpy(osgfil,spr("%s.osg",regnum),FILSIZ);
     if ((osgfp=fopen(spr("%s\\%s",INSTMP,osgfil),FOPWA)) == NULL) {
          catastro("Error opening OSG file for output.");
     }
     fprintf(osgfp,"0\n");
     fprintf(osgfp,"-1\n");
     fprintf(osgfp,"330\n");
     fprintf(osgfp,"75\n");
     kilwht(m_wgmrec.sysnam);
     fprintf(osgfp,"%s\n",m_wgmrec.sysnam);
     switch (m_wgmrec.conmth) {
     case CONNECT_MODEM:
          fprintf(osgfp,"%s\n",m_wgmrec.syspho);
          break;
     case CONNECT_LAN:
          fprintf(osgfp,"%s\n",m_wgmrec.srvnam);
          break;
     case CONNECT_TCPIP:
          fprintf(osgfp,"%s\n",m_wgmrec.dmnnam);
          break;
     case CONNECT_SERIAL:
          fprintf(osgfp,"\n");
          break;
     }
     switch (m_wgmrec.newusr) {
     case 0:
          fprintf(osgfp,"%c\n\n",1);
          break;
     default:
          fprintf(osgfp,"%s\n%s\n",m_wgmrec.lognam,m_wgmrec.logpsw);
          break;
     }
     fprintf(osgfp,"%s\n",rnosid(regnum));
     fprintf(osgfp,"60\n");
     fprintf(osgfp,"10\n");
     fprintf(osgfp,"%d\n",FLGNXT+FLGICO+FLGACN+invser()+FLGSCS+FLGSAN+teltyp());
     fclose(osgfp);
     if (fnd1st(&fb,spr("%s\\%s",INSTMP,osgfil),0)) {
          osgsiz=fb.ff_fsize;
     }
}

VOID CWgmDlg::makico(VOID)
{
     Cffblk foo;
     CHAR cmdlin[80];
     CHAR newico[FILSIZ];

     stlcpy(newico,regnum,FILSIZ);
     stlcat(newico,".ico",FILSIZ);
     if (icofil[0] != '\0' && fnd1st(&foo,spr("%s\\%s",ICODIR,icofil),0)) {
          icosiz=foo.ff_fsize;
     }
     if (icofil[0] != '\0') {
          sprintf(cmdlin,"copy %s\\%s %s\\%s > nul",
                  ICODIR,icofil,INSTMP,newico);
          if (system(cmdlin) == -1) {
               catastro(spr("Copy error=%d, file=%s",errno,icofil));
          }
     }
}

VOID CWgmDlg::gendsk1(VOID)
{
     LONG icosiz;
     LONG osgsiz;
     LONG cmpsiz=0L;
     FILE *dfp;

     if ((dfp=fopen(spr("%s" SLS "disk.1",INSTMP),FOPWA)) == NULL) {
          catastro("GENDSK1: Error opening disk.1!");
     }
     cntdir(spr("%s\\*.??_",INSTMP));
     cmpsiz=cmpsiz+numbyts;
     cntdir(spr("%s\\*.ico",INSTMP));
     cmpsiz+=numbyts;
     icosiz=numbyts;
     cntdir(spr("%s\\*.osg",INSTMP));
     cmpsiz+=numbyts;
     osgsiz=numbyts;
     fprintf(dfp,"%ld\n",cmpsiz);
     fprintf(dfp,"%ld\n",icosiz+osgsiz);
     fclose(dfp);
}

VOID CWgmDlg::lastfil(INT drvnum)
{
     CHAR fileis[FILSIZ2];
     FILE *dfp;

     if (m_wgmrec.bldwht == BUILD_DISK) {
          stlcpy(fileis,"A:\\lastdisk.flg",FILSIZ2);
          fileis[0]='A'+(drvnum-1);
          if ((dfp=fopen(fileis,FOPWA)) == NULL) {
               catastro(spr("Open error, lst %s",fileis));
          }
          fprintf(dfp,"\x01");
          fclose(dfp);
     }
     else {
          stlcpy(fileis,"lastdisk.flg",FILSIZ);
          if ((dfp=fopen(spr("%s\\%s",INSTMP,fileis),FOPWB)) == NULL) {
               catastro(spr("LASTFIL: Error opening %s!",fileis));
          }
          fclose(dfp);
     }
}

VOID CWgmDlg::getlsts(VOID)
{
     INT i;
     Cffblk fb;
     GBOOL infst;
     GBOOL addit;
     GBOOL bomb;

     fstlst=(struct filary *)alczer(NUMFST*sizeof(struct filary));
     for (i=0,fstptr=fstlst ; i < NUMFST ; i++) {
          addit=TRUE;
          if (!fnd1st(&fb,spr("%s\\%s",INSTMP,fstfil[i]),0)) {
               if (!sameas(fstfil[i],"*.ico")) {
                    bomb=TRUE;
               }
               else {
                    if (icofil[0] == '\0') {
                         bomb=FALSE;
                         addit=FALSE;
                    }
                    else {
                         bomb=TRUE;
                    }
               }
               if (bomb) {
                    catastro("GETLSTS: unable to find %s!",fstfil[i]);
               }
          }
          if (addit) {
               stlcpy(fstptr->filnam,fb.ff_name,FILSIZ);
               fstptr->fsize=fb.ff_fsize;
               fstptr->asize=fb.ff_fsize;
               fstptr->flag=0;
               fstptr++;
               numfst++;
          }
     }
     cntdir(spr("%s\\*.*",INSTMP));
     fillst=(struct filary *)alczer(((INT)numfils-numfst)*sizeof(struct filary));
     if (!(fnd1st(&fb,spr("%s\\*.*",INSTMP),0))) {
          catastro("GETLSTS: error generating fillst - no files found!");
     }
     filptr=fillst;
     numfil=0;
     do {
          for (i=0,infst=FALSE ; i < numfst ; i++) {
               if (sameas(fb.ff_name,fstlst[i].filnam)) {
                    infst=TRUE;
                    break;
               }
          }
          if (!infst) {
               stlcpy(filptr->filnam,fb.ff_name,FILSIZ);
               filptr->fsize=fb.ff_fsize;
               filptr->asize=fb.ff_fsize;
               filptr->flag=0;
               filptr++;
               numfil++;
          }
     } while (fndnxt(&fb));
     if (m_drive == 0) {
          fildsk(ADRIVE);
     }
     else {
          fildsk(BDRIVE);
     }
}

VOID CWgmDlg::kilwht(CHAR *str)
{
     INT i,cnt;

     i=strlen(str);
     for (cnt=i-1 ; cnt > 0 ; cnt--) {
          if (str[cnt] == ' ' || str[cnt] == '\n' || str[cnt] == '\r') {
               str[cnt]='\0';
          }
          else {
               break;
          }
     }
}

INT CWgmDlg::invser(VOID)
{
     INT retval;

     switch (m_wgmrec.conmth) {
     case CONNECT_SERIAL:
     case CONNECT_MODEM:
          retval=FLGSER;
          break;
     default:
          retval=0;
          break;
     }
     return(retval);
}

INT CWgmDlg::teltyp(VOID)
{
     INT retval;

     switch (m_wgmrec.conmth) {
     case CONNECT_TCPIP:
          retval=FLGIP;
          break;
     default:
          retval=0;
          break;
     }
     return(retval);
}

CHAR * CWgmDlg::rnosid(CHAR *regno)
{
     INT i;
     static CHAR retval[SIDSIZ];

     for (i=0 ; i < SIDSIZ-1 ; i++) {
          retval[i]=(((regno[i*2]-'0')*10+regno[i*2+1]-'0')|0x80);
     }
     return(retval);
}

VOID CWgmDlg::fildsk(INT drvnum)
{
     INT dskcnt,done,stat;
     LONG dsksiz,adjsiz;
     CHAR filenam[FILSIZ];
     CHAR ntext[256];

     dskcnt=1;
     adjsiz=0L;
     done=FALSE;
     srtlst();
     sprintf(ntext,"Please Insert Worldgroup Manager Client Disk #%d",dskcnt);
     if ((AfxMessageBox(ntext,MB_ICONWARNING|MB_OKCANCEL) == IDCANCEL)
       || !chkdrv(drvnum)) {
          free(fstlst);
          free(fillst);
          ::PostQuitMessage(0);
          return;
     }
     adjlst(clsize(drvnum == 1 ? "A:" : "B:"));
     todsk(FST,drvnum);
     dsksiz=getdfre(drvnum)-512L;
     CString   caption;
     caption.Format( "Building Client Disk #%i...", dskcnt );
     SetWindowText( caption );
     UpdateWindow();

     while (!done) {
          stat=getfil(filenam,&adjsiz,dsksiz);
          if (stat == GOTFILE) {
               dodsk(filenam,drvnum);
               dsksiz=getdfre(drvnum)-512L;
          }
          else if (stat == NEWDISK) {
               SetWindowText( "Worldgroup Manager Packaging Utility" );
               dskcnt++;
               sprintf(ntext,"Please Insert Worldgroup Manager Client Disk #%d",dskcnt);
               if (AfxMessageBox(ntext,MB_ICONWARNING|MB_OKCANCEL) == IDCANCEL) {
                    break;
               }
               if (!chkdrv(drvnum)) {
                    break;
               }
               caption.Format( "Building Client Disk #%i...", dskcnt );
               SetWindowText( caption );
               UpdateWindow();
               dsksiz=getdfre(drvnum)-512L;
               dsknum(drvnum,dskcnt);
               stat=getfil(filenam,&adjsiz,dsksiz);
               if (stat == GOTFILE) {
                    dodsk(filenam,drvnum);
                    dsksiz=getdfre(drvnum)-512L;
               }
               else if (stat == NEWDISK) {
                    catastro(spr("File too large! %s",filenam));
               }
          }
          if (stat == ALLDONE) {
               lastfil(drvnum);
               SetWindowText( "Worldgroup Manager Packaging Utility" );
               UpdateWindow();
               done=TRUE;
          }
     }
     free(fstlst);
     free(fillst);
     ::PostQuitMessage(0);
}

VOID CWgmDlg::srtlst(VOID)
{
     LONG tmpsiz;
     LONG tmpasiz;
     INT gap,i,j;
     INT tmpflag;
     CHAR tmpnam[FILSIZ];

     filptr=fillst;
     for (gap=numfil/2 ; gap > 0 ; gap=gap/2) {
          for (i=gap ; i < numfil ; i++) {
               for (j=i-gap ; j >= 0 ; j=j-gap) {
                    if (filptr[j].fsize > filptr[j+gap].fsize) {
                         break;
                    }
                    stlcpy(tmpnam,filptr[j].filnam,FILSIZ);
                    tmpsiz=filptr[j].fsize;
                    tmpflag=filptr[j].flag;
                    tmpasiz=filptr[j].asize;
                    stlcpy(filptr[j].filnam,filptr[j+gap].filnam,FILSIZ);
                    filptr[j].fsize=filptr[j+gap].fsize;
                    filptr[j].flag=filptr[j+gap].flag;
                    filptr[j].asize=filptr[j+gap].asize;
                    stlcpy(filptr[j+gap].filnam,tmpnam,FILSIZ);
                    filptr[j+gap].fsize=tmpsiz;
                    filptr[j+gap].flag=tmpflag;
                    filptr[j+gap].asize=tmpasiz;
               }
          }
     }
}

BOOL CWgmDlg::chkdrv(INT drvnum)
{
     CHAR path[]={"A:\\"};
     DWORD df_avail;
     DWORD df_sclus;
     DWORD df_bsec;
     DWORD df_total;
     BOOL success;
     INT notgood;

     notgood=TRUE;
     path[0]=('A'+(CHAR)(drvnum-1));
     while (notgood) {
          success=GetDiskFreeSpace(path,&df_sclus,&df_bsec,&df_avail,&df_total);
          if (wrtprt(drvnum)) {
               if (AfxMessageBox("The disk may be write protected or not in the drive",
                    MB_RETRYCANCEL|MB_ICONERROR) == IDCANCEL) {
                    return(FALSE);
               }
          }
          else {
               if (df_avail != df_total) {
                    if (AfxMessageBox("The disk in the drive already contains data. "
                         "Choose YES to wipe the disk contents or place another disk in the "
                         "drive and choose NO.",MB_YESNO|MB_ICONWARNING) == IDYES) {
                         wipdsk(drvnum);   //may belong to another dialog
                    }
               }
               else {
                    notgood=FALSE;
               }
          }
     }
     return(TRUE);
}

VOID CWgmDlg::adjlst(UINT clssiz)
{
     INT ctr;

     filptr=fillst;
     for (ctr=0 ; ctr < numfil ; ctr++) {
          filptr->asize=clfit(filptr->fsize,clssiz);
          filptr++;
     }
}

VOID CWgmDlg::todsk(INT lstnum,INT dsknum)
{
     INT numfiles,i;

     switch (lstnum) {
     case FST:
          numfiles=numfst;
          break;
     }
     for (i=0; i < numfiles ; i++) {
          switch (lstnum) {
          case FST:
               dodsk(fstlst[i].filnam,dsknum);
               break;
          }
     }
}

LONG CWgmDlg::getdfre(INT drvnum)
{
     CHAR buf[]="A:";

     buf[0]=drvnum+'A'-1;
     return(dskfre(buf)*1024);
}

INT CWgmDlg::getfil(CHAR *filenam,LONG *filsize,LONG dsksiz)
{
     INT cnt,i;

     filptr=fillst;
     for (cnt=0 ; cnt < numfil ; cnt++) {
          if (filptr[cnt].flag == 0) {
               if (filptr[cnt].asize <= dsksiz) {
                    stlcpy(filenam,filptr[cnt].filnam,FILSIZ);
                    *filsize=filptr[cnt].asize;
                    filptr[cnt].flag=1;
                    return(GOTFILE);
               }
          }
     }
     i=0;
     for (cnt=0 ; cnt < numfil ; cnt++) {
          if (filptr[cnt].flag == 0) {
               i++;
               break;
          }
     }
     if (i > 0) {
          return(NEWDISK);
     }
     return(ALLDONE);
}

VOID CWgmDlg::dodsk(CHAR *filnam,INT dsknum)
{
     CWaitCursor wait;
     CHAR dest[FILSIZ2];
     CHAR fpath[256];

     switch (dsknum) {
     case ADRIVE:
          stlcpy(dest,spr("A:" SLS "%s",filnam),FILSIZ2);
          break;
     default:
          stlcpy(dest,spr("B:" SLS "%s",filnam),FILSIZ2);
          break;
     }
     sprintf(fpath,"%s\\%s",INSTMP,filnam);
     UpdateWindow();
     if (CopyFile(fpath,dest,FALSE) == FALSE) {
          catastro("DODSK: error %d copying %s!",errno,filnam);
     }
}

VOID CWgmDlg::dsknum(INT drvnum,INT dsknum)
{
     CHAR foo[4];
     CHAR fileis[FILSIZ2];
     FILE *dfp;

     stlcpy(fileis,"A:\\disk.",FILSIZ2);
     fileis[0]=('A'+(CHAR)(drvnum-1));
     stlcat(fileis,itoa(dsknum,foo,10),FILSIZ2);
     if ((dfp=fopen(fileis,FOPWA)) == NULL) {
          catastro(spr("DSKNUM: Error opening %s!",fileis));
     }
     fputc((INT)0xFF,dfp);
     fclose(dfp);
}

BOOL CWgmDlg::wrtprt(INT drvnum)
{
     FILE *fp;
     INT savdrv;

     savdrv=_getdrive();
     if (!_chdrive(drvnum)) {
          if ((fp=fopen("test.fil",FOPWA)) == NULL) {
               _chdrive(savdrv);
               return(TRUE);
          }
          fclose(fp);
          unlink("test.fil");
          _chdrive(savdrv);
          return(FALSE);
     }
     return(TRUE);
}

VOID CWgmDlg::wipdsk(INT drvnum)
{
     INT savdrv;
     Cffblk fblk;
     CWaitCursor wait;

     CString   oldCap;
     GetWindowText( oldCap );
     CString   newCap;
     newCap.Format( "Deleting files from drive %c:...", (drvnum - 1) + 'A' );
     SetWindowText( newCap );

     savdrv=_getdrive();
     if (!_chdrive(drvnum)) {
          unlinktree(".");
     }
     _chdrive(savdrv);

     SetWindowText( oldCap );
}

BOOL CWgmDlg::CompressStarted()
{
     return( m_compressStarted );
}

BOOL CWgmDlg::Done()
{
     return( m_cmpobj.Done() );
}

BOOL CWgmDlg::Finish()
{
     m_compressStarted = FALSE;
     DoBuild();
     return( TRUE );
}

VOID CWgmDlg::unlinktree(CHAR *path,BOOL delAll)
{
     CWaitCursor wait;
     CHAR cdir[256];
     Cffblk fblk;

     if (!fnd1st(&fblk,path,FAMDIR)) {
          if (!sameas(path,".")) {
               return;
          }
     }
     _getcwd(cdir,256);
     _chdir(path);
     if (fnd1st(&fblk,"*.*",FAMDIR)) {
          do {
               if ((fblk.ff_attrib&FAMDIR) != 0) {
                    if (::IsWindow(m_hWnd)) {
                         UpdateWindow();
                    }
                    if (!sameas(fblk.ff_name,".") && !sameas(fblk.ff_name,"..")) {
                         unlinktree(fblk.ff_name,delAll);
                         if (::IsWindow(m_hWnd)) {
                              UpdateWindow();
                         }
                    }
               }
          } while (fndnxt(&fblk));
          unlinkfiles(delAll);
     }
     else {
          unlinkfiles(delAll);
     }
     _chdir(cdir);
     _rmdir(path);
}

VOID CWgmDlg::unlinkfiles(BOOL &delAll)
{
     CWaitCursor wait;
     Cffblk fblk;

     if (fnd1st(&fblk,"*.*",FAMRON|FAMHID|FAMSYS|FAMARC)) {
          do {
               if (::IsWindow(m_hWnd)) {
                    UpdateWindow();
               }
               if (fblk.ff_attrib&(FAMRON|FAMHID|FAMSYS)) {
                    BOOL      delOk = delAll;

                    if (! delOk)
                    {
                         ReadOnlyDialog dlg;
                         dlg.m_fname=fblk.ff_name;
                         char      answer=dlg.GetAnswer();

                         switch( tolower( answer ) )
                         {
                              case 'y':
                                   delOk = TRUE;
                                   break;

                              case 'a':
                                   delOk = delAll = TRUE;
                                   break;
                         }
                    }

                    if (delOk)
                    {
                         SetFileAttributes(fblk.ff_name,FILE_ATTRIBUTE_NORMAL);
                         if (::IsWindow(m_hWnd)) {
                              UpdateWindow();
                         }
                         unlink(fblk.ff_name);
                         if (::IsWindow(m_hWnd)) {
                              UpdateWindow();
                         }
                    }
               }
               else
               {
                    unlink(fblk.ff_name);
               }
          } while (fndnxt(&fblk));
     }
}

BOOL CWgmDlg::PreTranslateMessage(MSG* pMsg)
{
     BOOL result=FALSE;

     if ((pMsg->message == WM_KEYDOWN)
          || (pMsg->message == WM_KEYDOWN)
          || (pMsg->message == WM_KEYDOWN)) {
               if (pMsg->wParam == VK_ESCAPE) {
               result = TRUE;
          }
     }
     if (!result) {
          result=CDialog::PreTranslateMessage(pMsg);
     }
     return( result );
}

BOOL CWgmDlg::ZipStarted()
{
     return( m_cmpobj.ZipInProgress() );
}

BOOL CWgmDlg::ZipComplete()
{
     return( m_cmpobj.ZipComplete() );
}

void CWgmDlg::FinishZip()
{
     Cffblk fb;
     CHAR winexe[GCMAXFNM];

     sprintf(winexe,"%s.exe",m_wgmrec.winfnm);
     fnmcse(winexe);

     UpdateWindow();
     CString cmdlin="zip2exe -o ";
     cmdlin+=INSTMP;
     cmdlin+="\\wgminst";
     m_refresh=(CDialog *)this;
     if (!m_shell.StartApp(cmdlin,TRUE)) {
          catastro("DoBuild(): Could not create wgminst.exe using ZIP2EXE.");
     }
     else {
          UpdateWindow();
          m_shell.WaitForCompletion();
     }
     m_refresh=NULL;
     if (rename("wgminst.exe",spr("%s\\wgminst.exe",INSTMP)) != 0) {
          catastro("DoBuild(): Could not move wgminst.exe to INSTMP directory.");
     }
     UpdateWindow();
     if (fnd1st(&fb,winexe,0)) {
          unlink(winexe);
     }
     UpdateWindow();
     cmdlin="copy /b wgminst\\wgmistub.exe + ";
     cmdlin+=INSTMP;
     cmdlin+="\\wgminst.exe ";
     cmdlin+=winexe;
     m_refresh=(CDialog *)this;
     if (!m_shell.StartApp(cmdlin,TRUE)) {
          catastro(spr("DoBuild(): Could not create output file: %s.",winexe));
     }
     else {
          UpdateWindow();
          m_shell.WaitForCompletion();
     }
     m_refresh=NULL;
     ::PostQuitMessage(0);
}

VOID CWgmDlg::GetOldSettings(VOID)
{
     CHAR icofil[FILSIZ];
     CHAR *ptr;
     FILE *savfp;
     Cffblk icofb;
     Cffblk dskfb;

     memset(&m_wgmrec,0,sizeof(struct osminf));
     if (fnd1st(&dskfb,DISKID,0)) {
          do {
               unlink(spr("wgminst\\%s",dskfb.ff_name));
          } while (fndnxt(&dskfb));
     }
     if ((savfp=fopen(SAVFIL,FOPRB)) == NULL) {

          m_wgmrec.newusr=TRUE;
          m_wgmrec.conmth=CONNECT_TCPIP;
          m_wgmrec.bldwht=BUILD_FILE;
     }
     else {
          if (fread(&m_wgmrec,sizeof(struct osminf),1,savfp) != 1) {
               m_wgmrec.newusr=TRUE;
               m_wgmrec.conmth=CONNECT_TCPIP;
               m_wgmrec.bldwht=BUILD_FILE;
          }
          else {
               if ((m_wgmrec.conmth < 0) || (m_wgmrec.conmth >= MAX_CONMETH)) {
                    m_wgmrec.conmth=CONNECT_TCPIP;
               }
          }
          fclose(savfp);
     }
     icofil[0]='\0';
     if ((ptr=mstscan("bbsmainm.msg","aboutico",FILSIZ)) != NULL) {
          if (fnd1st(&icofb,spr("wgsicons\\%s",ptr),0)) {
               stlcpy(icofil,ptr,FILSIZ);
          }
     }
     InitData();
}

void CWgmDlg::OnClose()
{
     if (Done() && (! ZipStarted())) {
          OnCancelwgm();
     }
}

void CWgmDlg::OnCancelwgm()
{
     ::PostQuitMessage(0);
}

void CWgmDlg::DisableControls()
{
     m_cancelState = EnableControlId(IDCANCELWGM, FALSE);
     m_okState = EnableControlId(IDOK, FALSE);

     m_uidState = EnableControlId(IDC_UID, FALSE);
     m_passState = EnableControlId(IDC_PASS, FALSE);
     m_uideditState = EnableControlId(IDC_UIDEDIT, FALSE);
     m_passeditState = EnableControlId(IDC_PASSEDIT, FALSE);

     m_sfnameState = EnableControlId(IDC_SFNAME, FALSE);
     m_efnameState = EnableControlId(IDC_EFNAME, FALSE);
     m_sdriveState = EnableControlId(IDC_SDRIVE, FALSE);
     m_adriveState = EnableControlId(IDC_ADRIVE, FALSE);
     m_bdriveState = EnableControlId(IDC_BDRIVE, FALSE);

     m_selappsState = EnableControlId(IDC_SELAPPS, FALSE);
     m_helpState = EnableControlId(ID_HELP, FALSE);
     m_connectState = EnableControlId(IDC_CONNECT, FALSE);

     m_bldtyp0State = EnableControlId(IDC_BLDTYP0, FALSE);
     m_bldtyp1State = EnableControlId(IDC_BLDTYP1, FALSE);

     m_newusr0State = EnableControlId(IDC_NEWUSR0, FALSE);
     m_newusr1State = EnableControlId(IDC_NEWUSR1, FALSE);
     m_newusr2State = EnableControlId(IDC_NEWUSR2, FALSE);

     m_syslabelState = EnableControlId(IDC_SYSLABEL, FALSE);
     m_connameState = EnableControlId(IDC_CONNAME, FALSE);
     m_regnoState = EnableControlId(IDC_REGNO, FALSE);

     CMenu     *sysMenu = GetSystemMenu( FALSE );

     if (sysMenu != NULL)
     {
          sysMenu->EnableMenuItem( SC_CLOSE, MF_BYCOMMAND | MF_GRAYED );
     }
}

void CWgmDlg::EnableControls()
{
     (void)EnableControlId(IDCANCELWGM, m_cancelState);
     (void)EnableControlId(IDOK, m_okState);

     (void)EnableControlId(IDC_UID, m_uidState);
     (void)EnableControlId(IDC_PASS, m_passState);
     (void)EnableControlId(IDC_UIDEDIT, m_uideditState);
     (void)EnableControlId(IDC_PASSEDIT, m_passeditState);

     (void)EnableControlId(IDC_SFNAME, m_sfnameState);
     (void)EnableControlId(IDC_EFNAME, m_efnameState);
     (void)EnableControlId(IDC_SDRIVE, m_sdriveState);
     (void)EnableControlId(IDC_ADRIVE, m_adriveState);
     (void)EnableControlId(IDC_BDRIVE, m_bdriveState);

     (void)EnableControlId(IDC_SELAPPS, m_selappsState);
     (void)EnableControlId(ID_HELP, m_helpState);
     (void)EnableControlId(IDC_CONNECT, m_connectState);

     (void)EnableControlId(IDC_BLDTYP0, m_bldtyp0State);
     (void)EnableControlId(IDC_BLDTYP1, m_bldtyp1State);

     (void)EnableControlId(IDC_NEWUSR0, m_newusr0State);
     (void)EnableControlId(IDC_NEWUSR1, m_newusr1State);
     (void)EnableControlId(IDC_NEWUSR2, m_newusr2State);

     (void)EnableControlId(IDC_SYSLABEL, m_syslabelState);
     (void)EnableControlId(IDC_CONNAME, m_connameState);
     (void)EnableControlId(IDC_REGNO, m_regnoState);

     CMenu     *sysMenu = GetSystemMenu( FALSE );

     if (sysMenu != NULL)
     {
          sysMenu->EnableMenuItem( SC_CLOSE, MF_BYCOMMAND | MF_ENABLED );
     }
}

BOOL CWgmDlg::EnableControlId( int id, BOOL enable )
{
     CWnd     *control = GetDlgItem(id);
     ASSERT( control != NULL );

     BOOL      wasDisabled = TRUE;

     if (control != NULL)
     {
          wasDisabled = control->EnableWindow( enable );
     }

     return( ! wasDisabled );
}
