// wgm.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "wgm.h"
#include "wgmDlg.h"
#include "ModuleInfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static VOID GetModuleInfo(VOID);
static VOID SetOldInfo(VOID);

/////////////////////////////////////////////////////////////////////////////
// CWgmApp

BEGIN_MESSAGE_MAP(CWgmApp, CWinApp)
	//{{AFX_MSG_MAP(CWgmApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWgmApp construction

CWgmApp::CWgmApp()
{
     dlg=NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWgmApp object

CWgmApp theApp;

// Global variables

extern CModuleInfo moduleInfo;
CModuleInfo moduleInfo;

/////////////////////////////////////////////////////////////////////////////
// CWgmApp initialization

BOOL CWgmApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

     dlg=new CWgmDlg;
	m_pMainWnd = dlg;
     if (m_pszHelpFilePath != NULL) 
     {
          free((void *)m_pszHelpFilePath);
          m_pszHelpFilePath=NULL;
     }
     m_pszHelpFilePath=_tcsdup("HELP\\WGSMKWGM.HLP");

     GetModuleInfo();
     SetOldInfo();
     dlg->Create(IDD_WGM_DIALOG);
     return(TRUE);
}

// Application specific implementations

static VOID
GetModuleInfo(
VOID)
{
     INT i;
     INT mdfidx=0;
     INT nactvmdfs=0;
     GBOOL fsttok;
     GBOOL fstlin=TRUE;
     CHAR *mdfbuf=NULL;
     CHAR *tokptr=NULL;
     CHAR **actvmdfs=NULL;
     struct modinf *csrec;

     CException* myEx=new CException;
     try {
          if (tfsopn("wgsmdfs.lst") != 1) {
               throw(myEx);
          }
     }
     catch(CException* e) {
          TRACE("Could not open wgsmdfs.lst");
          e->ReportError(MB_OK,0);  // supply an error message instead of '0' later
          myEx->Delete();
          return;
     }
     while (tfsrdl() != TFSDUN) {
          switch (tfstate) {
          case TFSLIN:
               if (fstlin) {
                    nactvmdfs=atoi(tfsbuf);
                    actvmdfs=(CHAR **)alczer(nactvmdfs*sizeof(CHAR *));
                    for (i=0 ; i < nactvmdfs ; i++) {
                         actvmdfs[i]=(CHAR *)alczer(GCMAXFNM);
                    }
                    fstlin=FALSE;
               }
               else {
                    stlcpy(actvmdfs[mdfidx],tfsbuf,GCMAXFNM);
                    mdfidx++;
               }
               break;
          }
     }
     moduleInfo.modarray=(struct modinf *)alczer(nactvmdfs*sizeof(struct modinf));
     for (i=0 ; i < nactvmdfs ; i++) {
          mdfbuf=scnmdf(actvmdfs[i],"Client app EXE:");
          if (strlen(mdfbuf) > 0) {
               csrec=&moduleInfo.modarray[moduleInfo.modcnt];
               stlcpy(csrec->ncsexe,mdfbuf,GCMAXFNM);
               stlcpy(csrec->mdfnam,actvmdfs[i],GCMAXFNM);
               stlcpy(csrec->moddsc,gmdnam(actvmdfs[i]),MNMSIZ);
               try {
                    if (tfsopn(actvmdfs[i]) != 1) {
                         throw(myEx);
                    }
               }
               catch(CException* e) {
                    if (actvmdfs != NULL) {
                         for (i=0 ; i < nactvmdfs ; i++) {
                              free(actvmdfs[i]);
                         }
                         free(actvmdfs);
                    }
                    TRACE("Error opening %s",actvmdfs[i]);
                    e->ReportError(MB_OK,0);  // supply an error message instead of '0' later
                    myEx->Delete();
                    return;
               }
               fsttok=TRUE;
               while (tfsrdl() != TFSDUN) {
                    if ((tfstate == TFSLIN) && tfspfx("Client app support files:")) {
                         if (csrec->supfils == NULL) {
                              csrec->supfils=(CHAR *)alczer(strlen(tfspst)+1);
                         }
                         else {
                              csrec->supfils=(CHAR *)alcrsz(csrec->supfils,
                                   strlen(csrec->supfils)+1,
                                   strlen(csrec->supfils)+strlen(tfspst)+1+1);
                         }
                         tokptr=strtok(tfspst,DELIMS);
                         do {
                              if (!fsttok) {
                                   strcat(csrec->supfils," ");
                              }
                              else {
                                   fsttok=FALSE;
                              }
                              strcat(csrec->supfils,tokptr);
                         } while ((tokptr=strtok(NULL,DELIMS)) != NULL);
                    }
               }
               moduleInfo.modcnt++;
          }
     }
     moduleInfo.modarray=(struct modinf *)alcrsz(moduleInfo.modarray,
          nactvmdfs*sizeof(struct modinf),moduleInfo.modcnt*sizeof(struct modinf));
     moduleInfo.selmods=(BOOL *)alczer(moduleInfo.modcnt*sizeof(BOOL));
     for (i=0 ; i < moduleInfo.modcnt ; i++) {
          moduleInfo.selmods[i]=FALSE;
     }
     for (i=0 ; i < nactvmdfs ; i++) {
          free(actvmdfs[i]);
     }
     free(actvmdfs);
     myEx->Delete();
}

static VOID
SetOldInfo(
VOID)
{
     if (tfsopn("galinmod.lst") == 1) {
          while (tfsrdl() != TFSDUN) {
               switch (tfstate) {
               case TFSLIN:
                    for (int i=0 ; i < moduleInfo.modcnt ; i++) {
                         if (sameas(tfsbuf,moduleInfo.modarray[i].mdfnam)) {
                              moduleInfo.selmods[i]=TRUE;
                         }
                    }
                    break;
               }
          }
     }
}

int CWgmApp::ExitInstance() 
{
	if (dlg != NULL) {
          delete dlg;
          dlg=NULL;
     }
	return(0);
}

BOOL CWgmApp::OnIdle(LONG lCount) 
{
	if (CWinApp::OnIdle(lCount)) {
          return(TRUE);
     }
     if ((lCount > 1) && (dlg->m_refresh != NULL)) {
          dlg->m_refresh->UpdateWindow();
     }
     if (lCount > 5) {
          if (dlg->ZipStarted())
          {
               if (dlg->ZipComplete())
               {
                    dlg->FinishZip();
               }
               else
               {
                    ::Sleep( 250 );
               }
          }
          else if (dlg->CompressStarted()) {
               if (dlg->Done()) {
                    dlg->Finish();
               }
               else {
                    ::Sleep(250);
               }
          }
     }
     return(TRUE);
}