// wgmDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CWgmDlg dialog


#if ! defined( WGMDLG_H )
#  define WGMDLG_H

#include "Compressor.h"
#include "ThreadShell.h"

#define NAMSIZ 44   // maximum length of system name
#define SRVSIZ 44   // maximum length of server name
#define DMNSIZ 44   // maximum length of domain name

struct osminf {                    // layout for online service info
     CHAR sysnam[NAMSIZ];          //   online service name
     SHORT conmth;                 //   connectivity method
     CHAR syspho[PHOSIZ];          //   online service phone number
     CHAR srvnam[SRVSIZ];          //   online service server name
     CHAR dmnnam[DMNSIZ];          //   online service domain name
     SHORT newusr;                 //   logon as new user?
     CHAR lognam[UIDSIZ];          //   user's login name
     CHAR logpsw[PSWSIZ];          //   user's password
     SHORT bldwht;                 //   F=build file, D=build disk
     CHAR winfnm[GCMAXFILE+1];     //   name of Windows .EXE to create
};

class CWgmDlg : public CDialog
{
// Construction
public:
	VOID InitData(VOID);
	VOID GetOldSettings(VOID);
	void FinishZip();
	BOOL ZipComplete();
	BOOL ZipStarted();
	CDialog * m_refresh;
	VOID unlinkfiles(BOOL &delAll);
	VOID unlinktree(CHAR *path,BOOL delAll=FALSE);
	BOOL Finish();
	BOOL Done();
	BOOL CompressStarted();
	CWinThread * m_cthread;
	VOID wipdsk(INT drvnum);
	GBOOL m_done;
	Compressor m_cmpobj;
	BOOL wrtprt(INT drvnum);
	VOID dsknum(INT drvnum,INT dsknum);
	VOID dodsk(CHAR *filnam,INT dsknum);
	INT getfil(CHAR *filenam,LONG *filsize,LONG dsksiz);
	LONG getdfre(INT drvnum);
	VOID todsk(INT lstnum,INT dsknum);
	VOID adjlst(UINT clssiz);
	BOOL chkdrv(INT drvnum);
	VOID srtlst(VOID);
	VOID fildsk(INT drvnum);
	INT numfst;
	INT numfil;
	CHAR icofil[FILSIZ];
	CHAR regnum[REGSIZ];
	CHAR * rnosid(CHAR *regno);
	LONG osgsiz;
	LONG icosiz;
	INT nssfils;
	CHAR ** ssfils;
	INT teltyp(VOID);
	INT invser(VOID);
	VOID kilwht(CHAR *str);
	VOID getlsts(VOID);
	VOID lastfil(INT drvnum);
	VOID gendsk1(VOID);
	VOID makico(VOID);
	VOID makosg(VOID);
	VOID add2ss(const CHAR *fils2add);
	VOID cpyfil(const CHAR *srcdir,const CHAR *srcfil);
	VOID DoBuild(VOID);
	BOOL isuidc(CHAR c);
	BOOL CheckData(VOID);
	VOID EnableUserFields(BOOL bEnabled);
	void EnableFilenameFields(BOOL bEnabled);
	VOID ShowConnectionFields(BOOL bEnabled);
	struct osminf m_wgmrec;
     struct filary {                    // file list structure
          CHAR filnam[FILSIZ];          //   filename
          LONG fsize;                   //   file size
          LONG asize;                   //   adjusted size
          INT flag;                     //   flag (0=uncopied)
     } *fillst,                         // list of files to copy
     *filptr,                         // pointer to list
     *fstlst,                         // list of files for first disk
     *fstptr,                         // pointer to first files list
     *dsknfo;                         // special case: pass info for disk.1
	VOID SetupDialog(VOID);
	CWgmDlg(CWnd* pParent = NULL);	// standard constructor
     ~CWgmDlg();

// Dialog Data
	//{{AFX_DATA(CWgmDlg)
	enum { IDD = IDD_WGM_DIALOG };
	int		m_bldtyp;
	int		m_newusr;
	CString	m_conname;
	CString	m_uid;
	CString	m_psw;
	CString	m_sysname;
	CString	m_bfile;
	int		m_drive;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWgmDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CWgmDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
     afx_msg LONG OnThreadFinished(UINT nThread,LONG lParam);
	afx_msg void OnSelapps();
	afx_msg void OnSelchangeConnect();
	afx_msg void OnNewusr0();
	afx_msg void OnNewusr1();
	afx_msg void OnBldtyp0();
	afx_msg void OnBldtyp1();
	afx_msg void OnNewusr2();
	virtual void OnOK();
	afx_msg void OnClose();
	afx_msg void OnCancelwgm();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL EnableControlId( int control, BOOL enable );
	void EnableControls();
	void DisableControls();
	ThreadShell m_shell;
	void DoCompress();
	BOOL m_compressStarted;

     BOOL m_cancelState;
     BOOL m_okState;

     BOOL m_uidState;
     BOOL m_passState;
     BOOL m_uideditState;
     BOOL m_passeditState;

     BOOL m_sfnameState;
     BOOL m_efnameState;
     BOOL m_sdriveState;
     BOOL m_adriveState;
     BOOL m_bdriveState;

     BOOL m_selappsState;
     BOOL m_helpState;
     BOOL m_connectState;

     BOOL m_bldtyp0State;
     BOOL m_bldtyp1State;

     BOOL m_newusr0State;
     BOOL m_newusr1State;
     BOOL m_newusr2State;

     BOOL m_syslabelState;
     BOOL m_connameState;
     BOOL m_regnoState;
};

#endif    // WGMDLG_H
