// wgmdefs.h
//
//   Special definitions for the project

#define WM_THREADFINISHED     (WM_USER+1)    // User defined message for end of thread

#define THREAD_GETINFO        1    // Thread ID for module information gathering thread
#define THREAD_MAKEDISK       2    // Thread ID for disk builder thread
#define THREAD_MAKEFILE       3    // Thread ID for file builder thread

#define END_THREAD_NOTIFY(t)  ::PostMessage((HWND)pParam,WM_THREADFINISHED,t,0)

// Other definitions

#define INCDIR "include"           //
#define EXCDIR "exclude"           //
#define INCFIL "include.dir"       //
#define EXCFIL "exclude.dir"       //
#define LSTNAM "wgsmkwgm.lst"      //
#define MODLSFIL "galinmod.lst"    //
#define ICODIR "wgsicons"          // name of icon directory
#define DISKID "wgminst\\disk.?"   // fnd1st parameter for disk.? files
#define SAVFIL "wgsmkwgm.sav"      // name of file to hold WGM info
#define INSTMP "instemp"           // temporary directory used during build
#define DELIMS ", \t;"             // valid delimiters for DLL & EXE lists

#define NEWUSR 1
#define NUMSUP 4                   // number of installation support files
#define NUMFST 10                  // number for files forced onto 1st disk
#define NUMEXP 4                   // # files which don't go in WINUPD.LST
#define FILBLD 0                   // attempting to build a .ZIP file
#define DSKBLD 1                   // attempting to build a disk
#define FILSIZ 13                  // maximum length of file name
#define FILSIZ2 16                 // max length of file name + drive
#define CONSIZ 7                   // max. length of temp 'conmth' var
#define YNSIZ  4                   // max. length of temp 'newusr' var
#define BWHSIZ 5                   // max. length of temp "build what" var
#define SIDSIZ 5                   // max. size of system id

#define BUILD_DISK     0
#define BUILD_FILE     1

#define MAX_CONMETH    4           // max. number of connection methods

#define CONNECT_MODEM  0
#define CONNECT_SERIAL 1
#define CONNECT_LAN    2
#define CONNECT_TCPIP  3

#define FST 1                      // first disk filelist

#define GOTFILE 1                  // got a valid file
#define NEWDISK 0                  // have files, but no space, new disk
#define ALLDONE -1                 // all files been output
#define NODRIVE -1                 // don't use any drive (zipping)
#define ADRIVE 1                   // drive number associated w/ A:
#define BDRIVE 2                   // drive number associated w/ B:

#define MINMEM 298000L             // minimum memory req'd for zipping
#define REGSIZ 9                   // maximum length of reg number
#define MAXINZ 800                 // maximum files allowed in ZIP file
#define RECLEN sizeof(struct wgmrec) // record length in WGSMKWGM.SAV

// OSM Flags for last line in .OSG file
#define FLGOSM 1                   // there is a new OSM version
#define FLGNXT 2                   // connect next time
#define FLGICO 4                   // custom system icon in use
#define FLGACN 8                   // always connect upon invocation
#define FLGSER 16                  // connection involves serial port
#define FLGSCS 32                  // auto-sense client/server mode
#define FLGSAN 64                  // resp. to aut-sns ANSI color in A/A
#define FLGIP  128                 // if LAN connection, is it telnet?

#define EXTFIL ".___"              // extension "filler" for cnv2is()

#define OLDSSFLS "bc30rtl.dll "\
                 "gcspcli.dll "\
                 "galcbk.vbx "\
                 "gswdll.dll "\
                 "ss3d2.vbx "\
                 "msafinx.dll "\
                 "vbrun300.dll "\
                 "gsw.exe "\
                 "anibuton.vbx "\
                 "graph.vbx "\
                 "keystat.vbx "\
                 "msmasked.vbx "\
                 "msoutlin.vbx "\
                 "picclip.vbx "\
                 "spin.vbx "\
                 "threed.vbx"