// SelApp.cpp : implementation file
//

#include "stdafx.h"
#include "wgm.h"
#include "SelApp.h"
#include "ModuleInfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CModuleInfo moduleInfo;

/////////////////////////////////////////////////////////////////////////////
// CSelApp dialog

CSelApp::CSelApp(CWnd* pParent /*=NULL*/)
	: CDialog(CSelApp::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelApp)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CSelApp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelApp)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelApp, CDialog)
	//{{AFX_MSG_MAP(CSelApp)
     ON_MESSAGE(WM_THREADFINISHED,OnThreadFinished)
	ON_LBN_SELCHANGE(IDC_APPLIST, OnSelchangeApplist)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_LBN_SELCHANGE(IDC_ADDLIST, OnSelchangeAddlist)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelApp message handlers

LONG CSelApp::OnThreadFinished(UINT nThread, LONG lParam)
{
     switch(nThread) {
     case THREAD_GETINFO:
          break;
     case THREAD_MAKEDISK:
          break;
     case THREAD_MAKEFILE:
          break;
     default:
          break;
     }
     return(0);
}

BOOL CSelApp::OnInitDialog() 
{
	CDialog::OnInitDialog();
     CListBox* sbox=(CListBox *)GetDlgItem(IDC_APPLIST);
     CListBox* dbox=(CListBox *)GetDlgItem(IDC_ADDLIST);
     sbox->ResetContent();
     dbox->ResetContent();

     EnableAdd(FALSE);
     EnableRemove(FALSE);
     for (int i=0; i < moduleInfo.modcnt ; i++) {
          sbox->AddString(moduleInfo.modarray[i].moddsc);
          if (moduleInfo.selmods[i] == TRUE) {
               dbox->AddString(moduleInfo.modarray[i].moddsc);
          }
     }
	return TRUE;  // return TRUE unless you set the focus to a control
}

VOID CSelApp::EnableAdd(BOOL bEnable)
{
     (CButton*)GetDlgItem(IDC_ADD)->EnableWindow(bEnable);
}

VOID CSelApp::EnableRemove(BOOL bEnable)
{
     (CButton*)GetDlgItem(IDC_REMOVE)->EnableWindow(bEnable);
}

void CSelApp::OnAdd() 
{
     CString tmpString;
     CListBox* sbox=(CListBox *)GetDlgItem(IDC_APPLIST);
     CListBox* dbox=(CListBox *)GetDlgItem(IDC_ADDLIST);
     int selCount=sbox->GetSelCount();

     if (selCount > 0) {
          int *nArray=new (int [selCount]);
          sbox->GetSelItems(selCount,nArray);
          for (int i=0; i < selCount ; i++) {
               sbox->GetText(nArray[i],tmpString);
               if (dbox->FindStringExact(0,tmpString) == LB_ERR) {
                    dbox->AddString(tmpString);
               }
          }
          delete [] nArray;
     }
}

void CSelApp::OnRemove() 
{
     CListBox* dbox=(CListBox *)GetDlgItem(IDC_ADDLIST);
     int selCount=dbox->GetSelCount();

     if (selCount > 0) {
          int *nArray=new (int [selCount]);
          dbox->GetSelItems(selCount,nArray);
          for (int i=(selCount-1); i >= 0 ; i--) {
               dbox->DeleteString(nArray[i]);
          }
          delete [] nArray;
          EnableRemove(FALSE);
     }
}

void CSelApp::OnSelchangeApplist() 
{
     if (((CListBox*)GetDlgItem(IDC_APPLIST))->GetSelCount() > 0) {
          EnableAdd(TRUE);
     }
     else {
          EnableAdd(FALSE);
     }
}

void CSelApp::OnSelchangeAddlist() 
{
	if (((CListBox*)GetDlgItem(IDC_ADDLIST))->GetSelCount() > 0) {
          EnableRemove(TRUE);
     }
     else {
          EnableRemove(FALSE);
     }
}

void CSelApp::OnOK() 
{
     FILE *fp=NULL;
	CListBox* dbox=(CListBox *)GetDlgItem(IDC_ADDLIST);
	int itemCount=dbox->GetCount();

     unlink("galinmod.lst");
     if ((fp=fopen("galinmod.lst",FOPWA)) == NULL) {
          catastro("OnOK(): Cannot save out selected module list.");
     }
     for (int i=0 ; i < moduleInfo.modcnt ; i++) {
          if (itemCount > 0) {
               if (dbox->FindStringExact(0,moduleInfo.modarray[i].moddsc) != LB_ERR) {
                    moduleInfo.selmods[i]=TRUE;
                    fprintf(fp,"%s\n",moduleInfo.modarray[i].mdfnam);
               }
               else {
                    moduleInfo.selmods[i]=FALSE;
               }
          }
          else {
               moduleInfo.selmods[i]=FALSE;
          }
     }
     fclose(fp);
	CDialog::OnOK();
}