////////////////////////////////////////////////////////////////////////////
//
//  COMPRESSOR.H
//
//  File compression shell for WGSMKWGM
//
//                                                  - Paul Roub  09/11/96
//
/////////////////////////////////////////////////////////////////////////////

#if ! defined( COMPRESSOR_H )
#  define COMPRESSOR_H

#include  "CompressDialog.h"
#include  "gcommlib.h"
#include  "ThreadShell.h"


class Compressor
{
public:
	BOOL ZipComplete();
	BOOL ZipInProgress();
	VOID SetUpdateWindow(CDialog *pdlg);
     Compressor();
    ~Compressor();

     void
     CompressFile(                 // compress file into INSTMP directory
     const char *srcDir,           //   source directory
     const char *srcFil,           //   source file
     GBOOL incsdir);               //   include subdirectory info?

     BOOL                          //   TRUE if pkzip started OK
     Zip(                          // make zip file of compressed files
     const char *zipName,          //   zip file name (and path)
     const char *zipFiles);        //   file list (and/or wildcards)

     BOOL                          //   TRUE if current operation is complete
     Done();                       // check whether compression or ZIP is done

     CString                       //   error text
     Error();                      // get description of last error

     void
     Cancel();                     // cancel the current application

     void
     SetMinimize(                  // set apps running minimized or not
     BOOL minimize);               //   TRUE if apps should be minimized

private:
	long m_bytesSoFar;
	long m_totalBytes;
	long GetFsize( const char *fname );
	BOOL m_zipInProgress;
     BOOL m_minimize;
     void AddToCompressList( const CString &cmpbuf, long fsize );
     CString cnv2is( const char *filename );

     CString m_error;              // error text
     int totalCount;               // total files to be compressed
     int sofar;                    // files compressed so far
     CompressDialog *m_dlg;        // our status dialog
     ThreadShell m_shell;          // our console shell
     CStringList strList;          // list of compression command lines
     BOOL m_done;                  // are we done?
protected:
	CDialog * m_dpaint;
};


#endif
