////////////////////////////////////////////////////////////////////////////
//
//  COMPRESSOR.CPP
//
//  Compression wrapper for WGSMKWGM
//
//                                                  - Paul Roub  09/11/96
//
/////////////////////////////////////////////////////////////////////////////

#include  "stdafx.h"
#include  "gcommlib.h"
#include  "resource.h"
#include  "Compressor.h"


#if ! defined( INSTMP )
#  define INSTMP "instemp"         // temporary directory used during build
#endif

#if ! defined( EXTFIL )
#  define EXTFIL ".___"            // extension "filler" for cnv2is()
#endif


Compressor::Compressor()
{
     m_dlg = NULL;
     m_dpaint=NULL;
     sofar = totalCount = 0;
     m_minimize = TRUE;
     m_zipInProgress = FALSE;
     m_totalBytes = m_bytesSoFar = 0;
}

Compressor::~Compressor()
{
     if (! m_shell.Complete())
     {
          m_shell.Cancel();
          m_dpaint=NULL;
     }
}


void
Compressor::CompressFile(          // compress file into INSTMP directory
const char *srcDir,                //   source directory
const char *srcFil,                //   source file
GBOOL incsdir)                     //   include subdirectory info?
{
     CString   cmdbuf;

     if (incsdir) {
          cmdbuf.Format( "%s" SLS "%s " INSTMP SLS "%s %s -i",
                  srcDir,srcFil,cnv2is(srcFil),srcDir);
     }
     else {
          cmdbuf.Format( "%s" SLS "%s " INSTMP SLS "%s",
                  srcDir,srcFil,cnv2is(srcFil));
     }

     CString   fname;
     fname.Format( "%s" SLS "%s", srcDir, srcFil );

     AddToCompressList( cmdbuf, GetFsize( fname ) );

     return;
}


CString                            //   returns converted file name
Compressor::cnv2is(                // convert file name to I-shield format
const char *filnam)                //   file name to convert
{
     INT i,count;
     CHAR *ptr;
     static CHAR tmpnam[GCMAXFNM];

     stlcpy(tmpnam,filnam,GCMAXFNM);
     if (strchr(tmpnam,'.') == NULL) {
          return(stlcat(tmpnam,EXTFIL,GCMAXFNM));
     }
     count=strlen(tmpnam)-(GCMAXEXT-1);
     for (i=GCMAXFNM-(GCMAXEXT-1) ; i > count ; i--) {
          if (tmpnam[i] == '.') {
               break;
          }
          tmpnam[i]='_';
     }
     if (strlen(ptr=strchr(tmpnam,'.')) > GCMAXEXT+1) {
          ptr[GCMAXEXT+1]='\0';
     }
     return( CString( (const char *)tmpnam ) );
}


void Compressor::AddToCompressList( const CString &cmpbuf, long fsize )
{
     strList.AddTail( cmpbuf );
     ++totalCount;
     m_totalBytes += fsize;
}


BOOL                               //   TRUE if current operation is complete
Compressor::Done()                 // check whether compression or ZIP is done
{
     if (! m_shell.Complete())
     {
          return( FALSE );
     }

     //   no more files?  we're done
     //
     if (strList.IsEmpty())
     {
          //m_shell.KillConsole();
          m_done = TRUE;

          if (m_dlg != NULL)
          {
               delete m_dlg;
               m_dlg = NULL;
          }

          return( TRUE );
     }

     //   else let's do the next one
     //

     if (m_dlg == NULL)
     {
          m_dlg = new CompressDialog;
          m_dlg->Create( IDD_COMPRESSDIALOG );
          m_dlg->SetFocus();
     }

     ++sofar;

     CString   next = strList.GetHead();

     m_dlg->SetStats( next, sofar, totalCount, m_bytesSoFar, m_totalBytes );

     if (! m_shell.StartApp( "wgsiscom.exe " + next, m_minimize ))
     {
          m_error = m_shell.Error();
          return( TRUE );
     }

     m_bytesSoFar += GetFsize( firstwd( (char *)(const char *)next ) );

     strList.RemoveHead();

     return( FALSE );
}

                      
BOOL                               //   TRUE if pkzip started OK
Compressor::Zip(                   // make zip file of compressed files
const char *zipName,               //   zip file name (and path)
const char *zipFiles)              //   file list (and/or wildcards)
{
     BOOL      result = FALSE;

     if (! Done())
     {
          m_error = "Not done creating files";
     }
     else
     {
          CString   cmdLine = "pkzip.exe -# ";
          cmdLine += zipName;
          cmdLine += " ";
          cmdLine += zipFiles;

          if (m_shell.StartApp( cmdLine, m_minimize ))
          {
               m_zipInProgress = TRUE;
               result = TRUE;

               m_dlg = new CompressDialog;
               m_dlg->Create( IDD_COMPRESSDIALOG );
               m_dlg->SetFocus();
               m_dlg->SetStats( zipName + CString( ".zip" ), 1, 1, 0, 0 );
          }
          else
          {
               m_error = "Couldn't run PKZIP: " + m_shell.Error();
          }
     }

     return( result );
}


CString                            //   error text
Compressor::Error()                // get description of last error
{
     return( m_error );
}

void
Compressor::SetMinimize(           // set apps running minimized or not
BOOL minimize)                     //   TRUE if apps should be minimized
{
     m_minimize = minimize;
}

void
Compressor::Cancel()               // cancel the current application
{
     if (! m_shell.Complete())
     {
          m_shell.Cancel();
          strList.RemoveAll();
     }
}

VOID Compressor::SetUpdateWindow(CDialog *pdlg)
{
     m_dpaint=pdlg;
}

BOOL Compressor::ZipInProgress()
{
     return( m_zipInProgress );
}

BOOL Compressor::ZipComplete()
{
     if (! m_zipInProgress)
     {
          return( TRUE );
     }

     if (! m_shell.Complete())
     {
          return( FALSE );
     }

     m_shell.KillConsole();
     m_zipInProgress = FALSE;

     if (m_dlg != NULL)
     {
          delete m_dlg;
          m_dlg = NULL;
     }

     return( TRUE );
}

long Compressor::GetFsize( const char *fname )
{
     Cffblk    fb;
     long      fsize = 0;

     if (fnd1st(&fb,fname,0))
     {
          fsize = fb.ff_fsize;
     }

     return( fsize );
}
