// CompressDialog.h : header file
//
//   assumes the following dialog box resource:
//
//        dialog ID - IDD_COMPRESSDIALOG
//
//   with controls:
//
//        IDC_FILECOUNT - static (will display "File X of X")
//        IDC_PROGRESS  - progress gauge
//        IDC_FNAME     - static (will display current compress file name)
//

/////////////////////////////////////////////////////////////////////////////
// CompressDialog dialog

#if ! defined( COMPRESSDIALOG_H )
#  define COMPRESSDIALOG_H

#include "resource.h"

class CompressDialog : public CDialog
{
// Construction
public:
     CompressDialog(CWnd* pParent = NULL);   // standard constructor

     void
     SetStats(                     // set progress and file name
     const CString &fnames,        //   WGSISCMP command line params
     int sofar,                    //   number of files compressed so far
     int total,                    //   number to be compressed
     int bytesSoFar,               //   bytes compressed
     int totalBytes);              //   bytes to compress

// Dialog Data
     //{{AFX_DATA(CompressDialog)
     enum { IDD = IDD_COMPRESSDIALOG };
     CStatic   m_filecount;
     CProgressCtrl  m_progress;
     CStatic   m_fname;
     //}}AFX_DATA


// Overrides
     // ClassWizard generated virtual function overrides
     //{{AFX_VIRTUAL(CompressDialog)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
     virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

     // Generated message map functions
     //{{AFX_MSG(CompressDialog)
          // NOTE: the ClassWizard will add member functions here
     //}}AFX_MSG
     DECLARE_MESSAGE_MAP()
};


#endif
