// CompressDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CompressDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CompressDialog dialog


CompressDialog::CompressDialog(CWnd* pParent /*=NULL*/)
     : CDialog(CompressDialog::IDD, pParent)
{
     //{{AFX_DATA_INIT(CompressDialog)
          // NOTE: the ClassWizard will add member initialization here
     //}}AFX_DATA_INIT
}


void CompressDialog::DoDataExchange(CDataExchange* pDX)
{
     CDialog::DoDataExchange(pDX);
     //{{AFX_DATA_MAP(CompressDialog)
     DDX_Control(pDX, IDC_FILECOUNT, m_filecount);
     DDX_Control(pDX, IDC_PROGRESS, m_progress);
     DDX_Control(pDX, IDC_FNAME, m_fname);
     //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CompressDialog, CDialog)
     //{{AFX_MSG_MAP(CompressDialog)
          // NOTE: the ClassWizard will add message map macros here
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CompressDialog message handlers

void
CompressDialog::SetStats(          // set progress and file name
const CString &fnames,             //   WGSISCMP command line params
int sofar,                         //   number of files compressed so far
int totalCount,                    //   number to be compressed
int bytesSoFar,                    //   bytes compressed
int totalBytes)                    //   bytes to compress
{
     CString   fname;

     //   use first param only
     //
     int       space = fnames.Find( ' ' );

     if (space >= 0)
     {
          fname = fnames.Left( space );;
     }
     else
     {
          fname = fnames;
     }

     int       pct = 100;

     if (totalBytes > 0)
     {
          pct = (max( bytesSoFar - 1, 0 ) * 100) / totalBytes;
     }

     CString   fcount;
     fcount.Format( "File %i of %i", sofar, totalCount );

     m_fname.SetWindowText( fname );
     m_progress.SetPos( pct );
     m_filecount.SetWindowText( fcount );
     UpdateWindow();
}

BOOL CompressDialog::PreTranslateMessage(MSG* pMsg) 
{
	BOOL      result = FALSE;

     if ((pMsg->message == WM_KEYDOWN) ||
         (pMsg->message == WM_KEYDOWN) ||
         (pMsg->message == WM_KEYDOWN)
        )
     {
          if (pMsg->wParam == VK_ESCAPE)
          {
               result = TRUE;
          }
     }
	
     if (! result)
     {
	     result = CDialog::PreTranslateMessage(pMsg);
     }

     return( result );
}
