/***************************************************************************
 *                                                                         *
 *   SVC.CPP                                                               *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Functions used by majorbbs.c when run  as a service                   *
 *                                                                         *
 *                                        - I. Minkin 6/05/96              *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"
#include <winsvc.h>
#define SSTARTNAME \
             "WGSControl"          // service name

#define SMAIN_FAILEDTOSTART   255  // return value when main exec.
                                   // unable to start as a service

GBOOL                              //   return TRUE if WGSTART is running
isWgstartRunning(VOID)             // check if WGSTART is running
{
     SERVICE_STATUS ssStatus;
     SC_HANDLE hMainServ=NULL;
     SC_HANDLE hSCManager;
     GBOOL retVal=TRUE;

     if ((hSCManager=OpenSCManager(NULL,NULL,SC_MANAGER_ALL_ACCESS)) == NULL) {
          retVal=FALSE;
     }
     if (retVal
      && (hMainServ=OpenService(hSCManager,SSTARTNAME,SERVICE_ALL_ACCESS))
                                                                      == NULL) {
          retVal=FALSE;
     }
     if (retVal && !QueryServiceStatus(hMainServ,&ssStatus)) {
          retVal=FALSE;
     }
     if (retVal && ssStatus.dwCurrentState != SERVICE_RUNNING) {
          retVal=FALSE;
     }
     if (hMainServ) {
          CloseServiceHandle(hMainServ);
     }
     if (hSCManager) {
          CloseServiceHandle(hSCManager);
     }
     return(retVal);
}