/***************************************************************************
 *                                                                         *
 *   MNUUTL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains routines for dealing with records in BBSMENU.DAT.  *
 *                                                                         *
 *                                            - D. Pitchford 6/10/94       *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"

VOID
unpack(                            // unpack pages after loading           
struct mnupag *menupage)                // page to unpack                  
{
     struct pglink *pg;
     INT i;

     i=MAXSEL-menupage->npages;
     if (i > 0 && i <= MAXSEL) {
          memset(&menupage->page[menupage->npages],0,i*sizeof(struct pglink));
     }
     for (i=menupage->npages-1 ; i >= 0 ; i--) {
          pg=&menupage->page[i];
          assert(pg->position >= 0);
          assert(pg->position < MAXSEL);
          if (pg->position != i
	      && pg->position > 0
	      && pg->position < MAXSEL) {
               memmove(&menupage->page[pg->position],pg,sizeof(struct pglink));
               memset(pg,0,sizeof(struct pglink));
          }
     }
}

VOID
repack(                            // repack pages to save to disk         
struct mnupag *menupage)                // page to repack                  
{
     struct pglink *pg;
     INT curidx=0,i;

     for (i=0 ; i < MAXSEL ; i++) {
          pg=&menupage->page[i];
          if (pg->selchr != '\0') {
               pg->position=i;
               if (curidx != i) {
                    memmove(&menupage->page[curidx],pg,sizeof(struct pglink));
                    memset(pg,0,sizeof(struct pglink));
               }
               curidx++;
          }
          else {
               memset(pg,0,sizeof(struct pglink));
          }
     }
     menupage->npages=curidx;
}

VOID
savepage(                           // save a menu page                     
struct mnupag *menupage,                // page to save                    
GBOOL insert)                            // FALSE=update, TRUE=insert       
{
     INT length;

     repack(menupage);
     length=sizeof(struct mnupag);
     length-=(MAXSEL-menupage->npages)*sizeof(struct pglink);
     if (insert) {
          dfaInsertV(menupage,length);
     }
     else {
          dfaUpdateV(menupage,length);
     }
     unpack(menupage);
}