/***************************************************************************
 *                                                                         *
 *   BBSFNDO.C                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This program finds all lines in all active .MDF files that begin      *
 *   with the command-line argument, and executes each of the commands     *
 *   found there, in turn.  It depends on the file WGSMDFS.LST, which      *
 *   is created by WGSINT.                                                 *
 *                                                                         *
 *                                            - T. Stryker 3/15/92         *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"
#include "gcommlib.h"
#include "excphand.h"
#include "ShellCmd.h"

#define FILREV "$Revision: 1 $"


static int GetCommandLine(const char *wholeLine,char *firstPart);


INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     FILE *afp,*mdffp;
     INT nacts,i;
     CHAR mdfbuf[100],*mp;
     CHAR cmdLine[1024];

     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    "WGSFNDO",MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     if (GetCommandLine(lpCmdLine,cmdLine) != 1) {
          MessageBox(NULL,"Command format is: WGSFNDO <line-id>","WGSFNDO",
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND
                    );
          return(1);
     }
     if ((afp=fopen("wgsmdfs.lst",FOPRA)) == NULL) {
          catastro("WGSFNDO: CAN'T READ \"WGSMDFS.LST\"");
     }
     if (fscanf(afp,"%d",&nacts) != 1) {
          catastro("WGSFNDO: ERROR READING COUNT IN \"WGSMDFS.LST\"");
     }
     for (i=0 ; i < nacts ; i++) {
          if (fscanf(afp,"\n%12s",mdfbuf) != 1) {
               catastro("WGSFNDO: ERROR READING NAME IN \"WGSMDFS.LST\"");
          }
          if ((mdffp=fopen(mdfbuf,FOPRA)) == NULL) {
               catastro("WGSFNDO: CAN'T READ \"%s\"",mdfbuf);
          }
          while (fgets(mdfbuf,sizeof(mdfbuf),mdffp) != NULL) {
               if (sameto(cmdLine,mdfbuf)) {
                    unpad(mdfbuf);
                    mp=mdfbuf+strlen(cmdLine);
                    if (*mp == ':') {
                         mp++;
                    }
                    if (*mp != '\0') {
                         int  retVal;
                         ShellCommand( skpwht( mp ), retVal, FALSE, skpwht( mp ) );
                         //system(skpwht(mp));
                    }
               }
          }
          fclose(mdffp);
     }
     fclose(afp);
     clsvid();
     return(0);
EXCEPT
     return(1);
}


static int GetCommandLine(const char *wholeLine,char *firstPart)
{
     int       count = 0;

     strcpy(firstPart,skpwht(wholeLine));
     
     if (firstPart[ 0 ] != '\0') {
          ++count;
     }

     for (; *firstPart != '\0'; ++firstPart) {
          if (isspace( *firstPart ))
          {
               *firstPart++ = '\0';
               break;
          }
     }

     while (*firstPart != '\0') {
          if (! isspace( *firstPart )) {
               ++count;
          }

          ++firstPart;
     }

     return( count );
}

