/***************************************************************************
 *                                                                         *
 *  FILEUTIL.H                                                             *
 *                                                                         *
 *  File search utilities                                                  *
 *                                                                         *
 *                                                  - Paul Roub  08/29/96  *
 *                                                                         *
 ***************************************************************************/

#if ! defined( FILEUTIL_H )
#  define FILEUTIL_H

BOOL                               //   TRUE if the file exists
FileExists(                        // check for existence of a file (not a subdir)
const CString &fn);                //   filename we're looking for

BOOL                               //   TRUE if the file exists
DirExists(                         // check for existence of a subdir
const CString &fn);                //   filename we're looking for

BOOL                               //   TRUE if an executable was found
ExecutableExists(                  // see if a given command is valid
const CString &fn);                //   command we're checking (e.g. "WGSDRAW")

BOOL                               //   TRUE if an executable was found
which(                             // what program would run as the result of...
const CString &cmdLine,            //   cmdline -- the command we're checking
CString &cmdPath,                  //   the path of the executable (returned)
CString &cmdRoot,                  //   the root of the executable (returned)
CString &cmdExt);                  //   the extension of the executable (returned)

#endif
