// YesNo.cpp : implementation file
//

#include "stdafx.h"
#include "WgsCnf.h"
#include "CnfDoc.h"
#include "modifier.h"
#include "YesNo.h"
#include "OptEdit.h"
#include "CnfAsrt.h"

#define FILREV "$Revision: $"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// YesNoButton

YesNoButton::YesNoButton()
{
     m_next = m_previous = NULL;
}

YesNoButton::~YesNoButton()
{
}


BEGIN_MESSAGE_MAP(YesNoButton, CButton)
     //{{AFX_MSG_MAP(YesNoButton)
     ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
     ON_CONTROL_REFLECT(BN_DOUBLECLICKED, OnDoubleclicked)
     ON_WM_CHAR()
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// YesNoButton message handlers

BOOL YesNoButton::OnCommand(WPARAM wParam, LPARAM lParam) 
{
     // TODO: Add your specialized code here and/or call the base class
     
     return CButton::OnCommand(wParam, lParam);
}

void YesNoButton::OnClicked() 
{
     Select();
}

void YesNoButton::OnDoubleclicked() 
{
     OnClicked();
     return;
}

void YesNoButton::SetKey( const CString &key )
{
     m_count.itemKey = key;
}

void YesNoButton::SetOriginalValue( BOOL checked )
{
     m_origValue = checked;
}

CnfDoc *YesNoButton::GetDocument()
{
     OptionEditView *theView = static_cast< OptionEditView * >( CWnd::GetParent() );
     CnfAssert( theView != NULL );

     CnfDoc *theDoc = static_cast< CnfDoc * >( theView->GetDocument() );
     CnfAssert( theDoc != NULL );

     return( theDoc );
}

void YesNoButton::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
     CButton::OnChar(nChar, nRepCnt, nFlags);

     if (nChar == VK_RETURN)
     {
          CnfDoc *doc = GetDocument();

          doc->UpdateAllViews( NULL, NextVisible );
     }
}

void YesNoButton::SetNext( YesNoButton *next )
{
     m_next = next;
}

void YesNoButton::SetPrevious( YesNoButton *previous )
{
     m_previous = previous;
}

BOOL YesNoButton::PreTranslateMessage(MSG* pMsg) 
{
     if (pMsg->message == WM_KEYDOWN)
     {
          WORD key = pMsg->wParam;

          if ((key == VK_UP) && (m_previous != NULL))
          {
               m_previous->SetCheck( 1 );
               SetCheck( 0 );
               m_previous->SetFocus();
               m_previous->Select();
               return( TRUE );
          }
          else if ((key == VK_DOWN) && (m_next != NULL))
          {
               m_next->SetCheck( 1 );
               SetCheck( 0 );
               m_next->SetFocus();
               m_next->Select();
               return( TRUE );
          }
     }
	
	return CButton::PreTranslateMessage(pMsg);
}

void YesNoButton::Select()
{
     OptionEditView *theView = static_cast< OptionEditView * >( CWnd::GetParent() );
     CnfAssert( theView != NULL );

     CnfDoc *theDoc = static_cast< CnfDoc * >( theView->GetDocument() );
     CnfAssert( theDoc != NULL );

     if (GetCheck() == 1)
     {
          BOOL      changed = ! m_origValue;

          if (changed)
          {
               theDoc->UpdateAllViews( NULL, ItemModified, &m_count );
          }
          else
          {
               theDoc->UpdateAllViews( NULL, ItemUnModified, &m_count );
          }

          TreeData ourData;

          CString value;
          GetWindowText( value );

          theDoc->Lookup( m_count.itemKey, ourData );

          theDoc->Set( m_count.itemKey, ourData );

          ourData.opPtr->curValue = value;

          //   trigger hinging as necessary
          //
          m_count.oldKey = m_count.itemKey;
          m_count.treeData = &ourData;
          theDoc->UpdateAllViews( theView, SelectionChanged, &m_count );
     }

     return;
}
