// WgsCnf.h : main header file for the WgsCnf application
//

#if ! defined( WGSCNF_H )
#  define WGSCNF_H

#ifndef __AFXWIN_H__
     #error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

class CnfDoc;

/////////////////////////////////////////////////////////////////////////////
// WgsCnfApp:
// See WgsCnf.cpp for the implementation of this class
//

class WgsCnfCmdLineInfo : public CCommandLineInfo
{
public:
     WgsCnfCmdLineInfo();
     virtual void ParseParam( LPCTSTR lpszParam, BOOL bFlag, BOOL bLast );
private:
	BOOL m_nextIsOutputFile;
};

class CWgsCnfApp : public CWinApp
{
public:
	void SetDumpFile( LPCTSTR dumpFileName );
	void NoteChanges();
	void ForceExit();
	void SetRegName( const char *st );
     CWgsCnfApp();

// Overrides
     // ClassWizard generated virtual function overrides
     //{{AFX_VIRTUAL(CWgsCnfApp)
	public:
     virtual BOOL InitInstance();
     virtual BOOL OnIdle(LONG lCount);
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

     //{{AFX_MSG(CWgsCnfApp)
     afx_msg void OnAppAbout();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnEditCut();
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateFilePrintPreview(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilePrint(CCmdUI* pCmdUI);
	afx_msg void OnUpdateTextreport(CCmdUI* pCmdUI);
	//}}AFX_MSG
     DECLARE_MESSAGE_MAP()
private:
	CString m_dumpFileName;
	BOOL m_dumpToFile;
	BOOL m_anyChanges;
	BOOL m_runOk;
	BOOL RunWgsInt();
	CString m_regName;
	CnfDoc * GetDocument() const;
};


/////////////////////////////////////////////////////////////////////////////

extern CWgsCnfApp theApp;
extern int level;

#endif
