/***************************************************************************
 *                                                                         *
 *  TREEDATA.H                                                             *
 *                                                                         *
 *  WGSCNF option tree reference structure                                 *
 *                                                                         *
 *                                                  - Paul Roub  08/16/96  *
 *                                                                         *
 ***************************************************************************/



#if ! defined( TREEDATA_H )
#  define TREEDATA_H

#include  <vector>
#include  "option.h"

class  TreeData
{
public:
 TreeData();
     TreeData( const TreeData &oldTd );
    ~TreeData();
     TreeData &operator = ( const TreeData &oldTd );
     BOOL Modified();
     
     int itemLevel;                // this item's option level
     CString filename;             // filename containing this opt
     CString header;               // the option's tree display text
     HTREEITEM treePtr;            // option's tree node pointer
     CString parentKey;            // option's parent key
     option * opPtr;               // pointer to option data
     CString helpText;             // option description text
     CString lineDesc;             // option edit prompt
     int modCount;                 // >0 if item has been modified

     vector< CString, allocator<CString> > hingees;    // options hinging on this
     vector< CString, allocator<CString> > langBlocks; // text block values

private:
     void DecReferences();
};

#endif
