////////////////////////////////////////////////////////////////////////////
//
//  TREEDATA.CPP
//
//  WGSCNF Tree display info
//
//                                                  - Paul Roub  09/17/96
//
/////////////////////////////////////////////////////////////////////////////

#include  "stdafx.h"
#include  "treedata.h"
#include  "lingo.h"
#include "CnfAsrt.h"

#define FILREV "$Revision: 1.1 $"


TreeData::TreeData()
{
     CString   temp;

     hingees.resize( 0, temp );
     langBlocks.resize( 0, temp );
     opPtr = NULL;
     modCount = 0;
}


TreeData::TreeData( const TreeData &oldTd )
{
     opPtr = NULL;
     *this = oldTd;
}


TreeData::~TreeData()
{
     if (opPtr != NULL)
     {
          DecReferences();
     }
}


TreeData & TreeData::operator = ( const TreeData &oldTd )
{
     if (this != &oldTd)
     {
          if (opPtr != NULL)
               DecReferences();

          header    = oldTd.header;
          treePtr   = oldTd.treePtr;
          parentKey = oldTd.parentKey;
          itemLevel = oldTd.itemLevel;
          opPtr     = oldTd.opPtr;

          if (opPtr != NULL)
               ++opPtr->references;

          helpText  = oldTd.helpText;
          lineDesc  = oldTd.lineDesc;
          hingees   = oldTd.hingees;
          langBlocks = oldTd.langBlocks;
          filename  = oldTd.filename;
          modCount = oldTd.modCount;
     }

     return( *this );
}


//   reduce our option's reference count
//   if it goes to (or below) 0, delete it
//
void TreeData::DecReferences()
{
     CnfAssert( opPtr->references > 0 );

     --opPtr->references;

     if (opPtr->references <= 0)
     {
          if (opPtr->values != NULL)
          {
               if (opPtr->type == 'T')
               {
                    altlng *langs = opPtr->values;

                    for ( int count = 0; count < nlingo; ++count )
                    {
                         if (langs[ count ].altered && (langs[ count ].value.ptr != NULL))
                              free( langs[ count ].value.ptr );
                    }
               }

               free( opPtr->values );
               opPtr->values = NULL;
          }

          CnfAssert( (opPtr->origValues != NULL) || (opPtr->type != 'T') );
          CnfAssert( (opPtr->origValues == NULL) || (opPtr->type == 'T') );

          if (opPtr->origValues != NULL)
          {
               delete [] opPtr->origValues;
               opPtr->origValues = NULL;
          }

          delete opPtr;
     }
}


BOOL TreeData::Modified()
{
     CnfAssert( modCount >= 0 );
     return( modCount > 0 );
}
