// StrEdit.h : header file
//

#if ! defined( StringEdit_H )
#  define StringEdit_H

#include  "Modifier.h"
#include  "option.h"

/////////////////////////////////////////////////////////////////////////////
// StringEdit window

class StringEdit : public CEdit
{
// Construction
public:
	BOOL CanUndo() const;
	void SetOriginalValues( const CString *vals );
	void SetOriginalValue( const CString &st );
	virtual BOOL Undo();
	void SetEditDetails( char editType, LONG floor, LONG ceiling = -1 );
	BOOL IsValid();
	void GetWindowText( CString &text );
	void ChangeText( LPCTSTR newText );
	void SelectLanguage( int nLang );
	virtual void SetWindowText( LPCTSTR newText );
	void SetKey( const CString &key );
	StringEdit();
     DECLARE_DYNCREATE(StringEdit)

// Attributes
public:
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(StringEdit)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~StringEdit();
     BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, TreeData *ourData);

	// Generated message map functions
protected:
	//{{AFX_MSG(StringEdit)
	afx_msg void OnChange();
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
private:
	CString m_undoVal;
	CnfDoc * GetDocument();
	const CString * m_origValues;
	CString m_origValue;
	BOOL AnyChangesFromOriginal();
	LONG m_ceiling;
	LONG m_floor;
	char m_editType;
	CString CompressNewLines( const CString &st );
	CString ExpandNewLines( const CString &st );
	int m_curLang;
	void SetOpText( CString &text, int nLang = 0 );
	BOOL m_modified;
	option * m_opt;
	BOOL m_multiLine;
	CString m_oldVal;
	Modifier m_count;
     BOOL m_languageChecked;
     vector< CString, allocator< CString > > blockStrings;
};

/////////////////////////////////////////////////////////////////////////////

#endif
