#if ! defined( REPORT_H )
#  define REPORT_H


class OptionTree;
class CnfDoc;


class Report
{
public:
	void ReportToFile( const char *filename = NULL );
	void SetDoc( CnfDoc *doc );
	void SetTreeView( OptionTree *tv );
	int RowsPerPage( CDC *pDC );
	void PrintPage( CDC *pDC, CPrintInfo *pInfo );
	void Draw( CDC *pDC );
	BOOL PastEnd( CPrintInfo *pInfo );
	void Begin( CDC *pDC, CPrintInfo *pInfo );
     Report();
    ~Report();
private:
	int m_tabstop;
	char GetItemType( HTREEITEM cur );
	BOOL IsSection( HTREEITEM item );
	BOOL IsLevel( HTREEITEM item );
	CString m_curSection;
	void BoxText( CDC *pDC, const CString &outText, int left, int top, int right, int bottom );
	CnfDoc * m_doc;
	HTREEITEM m_first;
	void LineFrom( CDC *pDC, int ypos, int startXpos, int endXpos );
	void Header( CDC *pDC, const CString &title );
	int GetHeaderHeight( CDC *pDC );
	int GetFooterHeight( CDC *pDC );
	void Footer( CDC *pDC );
	OptionTree * m_treeView;
	void PrintRow( HTREEITEM item, int rowNum, CDC *pDC, int textHeight );
     void SetupDate();
	int m_curPage;
	int m_rowsPerPage;
	int m_pastEnd;
	CFont m_boldPrintFont;
	CFont m_printFont;
	BOOL m_pfCreated;
     CString m_reportDate;
	CString m_levelDesc;
	HTREEITEM m_curPrintItem;
};


#endif
