#include  "stdafx.h"
#include  "CnfAsrt.h"
#include  "regutil.h"
#include  "WgsCnf.h"


static CString NextPart( CString &st );
static BYTE atob( const CString &st );


BOOL SaveLogfont( const char *keyName, const char *valueName, const LOGFONT &lf )
{
   CString     outStr;
   outStr.Format( "%li,%li,%li,%li,%li,%u,%u,%u,%u,%u,%u,%u,%u,%s",
                  lf.lfHeight,
                  lf.lfWidth,
                  lf.lfEscapement,
                  lf.lfOrientation,
                  lf.lfWeight,
                  (unsigned int)lf.lfItalic,
                  (unsigned int)lf.lfUnderline,
                  (unsigned int)lf.lfStrikeOut,
                  (unsigned int)lf.lfCharSet,
                  (unsigned int)lf.lfOutPrecision,
                  (unsigned int)lf.lfClipPrecision,
                  (unsigned int)lf.lfQuality,
                  (unsigned int)lf.lfPitchAndFamily,
                  lf.lfFaceName
                );

   return( theApp.WriteProfileString( keyName, valueName, outStr ) );
}


BOOL ReadLogfont( const char *keyName, const char *valueName, LOGFONT &lf )
{
     CString   regVal = theApp.GetProfileString( keyName, valueName );

     if (regVal.GetLength() <= 0)
     {
          return( FALSE );
     }

     memset( &lf, 0, sizeof( LOGFONT ) );

     lf.lfHeight      = atol( NextPart( regVal ) );
     lf.lfWidth       = atol( NextPart( regVal ) );
     lf.lfEscapement  = atol( NextPart( regVal ) );
     lf.lfOrientation = atol( NextPart( regVal ) );
     lf.lfWeight      = atol( NextPart( regVal ) );
     lf.lfItalic = atob( NextPart( regVal ) );
     lf.lfUnderline = atob( NextPart( regVal ) );
     lf.lfStrikeOut = atob( NextPart( regVal ) );
     lf.lfCharSet = atob( NextPart( regVal ) );
     lf.lfOutPrecision = atob( NextPart( regVal ) );
     lf.lfClipPrecision = atob( NextPart( regVal ) );
     lf.lfQuality = atob( NextPart( regVal ) );
     lf.lfPitchAndFamily = atob( NextPart( regVal ) );
     strncpy( lf.lfFaceName, NextPart( regVal ), LF_FACESIZE );

     return( TRUE );
}


static CString NextPart( CString &st )
{
     CString   result;
     int       comma = st.Find( ',' );

     if (comma < 0)
     {
          result = st;
          st.Empty();
     }
     else
     {
          result = st.Left( comma );
          st = st.Mid( comma + 1 );
     }

     return( result );
}


static BYTE atob( const CString &st )
{
     int       i = atoi( st );

     BYTE      b = (BYTE)i;

     CnfAssert( i == b );

     return( b );
}

